/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.projectile;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.client.ESRenderType;
import cn.leolezury.eternalstarlight.common.entity.interfaces.TrailOwner;
import cn.leolezury.eternalstarlight.common.particle.ESSmokeParticleOptions;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.registry.ESEntities;
import cn.leolezury.eternalstarlight.common.util.ESMathUtil;
import cn.leolezury.eternalstarlight.common.util.TrailEffect;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1890;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3855;
import net.minecraft.class_3966;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector4f;

public class GatekeeperFireball
extends class_3855
implements TrailOwner {
    private static final class_2960 TRAIL_TEXTURE = EternalStarlight.id("textures/entity/trail.png");
    private static final String TAG_TARGET = "target";
    private static final String TAG_SPAWNED_TICKS = "spawned_ticks";
    protected static final class_2940<Integer> SPAWNED_TICKS = class_2945.method_12791(GatekeeperFireball.class, (class_2941)class_2943.field_13327);
    @Nullable
    private class_1309 target;
    @Nullable
    private UUID targetId;

    public GatekeeperFireball(class_1299<? extends GatekeeperFireball> entityType, class_1937 level) {
        super(entityType, level);
    }

    public GatekeeperFireball(class_1937 level, class_1309 livingEntity, class_243 motion) {
        super(ESEntities.GATEKEEPER_FIREBALL.get(), livingEntity, motion, level);
    }

    public int getSpawnedTicks() {
        return (Integer)this.method_5841().method_12789(SPAWNED_TICKS);
    }

    public void setSpawnedTicks(int spawnedTicks) {
        this.method_5841().method_12778(SPAWNED_TICKS, (Object)spawnedTicks);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(SPAWNED_TICKS, (Object)0);
    }

    public class_1309 getTarget() {
        return this.target;
    }

    public void setTarget(class_1309 target) {
        this.targetId = target.method_5667();
        this.target = target;
    }

    protected class_2394 method_7467() {
        return ESSmokeParticleOptions.FLAME;
    }

    public boolean method_5863() {
        return false;
    }

    public boolean method_5809() {
        return false;
    }

    public boolean method_5643(class_1282 damageSource, float amount) {
        return false;
    }

    protected boolean method_7468() {
        return false;
    }

    private boolean canReachTarget(double range) {
        class_1309 target = this.getTarget();
        if (target == null) {
            return false;
        }
        return this.method_37908().method_18467(class_1309.class, this.method_5829().method_1014(range)).contains(target);
    }

    protected void method_7488(class_239 hitResult) {
        super.method_7488(hitResult);
        if (!this.method_37908().field_9236 && (this.target == null || this.canReachTarget(5.0))) {
            boolean bl = ESPlatform.INSTANCE.canEntityGrief(this.method_37908(), this.method_24921());
            this.method_37908().method_8537((class_1297)this, this.method_23317(), this.method_23318(), this.method_23321(), 2.0f, bl, class_1937.class_7867.field_40890);
            this.method_31472();
        }
    }

    protected void method_7454(class_3966 entityHitResult) {
        super.method_7454(entityHitResult);
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            if (this.target == null || this.canReachTarget(5.0)) {
                class_1297 entity = entityHitResult.method_17782();
                class_1297 entity2 = this.method_24921();
                class_1282 damageSource = this.method_48923().method_48804((class_3855)this, entity2);
                entity.method_5643(damageSource, 8.0f);
                class_1890.method_60107((class_3218)serverLevel, (class_1297)entity, (class_1282)damageSource);
            }
        }
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().field_9236) {
            class_1937 class_19372;
            if (this.target == null && this.targetId != null && (class_19372 = this.method_37908()) instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                class_1297 class_12972 = serverLevel.method_14190(this.targetId);
                if (class_12972 instanceof class_1309) {
                    class_1309 livingEntity;
                    this.target = livingEntity = (class_1309)class_12972;
                }
                if (this.target == null) {
                    this.targetId = null;
                }
            }
            this.setSpawnedTicks(this.getSpawnedTicks() + 1);
            if (this.getSpawnedTicks() == 60 && this.getTarget() != null) {
                class_243 power = this.getTarget().method_19538().method_1020(this.method_19538()).method_1029().method_1021((double)0.4f);
                this.method_18799(power);
            }
        }
        if (this.getSpawnedTicks() < 60 && this.method_24921() != null) {
            class_1297 owner = this.method_24921();
            float yaw = ESMathUtil.positionToYaw(owner.method_19538(), this.method_19538());
            float pitch = ESMathUtil.positionToPitch(owner.method_19538(), this.method_19538());
            class_243 newPos = ESMathUtil.rotationToPosition(owner.method_19538(), this.method_5739(owner), pitch, yaw + 5.0f);
            this.method_33574(newPos);
        }
    }

    public void method_5749(class_2487 compoundTag) {
        super.method_5749(compoundTag);
        if (compoundTag.method_25928(TAG_TARGET)) {
            this.targetId = compoundTag.method_25926(TAG_TARGET);
        }
        this.setSpawnedTicks(compoundTag.method_10550(TAG_SPAWNED_TICKS));
    }

    public void method_5652(class_2487 compoundTag) {
        super.method_5652(compoundTag);
        if (this.target != null) {
            compoundTag.method_25927(TAG_TARGET, this.target.method_5667());
        }
        compoundTag.method_10569(TAG_SPAWNED_TICKS, this.getSpawnedTicks());
    }

    @Override
    public TrailEffect newTrail() {
        return new TrailEffect(0.5f, 18);
    }

    @Override
    public void updateTrail(TrailEffect effect) {
        class_243 oldPos = new class_243(this.field_6038, this.field_5971, this.field_5989);
        effect.update(oldPos.method_1031(0.0, (double)(this.method_17682() / 2.0f), 0.0));
        if (this.method_31481()) {
            effect.setLength(Math.max(effect.getLength() - 0.5f, 0.0f));
        }
    }

    @Override
    public Vector4f getTrailColor() {
        return new Vector4f(0.98039216f, 0.5882353f, 0.019607844f, 1.5f);
    }

    @Override
    public boolean isTrailFullBright() {
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public class_1921 getTrailRenderType() {
        return ESRenderType.entityTranslucentGlow(TRAIL_TEXTURE);
    }
}

