/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.handler;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.block.fluid.EtherFluid;
import cn.leolezury.eternalstarlight.common.client.helper.ClientHelper;
import cn.leolezury.eternalstarlight.common.config.ESConfig;
import cn.leolezury.eternalstarlight.common.crest.Crest;
import cn.leolezury.eternalstarlight.common.data.ESBiomes;
import cn.leolezury.eternalstarlight.common.data.ESDamageTypes;
import cn.leolezury.eternalstarlight.common.data.ESDimensions;
import cn.leolezury.eternalstarlight.common.data.ESPaintingVariants;
import cn.leolezury.eternalstarlight.common.entity.attack.CrystalCluster;
import cn.leolezury.eternalstarlight.common.entity.living.boss.gatekeeper.TheGatekeeper;
import cn.leolezury.eternalstarlight.common.entity.projectile.AethersentMeteor;
import cn.leolezury.eternalstarlight.common.entity.projectile.EnergySpark;
import cn.leolezury.eternalstarlight.common.entity.projectile.ThrownStarfire;
import cn.leolezury.eternalstarlight.common.entity.projectile.WiltedPetal;
import cn.leolezury.eternalstarlight.common.item.armor.GlaciteArmorItem;
import cn.leolezury.eternalstarlight.common.item.armor.ThermalSpringstoneArmorItem;
import cn.leolezury.eternalstarlight.common.item.combat.HammerItem;
import cn.leolezury.eternalstarlight.common.item.combat.SeedsLauncherAmmoType;
import cn.leolezury.eternalstarlight.common.item.component.Accessory;
import cn.leolezury.eternalstarlight.common.item.interfaces.TickableArmor;
import cn.leolezury.eternalstarlight.common.item.misc.ManaCrystalItem;
import cn.leolezury.eternalstarlight.common.network.NoParametersPacket;
import cn.leolezury.eternalstarlight.common.network.ParticlePacket;
import cn.leolezury.eternalstarlight.common.network.UpdateWeatherPacket;
import cn.leolezury.eternalstarlight.common.particle.ESSmokeParticleOptions;
import cn.leolezury.eternalstarlight.common.particle.ExplosionShockParticleOptions;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.registry.ESAttributes;
import cn.leolezury.eternalstarlight.common.registry.ESBlocks;
import cn.leolezury.eternalstarlight.common.registry.ESCriteriaTriggers;
import cn.leolezury.eternalstarlight.common.registry.ESDataAttachments;
import cn.leolezury.eternalstarlight.common.registry.ESDataComponents;
import cn.leolezury.eternalstarlight.common.registry.ESEntities;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import cn.leolezury.eternalstarlight.common.registry.ESMobEffects;
import cn.leolezury.eternalstarlight.common.registry.ESParticles;
import cn.leolezury.eternalstarlight.common.registry.ESSoundEvents;
import cn.leolezury.eternalstarlight.common.resource.gatekeeper.TheGatekeeperNameManager;
import cn.leolezury.eternalstarlight.common.spell.ManaType;
import cn.leolezury.eternalstarlight.common.util.ConventionalTags;
import cn.leolezury.eternalstarlight.common.util.ESAccessoryUtil;
import cn.leolezury.eternalstarlight.common.util.ESBlockUtil;
import cn.leolezury.eternalstarlight.common.util.ESBookUtil;
import cn.leolezury.eternalstarlight.common.util.ESCrestUtil;
import cn.leolezury.eternalstarlight.common.util.ESEntityUtil;
import cn.leolezury.eternalstarlight.common.util.ESSpellUtil;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import cn.leolezury.eternalstarlight.common.util.ESWeatherUtil;
import cn.leolezury.eternalstarlight.common.util.SpecialItemCooldown;
import cn.leolezury.eternalstarlight.common.weather.AbstractWeather;
import cn.leolezury.eternalstarlight.common.weather.WeatherInstance;
import cn.leolezury.eternalstarlight.common.weather.Weathers;
import cn.leolezury.eternalstarlight.common.world.gen.biomesource.ESBiomeSource;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapDecoder;
import com.mojang.serialization.MapEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1534;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1665;
import net.minecraft.class_1676;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1966;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2509;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2673;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3225;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4140;
import net.minecraft.class_5134;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5253;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8103;
import net.minecraft.class_8779;
import net.minecraft.class_9274;
import net.minecraft.class_9279;
import net.minecraft.class_9326;
import net.minecraft.class_9334;
import net.minecraft.class_9381;
import net.minecraft.server.MinecraftServer;

public class CommonHandlers {
    public static final String STARFIRE_ARROW = "eternal_starlight:starfire";
    public static final String FLOWGLAZE_ARROW = "eternal_starlight:flowglaze";
    public static final String CRYSTAL_ARROW = "eternal_starlight:crystal";
    public static final String MECHANICAL_ARROW = "eternal_starlight:mechanical";
    public static final String STARFALL_ARROW = "eternal_starlight:starfall";
    public static final String WILTED_ARROW = "eternal_starlight:wilted";
    public static TheGatekeeperNameManager gatekeeperNames;
    private static Weathers starlightWeathers;
    private static AbstractWeather lastWeather;
    private static int ticksSinceLastUpdate;
    private static final class_1322 AMARAMBER_BONUS;

    public static String getGatekeeperName() {
        return gatekeeperNames.getTheGatekeeperName();
    }

    public static Optional<WeatherInstance> getActiveWeather() {
        if (starlightWeathers == null) {
            return Optional.empty();
        }
        return starlightWeathers.getActiveWeather();
    }

    public static void onServerTick(MinecraftServer server) {
        if (++ticksSinceLastUpdate >= 20) {
            for (class_3218 level : server.method_3738()) {
                class_1966 class_19662 = level.method_14178().method_12129().method_12098();
                if (!(class_19662 instanceof ESBiomeSource)) continue;
                ESBiomeSource source = (ESBiomeSource)class_19662;
                source.setCacheSize(level.method_18456().size() * 8);
            }
            ticksSinceLastUpdate = 0;
        }
    }

    public static void onLevelLoad(class_3218 serverLevel) {
        if (serverLevel.method_27983() == ESDimensions.STARLIGHT_KEY) {
            starlightWeathers = ESWeatherUtil.getOrCreateWeathers(serverLevel);
        }
    }

    public static void onLevelTick(class_3218 serverLevel) {
        if (serverLevel.method_27983() == ESDimensions.STARLIGHT_KEY && starlightWeathers != null) {
            starlightWeathers.tick();
            long gameTime = serverLevel.method_8510();
            starlightWeathers.getActiveWeather().ifPresentOrElse(weatherInstance -> {
                if (weatherInstance.getWeather() != lastWeather || gameTime % 200L == 0L) {
                    ESPlatform.INSTANCE.sendToAllClients(serverLevel, new UpdateWeatherPacket(weatherInstance.getWeather()));
                    lastWeather = weatherInstance.getWeather();
                }
                if (gameTime % 80L == 0L) {
                    for (class_3222 player : serverLevel.method_18456()) {
                        if (!serverLevel.method_8311(class_2338.method_49638((class_2374)player.method_33571()))) continue;
                        ESCriteriaTriggers.WITNESS_WEATHER.get().trigger(player);
                    }
                }
            }, () -> {
                if (lastWeather != null || gameTime % 200L == 0L) {
                    ESPlatform.INSTANCE.sendToAllClients(serverLevel, new NoParametersPacket("cancel_weather"));
                    lastWeather = null;
                }
            });
        }
    }

    public static void onItemTooltip(class_1657 player, class_1836 flags, class_1799 itemStack, List<class_2561> tooltip, class_1792.class_9635 context) {
        int accessorySlotCount;
        List accessories;
        class_7225.class_7874 lookup = context.method_59527();
        Accessory accessory = (Accessory)itemStack.method_57824(ESDataComponents.ACCESSORY.get());
        if (accessory != null) {
            if (accessory.attributeModifiers().comp_2394() && !accessory.attributeModifiers().comp_2393().isEmpty() || !accessory.extraDescription().isEmpty()) {
                tooltip.add(class_5244.field_39003);
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.eternal_starlight.accessory_combined").method_27692(class_124.field_1080));
            }
            if (accessory.attributeModifiers().comp_2394()) {
                for (class_9274 slotGroup : class_9274.values()) {
                    accessory.attributeModifiers().method_60618(slotGroup, (holder, modifier) -> itemStack.method_57364(tooltip::add, player, holder, modifier));
                }
            }
            for (class_2561 desc : accessory.extraDescription()) {
                tooltip.add((class_2561)class_2561.method_43470((String)" ").method_10852(desc));
            }
            tooltip.add(class_5244.field_39003);
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.eternal_starlight.accessory_combination_target").method_27692(class_124.field_1080));
            tooltip.add((class_2561)class_2561.method_43470((String)" ").method_10852(accessory.combinationTargetDescription()));
        }
        if (itemStack.method_57826(ESDataComponents.ACCESSORIES.get()) && !(accessories = (List)itemStack.method_57825(ESDataComponents.ACCESSORIES.get(), new ArrayList())).isEmpty()) {
            tooltip.add(class_5244.field_39003);
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.eternal_starlight.accessories").method_27692(class_124.field_1080));
            accessories.forEach(accessoryStack -> {
                Accessory data = (Accessory)accessoryStack.method_57824(ESDataComponents.ACCESSORY.get());
                class_5250 name = class_2561.method_43470((String)" ").method_10852(accessoryStack.method_7964());
                if (data != null && data.nameStyle().isPresent()) {
                    name.method_27696(data.nameStyle().get());
                }
                tooltip.add((class_2561)name);
                if (data != null) {
                    for (class_2561 desc : data.extraDescription()) {
                        tooltip.add((class_2561)class_2561.method_43470((String)" ").method_10852(desc));
                    }
                }
            });
        }
        if ((accessorySlotCount = ((Integer)itemStack.method_57825(ESDataComponents.ACCESSORY_SLOT_COUNT.get(), (Object)1)).intValue()) > 1) {
            tooltip.add(class_5244.field_39003);
            tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.eternal_starlight.accessory_slot_count", (Object[])new Object[]{accessorySlotCount}).method_27692(class_124.field_1078));
        }
        if (itemStack.method_31573(ESTags.Items.FLOWGLAZE_WEAPONS)) {
            tooltip.add(class_5244.field_39003);
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.eternal_starlight.flowglaze_weapon").method_54663(9361072));
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.eternal_starlight.flowglaze_tool").method_54663(9361072));
        }
        if (itemStack.method_31574(ESItems.FLOWGLAZE_BOW.get())) {
            tooltip.add(class_5244.field_39003);
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.eternal_starlight.flowglaze_bow").method_54663(9361072));
        }
        if (itemStack.method_31574(ESItems.FLOWGLAZE_SHIELD.get())) {
            tooltip.add(class_5244.field_39003);
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.eternal_starlight.flowglaze_shield").method_54663(9361072));
        }
        if (player != null && lookup != null && itemStack.method_31573(ESTags.Items.SEEDS_LAUNCHER_AMMO) && player.method_31548().method_55753(stack -> stack.method_7909() == ESItems.SEEDS_LAUNCHER.get())) {
            String speed;
            tooltip.add(class_5244.field_39003);
            SeedsLauncherAmmoType type = (SeedsLauncherAmmoType)SeedsLauncherAmmoType.getAmmoType(lookup, itemStack.method_7909()).comp_349();
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.eternal_starlight.seeds_launcher.ammo").method_27692(class_124.field_1080));
            String damage = Math.round((type.damageMultiplier() - 1.0f) * 100.0f) + "%";
            if (!damage.startsWith("-")) {
                damage = "+" + damage;
            }
            if (!(speed = Math.round((type.speedMultiplier() - 1.0f) * 100.0f) + "%").startsWith("-")) {
                speed = "+" + speed;
            }
            if (!damage.equals("+0%")) {
                tooltip.add((class_2561)class_2561.method_43470((String)" ").method_10852((class_2561)class_2561.method_43469((String)"tooltip.eternal_starlight.seeds_launcher.damage_multiplier", (Object[])new Object[]{damage}).method_27692(damage.startsWith("-") ? class_124.field_1061 : class_124.field_1078)));
            }
            if (!speed.equals("+0%")) {
                tooltip.add((class_2561)class_2561.method_43470((String)" ").method_10852((class_2561)class_2561.method_43469((String)"tooltip.eternal_starlight.seeds_launcher.speed_multiplier", (Object[])new Object[]{speed}).method_27692(speed.startsWith("-") ? class_124.field_1061 : class_124.field_1078)));
            }
            tooltip.add((class_2561)class_2561.method_43470((String)" ").method_10852((class_2561)class_2561.method_43469((String)"tooltip.eternal_starlight.seeds_launcher.cooldown", (Object[])new Object[]{Float.valueOf(type.cooldown())}).method_27692(class_124.field_1077)));
        }
        if (itemStack.method_31574(ESItems.UNDERMINER.get())) {
            tooltip.add(class_5244.field_39003);
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.eternal_starlight.underminer").method_54663(4697540));
        }
    }

    public static float onModifyLivingActualHurtDamage(class_1309 entity, class_1282 source, float amount) {
        float modified = amount;
        Set<class_1792> activeAccessories = ESAccessoryUtil.getActiveAccessoriesOnArmors(entity);
        if (activeAccessories.contains(ESItems.CRESCENT_PENDANT.get()) && !source.method_48789(ESTags.DamageTypes.BYPASSES_CRESCENT_PENDANT) && modified > entity.method_6063() * 0.75f) {
            modified = entity.method_6063() * 0.75f;
        }
        if (entity.method_6059(ESMobEffects.NUMBNESS.asHolder())) {
            ESDataAttachments.NUMBNESS_DAMAGE.setData((class_1297)entity, Float.valueOf(ESDataAttachments.NUMBNESS_DAMAGE.getData((class_1297)entity).floatValue() + modified * 0.75f));
            modified *= 0.25f;
        }
        if (source.method_48789(class_8103.field_42242)) {
            return Math.max(amount, modified);
        }
        return modified;
    }

    public static float onModifyLivingHurtDamage(class_1309 entity, class_1282 source, float amount) {
        class_1309 attacker;
        class_1297 class_12972;
        float modified = amount;
        class_1297 sourceEntity = source.method_5529();
        if (sourceEntity != null) {
            if (sourceEntity.method_5864() == ESEntities.THE_GATEKEEPER.get()) {
                modified *= 1.0f + (float)class_3532.method_15340((int)ESDataAttachments.GATEKEEPER_CHALLENGE_COUNT.getData((class_1297)entity), (int)0, (int)40) * 0.05f;
            }
            if (sourceEntity.method_5864() == ESEntities.STARLIGHT_GOLEM.get()) {
                modified *= (float)ESConfig.INSTANCE.mobsConfig.starlightGolem.attackDamageScale();
            }
            if (sourceEntity.method_5864() == ESEntities.LUNAR_MONSTROSITY.get()) {
                modified *= (float)ESConfig.INSTANCE.mobsConfig.lunarMonstrosity.attackDamageScale();
            }
        }
        if (source.method_48789(class_8103.field_42246)) {
            class_1324 resistance;
            class_1293 instance;
            if (entity.method_6059(ESMobEffects.FLAMMABLE.asHolder()) && (instance = entity.method_6112(ESMobEffects.FLAMMABLE.asHolder())) != null) {
                modified *= (float)(instance.method_5578() + 2);
            }
            if ((resistance = entity.method_5996(ESAttributes.FIRE_RESISTANCE.asHolder())) != null) {
                modified *= 1.0f - (float)resistance.method_6194();
            }
        }
        if ((class_12972 = source.method_5526()) instanceof class_1309 && (attacker = (class_1309)class_12972).method_59958().method_31573(ESTags.Items.FLOWGLAZE_WEAPONS) && entity == ESDataAttachments.CONCENTRATED_TARGET.getData((class_1297)attacker) && attacker.method_59958() == ESDataAttachments.CONCENTRATED_WEAPON.getData((class_1297)attacker) && ESDataAttachments.CONCENTRATION_LEVEL.getData((class_1297)attacker) >= 4) {
            modified *= 1.25f;
        }
        if ((class_12972 = source.method_5526()) instanceof class_1309 && ESAccessoryUtil.getAccessories((attacker = (class_1309)class_12972).method_59958()).contains(ESItems.WARHAMMER_PENDANT.get())) {
            modified *= Math.min(1.0f + (float)ESDataAttachments.MOVEMENT.getData((class_1297)attacker).method_1033() * 1.5f, 2.0f);
        }
        if (source.method_48789(class_8103.field_42242)) {
            return Math.max(amount, modified);
        }
        return modified;
    }

    public static void onPostLivingHurt(class_1309 entity, class_1282 source, float amount) {
        class_1297 inEtherTicks;
        class_1657 player;
        class_1297 inEtherTicks22;
        int inEtherTicks22;
        class_1297 living3;
        class_1309 attacker;
        Object serverLevel;
        class_1309 livingEntity;
        class_1297 class_12972;
        class_1324 meteorChance;
        Object serverLevel2;
        class_1309 attacker2;
        class_1309 livingEntity2;
        class_1297 class_12973;
        if ((entity.method_6118(class_1304.field_6169).method_7909() instanceof ThermalSpringstoneArmorItem || entity.method_6118(class_1304.field_6174).method_7909() instanceof ThermalSpringstoneArmorItem || entity.method_6118(class_1304.field_6172).method_7909() instanceof ThermalSpringstoneArmorItem || entity.method_6118(class_1304.field_6166).method_7909() instanceof ThermalSpringstoneArmorItem) && (class_12973 = source.method_5526()) instanceof class_1309) {
            livingEntity2 = (class_1309)class_12973;
            livingEntity2.method_20803(livingEntity2.method_20802() + 200);
        }
        if ((class_12973 = source.method_5526()) instanceof class_1309 && (attacker2 = (class_1309)class_12973).method_59958().method_31573(ESTags.Items.THERMAL_SPRINGSTONE_WEAPONS)) {
            entity.method_20803(entity.method_20802() + 200);
        }
        if ((entity.method_6118(class_1304.field_6169).method_7909() instanceof GlaciteArmorItem || entity.method_6118(class_1304.field_6174).method_7909() instanceof GlaciteArmorItem || entity.method_6118(class_1304.field_6172).method_7909() instanceof GlaciteArmorItem || entity.method_6118(class_1304.field_6166).method_7909() instanceof GlaciteArmorItem) && (class_12973 = source.method_5526()) instanceof class_1309) {
            livingEntity2 = (class_1309)class_12973;
            livingEntity2.method_32317(Math.min(livingEntity2.method_32312() + 80, 300));
        }
        if ((class_12973 = source.method_5526()) instanceof class_1309 && (attacker2 = (class_1309)class_12973).method_59958().method_31573(ESTags.Items.GLACITE_WEAPONS) && entity.method_32316()) {
            entity.method_32317(Math.min(entity.method_32312() + 80, 300));
        }
        if ((class_12973 = source.method_5526()) instanceof class_1309 && (attacker2 = (class_1309)class_12973).method_59958().method_31573(ESTags.Items.MALARITE_WEAPONS)) {
            entity.method_6092(new class_1293(class_1294.field_5899, 60));
        }
        if ((class_12973 = source.method_5526()) instanceof class_1309 && (attacker2 = (class_1309)class_12973).method_59958().method_31573(ESTags.Items.PUNGENCY_FRUIT_WEAPONS)) {
            entity.method_6092(new class_1293(class_1294.field_5899, 80, 1));
            entity.method_6092(new class_1293(class_1294.field_5916, 120));
        }
        if ((class_12973 = source.method_5526()) instanceof class_1309 && (attacker2 = (class_1309)class_12973).method_59958().method_31573(ESTags.Items.STARFIRE_WEAPONS)) {
            entity.method_6092(new class_1293(ESMobEffects.STARFIRE.asHolder(), 60));
            class_1937 class_19372 = attacker2.method_37908();
            if (class_19372 instanceof class_3218) {
                serverLevel2 = (class_3218)class_19372;
                ThrownStarfire.createExplosionParticles((class_3218)serverLevel2, entity.method_19538().method_1031(0.0, (double)(entity.method_17682() / 2.0f), 0.0), 5, 0.25);
            }
            attacker2.method_37908().method_45447(null, attacker2.method_24515(), ESSoundEvents.STARFIRE_WHOOSH.get(), attacker2.method_5634());
        }
        if ((serverLevel2 = source.method_5526()) instanceof class_1309 && !((attacker2 = (class_1309)serverLevel2) instanceof class_1657)) {
            CommonHandlers.handleFlowglazeWeaponAttack(attacker2, entity);
        }
        if ((meteorChance = entity.method_5996(ESAttributes.METEOR_COUNTERATTACK_CHANCE.asHolder())) != null && entity.method_59922().method_43058() < meteorChance.method_6194() && (class_12972 = source.method_5529()) instanceof class_1309 && (class_12972 = (livingEntity = (class_1309)class_12972).method_37908()) instanceof class_3218) {
            serverLevel = (class_3218)class_12972;
            class_243 location = livingEntity.method_19538();
            AethersentMeteor.createMeteorShower((class_1937)serverLevel, entity, livingEntity, location.field_1352, location.field_1351, location.field_1350, 30.0);
        }
        if ((serverLevel = source.method_5526()) instanceof class_1309 && (attacker = (class_1309)serverLevel).method_59958().method_31574(ESItems.PETAL_SCYTHE.get())) {
            class_1937 living22;
            for (class_1937 living22 : entity.method_37908().method_18467(class_1309.class, entity.method_5829().method_1014(2.5))) {
                if (living22 == attacker) continue;
                living22.method_6092(new class_1293(class_1294.field_5899, 80, 1));
            }
            living22 = attacker.method_37908();
            if (living22 instanceof class_3218) {
                serverLevel = (class_3218)living22;
                class_243 vec3 = entity.method_19538().method_1031(0.0, (double)(entity.method_17682() / 2.0f), 0.0);
                serverLevel.method_14199((class_2394)ESSmokeParticleOptions.LUNAR_ATTACK, vec3.field_1352, vec3.field_1351, vec3.field_1350, 10, 1.5 * ((double)serverLevel.method_8409().method_43057() - 0.5), 1.5 * ((double)serverLevel.method_8409().method_43057() - 0.5), 1.5 * ((double)serverLevel.method_8409().method_43057() - 0.5), 0.1 * ((double)serverLevel.method_8409().method_43057() - 0.5));
            }
        }
        if (entity.method_6059(ESMobEffects.STARFIRE.asHolder()) && !source.method_49708(ESDamageTypes.STARFIRE)) {
            serverLevel = entity.method_37908();
            if (serverLevel instanceof class_3218) {
                serverLevel2 = (class_3218)serverLevel;
                ThrownStarfire.createExplosionParticles((class_3218)serverLevel2, entity.method_19538().method_1031(0.0, (double)(entity.method_17682() / 2.0f), 0.0), 6, 0.75);
            }
            for (class_1297 living3 : entity.method_37908().method_18467(class_1309.class, entity.method_5829().method_1014(3.0))) {
                if (!ESEntityUtil.shouldHarm(source.method_5529(), living3)) continue;
                living3.method_5643(ESDamageTypes.getIndirectEntityDamageSource(entity.method_37908(), ESDamageTypes.STARFIRE, source.method_5526(), source.method_5529()), amount / 3.0f);
            }
        }
        if (ESAccessoryUtil.getActiveAccessoriesOnArmors(entity).contains(ESItems.BUTTERFLY_WINGS_AMULET.get()) && (living3 = source.method_5529()) instanceof class_1309 && (inEtherTicks22 = ESDataAttachments.IN_ETHER_TICKS.getData((class_1297)(attacker = (class_1309)living3)).intValue()) < 600) {
            ESDataAttachments.IN_ETHER_TICKS.setData((class_1297)attacker, Math.min(inEtherTicks22 + 200, 600));
        }
        if ((inEtherTicks22 = source.method_5529()) instanceof class_1309 && ESAccessoryUtil.getActiveAccessoriesOnArmors(attacker = (class_1309)inEtherTicks22).contains(ESItems.BUTTERFLY_WINGS_AMULET.get()) && (inEtherTicks = ESDataAttachments.IN_ETHER_TICKS.getData((class_1297)entity).intValue()) < 600) {
            ESDataAttachments.IN_ETHER_TICKS.setData((class_1297)entity, Math.min(inEtherTicks + 200, 600));
        }
        if (entity instanceof class_1657 && (player = (class_1657)entity).method_37908().method_23753(player.method_24515()).method_40225(ESBiomes.THE_ABYSS) && player.method_5777(class_3486.field_15517) && player.method_5669() > 0) {
            player.method_5855(Math.max(player.method_5669() - 30, 0));
        }
        if ((inEtherTicks = source.method_5526()) instanceof class_1657 && (player = (class_1657)inEtherTicks).method_59922().method_43048(15) == 0) {
            class_1661 inventory = player.method_31548();
            boolean hasCrystals = false;
            for (int i = 0; i < inventory.method_5439(); ++i) {
                if (!inventory.method_5438(i).method_31573(ESTags.Items.MANA_CRYSTALS)) continue;
                hasCrystals = true;
            }
            if (hasCrystals) {
                class_1542 itemEntity = new class_1542(player.method_37908(), entity.method_23317(), entity.method_23318(), entity.method_23321(), ESItems.MANA_CRYSTAL_SHARD.get().method_7854());
                player.method_37908().method_8649((class_1297)itemEntity);
            }
        }
    }

    public static float onLivingHeal(class_1309 entity, float amount) {
        float modified = amount;
        class_1324 healMultiplier = entity.method_5996(ESAttributes.HEAL_MULTIPLIER.asHolder());
        if (healMultiplier != null) {
            modified *= (float)healMultiplier.method_6194();
        }
        return modified;
    }

    public static void handleFlowglazeWeaponAttack(class_1309 attacker, class_1309 entity) {
        if (attacker.method_59958().method_31573(ESTags.Items.FLOWGLAZE_WEAPONS)) {
            class_1799 stack = attacker.method_59958();
            if (entity == ESDataAttachments.CONCENTRATED_TARGET.getData((class_1297)attacker) && stack == ESDataAttachments.CONCENTRATED_WEAPON.getData((class_1297)attacker)) {
                ESDataAttachments.LAST_CONCENTRATED_ATTACK_TIME.setData((class_1297)attacker, attacker.field_6012);
                ESDataAttachments.CONCENTRATION_LEVEL.setData((class_1297)attacker, Math.min(ESDataAttachments.CONCENTRATION_LEVEL.getData((class_1297)attacker) + 1, 4));
            } else {
                ESDataAttachments.CONCENTRATED_TARGET.setData((class_1297)attacker, entity);
                ESDataAttachments.CONCENTRATED_WEAPON.setData((class_1297)attacker, stack);
                ESDataAttachments.LAST_CONCENTRATED_ATTACK_TIME.setData((class_1297)attacker, attacker.field_6012);
                ESDataAttachments.CONCENTRATION_LEVEL.setData((class_1297)attacker, 0);
            }
        }
    }

    public static boolean onAllowLivingDeath(class_1309 entity, class_1282 source) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            class_1297 class_12972 = source.method_5529();
            if (class_12972 instanceof TheGatekeeper) {
                TheGatekeeper gatekeeper = (TheGatekeeper)class_12972;
                gatekeeper.abortFight();
                player.method_6033(Math.max(player.method_6032(), player.method_6063() * 0.1f));
                player.field_6008 = 200;
                class_1937 class_19372 = entity.method_37908();
                if (class_19372 instanceof class_3218) {
                    class_3218 serverLevel = (class_3218)class_19372;
                    class_5819 random = serverLevel.method_8409();
                    for (int i = 0; i <= 25; ++i) {
                        ESPlatform.INSTANCE.sendToAllClients(serverLevel, new ParticlePacket(ExplosionShockParticleOptions.DEATH, player.method_23317() + (double)((random.method_43057() - 0.5f) * player.method_17681() * 3.0f), player.method_23318(), player.method_23321() + (double)((random.method_43057() - 0.5f) * player.method_17681() * 3.0f), 0.0, 1.0, 0.0));
                    }
                }
                return false;
            }
        }
        return true;
    }

    public static void onLivingDeath(class_1309 entity, class_1282 source) {
        class_1297 class_12972;
        if (entity.method_6059(ESMobEffects.STARFIRE.asHolder())) {
            for (class_1309 living : entity.method_37908().method_18467(class_1309.class, entity.method_5829().method_1014(3.0))) {
                class_1293 instance;
                if (living == entity || living == source.method_5526() || (instance = entity.method_6112(ESMobEffects.STARFIRE.asHolder())) == null) continue;
                living.method_6092(new class_1293(ESMobEffects.STARFIRE.asHolder(), Math.max(instance.method_5584() / 2, 20)));
            }
        }
        if ((class_12972 = source.method_5529()) instanceof class_3222) {
            class_3222 player = (class_3222)class_12972;
            ESBookUtil.unlock(player, class_7923.field_41177.method_10221((Object)entity.method_5864()).method_45138("entity_killed_"));
        }
    }

    public static class_1309 onLivingChangeTarget(class_1309 entity, class_1309 newTarget) {
        int tearyTicks;
        if (newTarget != null && entity.method_6059(ESMobEffects.TEARY.asHolder()) && (tearyTicks = ESDataAttachments.TEARY_TICKS.getData((class_1297)entity).intValue()) <= ESConfig.INSTANCE.mobMaxTearyTicks) {
            return null;
        }
        return newTarget;
    }

    public static int onLivingDecreaseAirSupply(class_1309 entity) {
        if (entity.method_6118(class_1304.field_6169).method_41406(ESItems.AIR_SAC_MASK.asHolder())) {
            if (entity.method_5681()) {
                return entity.method_59922().method_43056() ? -1 : 0;
            }
            if (ESDataAttachments.MOVEMENT.getData((class_1297)entity).method_18805(1.0, 0.0, 1.0).method_1033() < 0.01) {
                return 1;
            }
        }
        return 0;
    }

    public static void onEntityTick(class_1297 entity) {
        int inAbyssalFireTicks;
        class_1799 copy;
        class_1937 level = entity.method_37908();
        if (entity instanceof class_1542) {
            class_1542 item = (class_1542)entity;
            if (!level.field_9236) {
                if (item.field_6012 % 100 == 0 && ESBlockUtil.isEntityInBlock((class_1297)item, (class_2248)ESBlocks.ETHER.get())) {
                    class_1799 content = item.method_6983();
                    if (content.method_31573(ConventionalTags.Items.MUSIC_DISCS) && !content.method_31574(ESItems.MUSIC_DISC_SPIRIT.get())) {
                        item.method_6979(ESItems.MUSIC_DISC_SPIRIT.get().method_7854());
                        item.method_45319(new class_243(0.0, 0.75, 0.0));
                        level.method_8396(null, item.method_24515(), ESSoundEvents.ETHER_TRANSFORM.get(), class_3419.field_15245, 1.0f, 1.0f);
                    } else if (content.method_31574(ESItems.STARLIT_PAINTING.get())) {
                        data = (class_9279)content.method_57824(class_9334.field_49609);
                        if (data != null) {
                            class_6880 variant = (class_6880)data.method_59980((DynamicOps)level.method_30349().method_57093((DynamicOps)class_2509.field_11560), (MapDecoder)class_1534.field_49238).getOrThrow();
                            class_9279 newData = null;
                            if (variant.method_40225(ESPaintingVariants.ENERGIZED)) {
                                newData = (class_9279)data.method_57447((DynamicOps)level.method_30349().method_57093((DynamicOps)class_2509.field_11560), (MapEncoder)class_1534.field_49238, (Object)level.method_30349().method_30530(class_7924.field_41209).method_40290(ESPaintingVariants.ENERGIZED_SPECIAL)).getOrThrow();
                            } else if (variant.method_40225(ESPaintingVariants.MONSTROUS)) {
                                newData = (class_9279)data.method_57447((DynamicOps)level.method_30349().method_57093((DynamicOps)class_2509.field_11560), (MapEncoder)class_1534.field_49238, (Object)level.method_30349().method_30530(class_7924.field_41209).method_40290(ESPaintingVariants.MONSTROUS_SPECIAL)).getOrThrow();
                            }
                            if (newData != null) {
                                copy = content.method_7972();
                                copy.method_57379(class_9334.field_49609, newData);
                                item.method_6979(copy);
                                item.method_45319(new class_243(0.0, 0.75, 0.0));
                            }
                        }
                        level.method_8396(null, item.method_24515(), ESSoundEvents.ETHER_TRANSFORM.get(), class_3419.field_15245, 1.0f, 1.0f);
                    } else if (content.method_31573(ESTags.Items.ACCESSORIES)) {
                        item.method_6979(ESItems.BUTTERFLY_WINGS_AMULET.get().method_7854());
                        item.method_45319(new class_243(0.0, 0.75, 0.0));
                        level.method_8396(null, item.method_24515(), ESSoundEvents.ETHER_TRANSFORM.get(), class_3419.field_15245, 1.0f, 1.0f);
                    }
                }
            } else if (item.method_6983().method_31573(ESTags.Items.MANA_CRYSTALS) || item.method_6983().method_7909() == ESItems.MANA_CRYSTAL_SHARD.get()) {
                ManaType manaType;
                ClientHelper clientHelper = EternalStarlight.getClientHelper();
                data = item.method_6983().method_7909();
                if (data instanceof ManaCrystalItem) {
                    ManaCrystalItem crystalItem = (ManaCrystalItem)((Object)data);
                    manaType = crystalItem.getManaType();
                } else {
                    manaType = ManaType.LUNAR;
                }
                clientHelper.spawnManaCrystalItemParticles(manaType, item.method_19538().method_1031(0.0, (double)(item.method_17682() / 2.0f), 0.0));
            }
        }
        if (!level.field_9236 && (inAbyssalFireTicks = ESDataAttachments.IN_ABYSSAL_FIRE_TICKS.getData(entity).intValue()) > 0) {
            ESDataAttachments.IN_ABYSSAL_FIRE_TICKS.setData(entity, inAbyssalFireTicks - 1);
        }
        if (!level.field_9236 && entity instanceof class_1665) {
            class_1665 arrow = (class_1665)entity;
            if (arrow.method_54759().method_57826(ESDataComponents.QUIVER_ARROW.get())) {
                arrow.method_54759().method_57381(ESDataComponents.QUIVER_ARROW.get());
            }
            if (!arrow.field_7588) {
                float previousExtra;
                if (ESDataAttachments.ARROW_TYPE.getData((class_1297)arrow).equals(FLOWGLAZE_ARROW) && (previousExtra = ESDataAttachments.FLOWGLAZE_ARROW_EXTRA_BASE_DAMAGE.getData((class_1297)arrow).floatValue()) < 3.0f) {
                    arrow.method_7438(arrow.method_7448() + 0.1);
                    ESDataAttachments.FLOWGLAZE_ARROW_EXTRA_BASE_DAMAGE.setData((class_1297)arrow, Float.valueOf(previousExtra + 0.1f));
                }
                if (ESDataAttachments.ARROW_TYPE.getData((class_1297)arrow).equals(WILTED_ARROW)) {
                    List affected = level.method_18467(class_1309.class, entity.method_5829().method_1014(5.0));
                    affected.removeIf(e -> !ESEntityUtil.shouldHarm(arrow.method_24921(), (class_1297)e));
                    for (class_1309 living : affected) {
                        living.method_6092(new class_1293(class_1294.field_5909, 80));
                        living.method_6092(new class_1293(class_1294.field_5920, entity.method_5799() ? 300 : 160));
                    }
                    if (arrow.field_6012 % 4 == 0) {
                        for (int i = 0; i < 3; ++i) {
                            WiltedPetal wiltedPetal;
                            copy = arrow.method_24921();
                            if (copy instanceof class_1309) {
                                class_1309 living = (class_1309)copy;
                                wiltedPetal = new WiltedPetal(level, living);
                            } else {
                                wiltedPetal = new WiltedPetal(ESEntities.WILTED_PETAL.get(), level);
                            }
                            WiltedPetal petal = wiltedPetal;
                            petal.method_33574(entity.method_19538());
                            class_243 movement = new class_243((double)entity.method_59922().method_43057() - 0.5, (double)entity.method_59922().method_43057() - 0.5, (double)entity.method_59922().method_43057() - 0.5);
                            if (affected.size() > i) {
                                class_1309 target = (class_1309)affected.get(i);
                                movement = target.method_19538().method_1031(0.0, (double)(target.method_17682() / 2.0f), 0.0).method_1020(entity.method_19538());
                            }
                            petal.method_7485(movement.field_1352, movement.field_1351, movement.field_1350, 0.8f, 0.2f);
                            level.method_8649((class_1297)petal);
                        }
                    }
                    if (level instanceof class_3218) {
                        class_3218 serverLevel = (class_3218)level;
                        serverLevel.method_14199((class_2394)class_9381.method_58256((class_2396)class_2398.field_11226, (int)class_5253.class_5254.method_58144((int)96, (int)9437243)), entity.method_23317(), entity.method_23318(), entity.method_23321(), 6, 2.0, 2.0, 2.0, 0.2);
                    }
                }
            }
        }
        if (entity instanceof class_1309) {
            class_1792 serverLevel;
            class_1309 livingEntity = (class_1309)entity;
            ESSpellUtil.tickSpells(livingEntity);
            SpecialItemCooldown.tick((class_1297)livingEntity);
            if (livingEntity instanceof class_1657) {
                class_1657 player = (class_1657)livingEntity;
                if (!level.field_9236) {
                    ESCrestUtil.tickCrests(player);
                    if (level.method_23753(player.method_24515()).method_40225(ESBiomes.THE_ABYSS) && player.method_5777(class_3486.field_15517) && player.method_23318() < 0.0) {
                        int maxAir = Math.max((int)Math.round(((double)player.method_5748() + player.method_23318() * 3.0) / 30.0) * 30 - 15, 0);
                        if (player.method_5669() > maxAir) {
                            player.method_5855(maxAir);
                        }
                    }
                    if (ESAccessoryUtil.getActiveAccessoriesOnArmors((class_1309)player).contains(ESItems.PEARL_NECKLACE.get()) && !player.method_5777(class_3486.field_15517)) {
                        player.method_5855(player.method_5748());
                    }
                    class_1661 inventory = player.method_31548();
                    for (int i = 0; i < inventory.method_5439(); ++i) {
                        if (!inventory.method_5438(i).method_57826(ESDataComponents.QUIVER_ARROW.get())) continue;
                        inventory.method_5438(i).method_57381(ESDataComponents.QUIVER_ARROW.get());
                    }
                    if (player.method_6047().method_31574(ESItems.GRAVITY_PICKAXE.get()) || player.method_6079().method_31574(ESItems.GRAVITY_PICKAXE.get())) {
                        for (class_1542 itemEntity : level.method_18467(class_1542.class, player.method_5829().method_1014(5.0))) {
                            itemEntity.method_5694(player);
                        }
                    }
                    if (player instanceof class_3222) {
                        class_3222 serverPlayer = (class_3222)player;
                        if (player.field_6012 % 200 == 0) {
                            for (int i = 0; i < inventory.method_5439(); ++i) {
                                class_1799 inventoryItem = inventory.method_5438(i);
                                if (inventoryItem.method_7960()) continue;
                                ESBookUtil.unlock(serverPlayer, class_7923.field_41178.method_10221((Object)inventoryItem.method_7909()).method_45138("item_"));
                            }
                        }
                        class_3225 gameMode = serverPlayer.field_13974;
                        serverLevel = serverPlayer.method_51469();
                        if (gameMode.field_14003 && serverPlayer.method_6047().method_31573(ESTags.Items.FLOWGLAZE_WEAPONS)) {
                            class_2338 oldTarget = ESDataAttachments.FLOWGLAZE_DESTROY_BLOCK_TARGET.getData((class_1297)serverPlayer);
                            if (oldTarget != null && !oldTarget.equals((Object)gameMode.field_20327)) {
                                ESDataAttachments.FLOWGLAZE_DESTROY_BLOCK_TICKS.setData((class_1297)serverPlayer, 0);
                            }
                            ESDataAttachments.FLOWGLAZE_DESTROY_BLOCK_TARGET.setData((class_1297)serverPlayer, gameMode.field_20327);
                            ESDataAttachments.FLOWGLAZE_DESTROY_BLOCK_TICKS.setData((class_1297)serverPlayer, ESDataAttachments.FLOWGLAZE_DESTROY_BLOCK_TICKS.getData((class_1297)serverPlayer) + 1);
                            class_2680 destroyState = serverLevel.method_8320(gameMode.field_20327);
                            if (ESDataAttachments.FLOWGLAZE_DESTROY_BLOCK_TICKS.getData((class_1297)serverPlayer) >= 100 && destroyState.method_26165((class_1657)serverPlayer, (class_1922)serverLevel, gameMode.field_20327) > 0.0f && (!destroyState.method_29291() || serverPlayer.method_6047().method_7951(destroyState))) {
                                int id = class_2248.method_9507((class_2680)destroyState);
                                gameMode.method_14266(gameMode.field_20327);
                                for (int i = 0; i < serverLevel.method_18456().size(); ++i) {
                                    ((class_3222)serverLevel.method_18456().get((int)i)).field_13987.method_14364((class_2596)new class_2673(2001, gameMode.field_20327, id, false));
                                }
                            }
                        } else if (ESDataAttachments.FLOWGLAZE_DESTROY_BLOCK_TARGET.hasData((class_1297)serverPlayer) || ESDataAttachments.FLOWGLAZE_DESTROY_BLOCK_TICKS.hasData((class_1297)serverPlayer)) {
                            ESDataAttachments.FLOWGLAZE_DESTROY_BLOCK_TARGET.removeData((class_1297)serverPlayer);
                            ESDataAttachments.FLOWGLAZE_DESTROY_BLOCK_TICKS.removeData((class_1297)serverPlayer);
                        }
                    }
                }
            }
            if (ESDataAttachments.CONCENTRATION_LEVEL.getData((class_1297)livingEntity) > 0 && (livingEntity.field_6012 - ESDataAttachments.LAST_CONCENTRATED_ATTACK_TIME.getData((class_1297)livingEntity) > 100 || livingEntity.method_59958() != ESDataAttachments.CONCENTRATED_WEAPON.getData((class_1297)livingEntity))) {
                ESDataAttachments.CONCENTRATED_TARGET.removeData((class_1297)livingEntity);
                ESDataAttachments.CONCENTRATED_WEAPON.removeData((class_1297)livingEntity);
                ESDataAttachments.LAST_CONCENTRATED_ATTACK_TIME.removeData((class_1297)livingEntity);
                ESDataAttachments.CONCENTRATION_LEVEL.removeData((class_1297)livingEntity);
            }
            List<class_1799> armors = List.of(livingEntity.method_6118(class_1304.field_6169), livingEntity.method_6118(class_1304.field_6174), livingEntity.method_6118(class_1304.field_6172), livingEntity.method_6118(class_1304.field_6166));
            for (class_1799 armor : armors) {
                serverLevel = armor.method_7909();
                if (!(serverLevel instanceof TickableArmor)) continue;
                TickableArmor tickableArmor = (TickableArmor)serverLevel;
                tickableArmor.tick(level, livingEntity, armor);
            }
            class_1324 armorAttribute = livingEntity.method_6127().method_45329(class_5134.field_23724);
            if (armorAttribute != null) {
                if (livingEntity.method_6118(class_1304.field_6169).method_31574(ESItems.AMARAMBER_MASK.get()) && livingEntity.method_6118(class_1304.field_6174).method_31574(ESItems.AMARAMBER_CHESTPLATE.get()) && livingEntity.method_6118(class_1304.field_6172).method_7960() && livingEntity.method_6118(class_1304.field_6166).method_7960()) {
                    if (!armorAttribute.method_6196(AMARAMBER_BONUS.comp_2447())) {
                        armorAttribute.method_26837(AMARAMBER_BONUS);
                    }
                } else if (armorAttribute.method_6196(AMARAMBER_BONUS.comp_2447())) {
                    armorAttribute.method_6200(AMARAMBER_BONUS.comp_2447());
                }
            }
            int inEtherTicks = ESDataAttachments.IN_ETHER_TICKS.getData(entity);
            class_1324 armorInstance = livingEntity.method_6127().method_45329(class_5134.field_23724);
            boolean inEther = ESDataAttachments.IN_ETHER.getData(entity);
            if (!level.field_9236) {
                int tearyTicks;
                int hireCooldown;
                int meteorCooldown = ESDataAttachments.METEOR_COOLDOWN.getData(entity);
                if (meteorCooldown > 0) {
                    ESDataAttachments.METEOR_COOLDOWN.setData(entity, meteorCooldown - 1);
                }
                if ((hireCooldown = ESDataAttachments.STRANGHOUL_HIRING_COOLDOWN.getData(entity).intValue()) > 0) {
                    ESDataAttachments.STRANGHOUL_HIRING_COOLDOWN.setData(entity, hireCooldown - 1);
                }
                if (livingEntity.method_6059(ESMobEffects.TEARY.asHolder()) && level instanceof class_3218) {
                    class_3218 serverLevel2 = (class_3218)level;
                    serverLevel2.method_14199((class_2394)class_2398.field_18306, livingEntity.method_23317() + (double)livingEntity.method_17681() * ((double)livingEntity.method_59922().method_43057() - 0.5), livingEntity.method_23320(), livingEntity.method_23321() + (double)livingEntity.method_17681() * ((double)livingEntity.method_59922().method_43057() - 0.5), 3, 0.0, 0.0, 0.0, 0.0);
                }
                if (!livingEntity.method_5864().method_20210(ESTags.EntityTypes.TEARY_IMMUNE) && livingEntity.method_6059(ESMobEffects.TEARY.asHolder()) && (tearyTicks = ESDataAttachments.TEARY_TICKS.getData(entity).intValue()) <= ESConfig.INSTANCE.mobMaxTearyTicks) {
                    class_1308 mob;
                    if (livingEntity instanceof class_1308 && (mob = (class_1308)livingEntity).method_5968() != null) {
                        mob.method_5980(null);
                        mob.method_18868().method_18875(class_4140.field_22355);
                        mob.method_5942().method_6340();
                        mob.method_6015(null);
                    }
                    ESDataAttachments.TEARY_TICKS.setData(entity, tearyTicks + 1);
                }
                if (inEther) {
                    float factor = 0.0f;
                    class_1324 resistance = livingEntity.method_5996(ESAttributes.ETHER_RESISTANCE.asHolder());
                    if (resistance != null) {
                        factor = 1.0f - (float)resistance.method_6194();
                    }
                    if (armorInstance != null && armorInstance.method_6194() <= 0.0 && entity.method_5643(ESDamageTypes.getDamageSource(level, ESDamageTypes.ETHER), 0.3f + 0.6f * factor) && level instanceof class_3218) {
                        class_3218 serverLevel3 = (class_3218)level;
                        for (int i = 0; i < 5; ++i) {
                            serverLevel3.method_14199((class_2394)ESParticles.STARLIGHT.get(), entity.method_23317() + (livingEntity.method_59922().method_43058() - 0.5) * (double)entity.method_17681(), entity.method_23318() + (double)entity.method_17682() / 2.0 + (livingEntity.method_59922().method_43058() - 0.5) * (double)entity.method_17682(), entity.method_23321() + (livingEntity.method_59922().method_43058() - 0.5) * (double)entity.method_17681(), 20, 0.1, 0.1, 0.1, 0.0);
                        }
                    }
                    if ((armorInstance == null || armorInstance.method_6194() > 0.0 || inEtherTicks < 140) && livingEntity.method_59922().method_43057() <= factor) {
                        ESDataAttachments.IN_ETHER_TICKS.setData(entity, inEtherTicks + 1);
                    }
                    ESDataAttachments.IN_ETHER.setData(entity, false);
                }
                if (!inEther && inEtherTicks > 0) {
                    ESDataAttachments.IN_ETHER_TICKS.setData(entity, inEtherTicks - 1);
                }
                if (inEtherTicks <= 0 && armorInstance != null) {
                    armorInstance.method_6200(EtherFluid.ARMOR_MODIFIER_ID);
                }
                if (livingEntity.field_6012 % 20 == 0 && inEtherTicks > 0 && armorInstance != null) {
                    armorInstance.method_6200(EtherFluid.ARMOR_MODIFIER_ID);
                    armorInstance.method_26837(EtherFluid.armorModifier((float)(-inEtherTicks) / 100.0f));
                }
            }
        }
    }

    public static void onCriticalHit(class_1657 player, class_1297 target, float attackStrength) {
        class_1792 class_17922;
        if (player.method_59958().method_31573(ESTags.Items.HAMMERS) && (class_17922 = player.method_59958().method_7909()) instanceof HammerItem) {
            HammerItem hammerItem = (HammerItem)class_17922;
            if (attackStrength > 0.9f) {
                hammerItem.performCriticalAttack(player, target);
            }
        }
    }

    public static void onBlockBroken(class_1657 player, class_2338 pos, class_2680 state) {
        if (state.method_26164(class_3481.field_15503) && player.method_37908().method_27983() == ESDimensions.STARLIGHT_KEY) {
            float chance;
            float f = player.method_5477().getString().toLowerCase(Locale.ROOT).contains("nuttar") ? (ESDataAttachments.OBTAINED_BLOSSOM_OF_STARS.getData((class_1297)player).booleanValue() ? 2.5f : 25.0f) : (chance = 0.0025f);
            if (player.method_59922().method_43057() < chance / 100.0f) {
                ESDataAttachments.OBTAINED_BLOSSOM_OF_STARS.setData((class_1297)player, true);
                if (!player.method_31548().method_7394(ESItems.BLOSSOM_OF_STARS.get().method_7854())) {
                    player.method_5706((class_1935)ESItems.BLOSSOM_OF_STARS.get());
                }
            }
        }
    }

    public static float onBlockBreakSpeed(class_1657 player, class_2680 state, float speed) {
        if (player.method_6047().method_31574(ESItems.UNDERMINER.get())) {
            int min = player.method_37908().method_31607();
            int max = player.method_37908().method_31600();
            double y = class_3532.method_15350((double)player.method_23318(), (double)min, (double)max);
            float modifier = (float)(2.0 - 1.75 * (y - (double)min) / (double)(max - min));
            return speed * modifier;
        }
        return speed;
    }

    public static void onShieldBlock(class_1309 blocker, class_1282 source) {
        class_1309 entity;
        class_1297 class_12972;
        if (blocker.method_6030().method_31574(ESItems.GLACITE_SHIELD.get()) && (class_12972 = source.method_5526()) instanceof class_1309 && (entity = (class_1309)class_12972).method_32316()) {
            entity.method_32317(Math.min(entity.method_32312() + 100, 300));
        }
    }

    public static void onProjectileImpact(class_1676 projectile, class_239 result) {
        class_1937 class_19372 = projectile.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3966 entityHitResult;
            class_1297 level2;
            class_1297 living2;
            class_3218 serverLevel = (class_3218)class_19372;
            if (ESDataAttachments.ARROW_TYPE.getData((class_1297)projectile).equals(STARFIRE_ARROW)) {
                if (result.method_17783() == class_239.class_240.field_1332) {
                    ESDataAttachments.ARROW_TYPE.setData((class_1297)projectile, "");
                }
                ThrownStarfire.createExplosionParticles(serverLevel, projectile.method_19538(), 10, 0.25);
                for (class_1297 living2 : projectile.method_37908().method_18467(class_1309.class, projectile.method_5829().method_1014(3.0))) {
                    if (!ESEntityUtil.shouldHarm(projectile.method_24921(), living2)) continue;
                    living2.method_6092(new class_1293(ESMobEffects.STARFIRE.asHolder(), 200));
                }
            }
            if (ESDataAttachments.ARROW_TYPE.getData((class_1297)projectile).equals(CRYSTAL_ARROW)) {
                class_3966 entityHitResult2;
                class_2338 startPos;
                if (result.method_17783() == class_239.class_240.field_1332) {
                    ESDataAttachments.ARROW_TYPE.setData((class_1297)projectile, "");
                }
                for (int i = 0; i < 5; ++i) {
                    class_3965 toGround;
                    class_243 pos = projectile.method_19538().method_49272(projectile.method_59922(), 4.0f);
                    startPos = class_2338.method_49638((class_2374)pos);
                    for (int currentDiff = 0; !serverLevel.method_8320(startPos).method_26215() && currentDiff < 40; ++currentDiff) {
                        startPos = startPos.method_10084();
                    }
                    if (!serverLevel.method_8320(startPos).method_26215() || (toGround = serverLevel.method_17742(new class_3959(startPos.method_46558(), startPos.method_46558().method_1023(0.0, 128.0, 0.0), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)projectile))).method_17783() == class_239.class_240.field_1333) continue;
                    CrystalCluster cluster = new CrystalCluster(ESEntities.CRYSTAL_CLUSTER.get(), (class_1937)serverLevel);
                    cluster.method_33574(toGround.method_17784());
                    class_1297 class_12972 = projectile.method_24921();
                    if (class_12972 instanceof class_1309) {
                        class_1309 owner = (class_1309)class_12972;
                        cluster.setOwner(owner);
                    }
                    cluster.method_36456(class_3532.method_15393((float)(projectile.method_59922().method_43057() * 360.0f)));
                    serverLevel.method_8649((class_1297)cluster);
                }
                if (result.method_17783() == class_239.class_240.field_1331 && result instanceof class_3966 && (startPos = (entityHitResult2 = (class_3966)result).method_17782()) instanceof class_1309) {
                    class_1293 instance;
                    living2 = (class_1309)startPos;
                    int level2 = 0;
                    if (living2.method_6059(ESMobEffects.CRYSTAL_INFECTION.asHolder()) && (instance = living2.method_6112(ESMobEffects.CRYSTAL_INFECTION.asHolder())) != null) {
                        level2 = Math.min(instance.method_5578() + 1, 4);
                    }
                    living2.method_6092(new class_1293(ESMobEffects.CRYSTAL_INFECTION.asHolder(), 200, level2));
                }
            }
            if (ESDataAttachments.ARROW_TYPE.getData((class_1297)projectile).equals(MECHANICAL_ARROW) && result.method_17783() == class_239.class_240.field_1331 && result instanceof class_3966 && (level2 = (entityHitResult = (class_3966)result).method_17782()) instanceof class_1309) {
                living2 = (class_1309)level2;
                ESDataAttachments.ARROW_TYPE.setData((class_1297)projectile, "");
                class_1297 owner = projectile.method_24921();
                class_1799 weapon = projectile.method_59958();
                if (owner instanceof class_1309) {
                    class_1309 attacker = (class_1309)owner;
                    if (weapon != null && !SpecialItemCooldown.isOnCooldown(owner, weapon.method_7909())) {
                        for (int i = 0; i < owner.method_59922().method_43051(5, 8); ++i) {
                            EnergySpark spark = new EnergySpark((class_1937)serverLevel, attacker);
                            spark.method_33574(living2.method_19538().method_1031(0.0, (double)(living2.method_17682() / 2.0f), 0.0));
                            spark.setTarget((class_1309)living2);
                            class_243 movement = new class_243((double)owner.method_59922().method_43057() - 0.5, (double)owner.method_59922().method_43057() - 0.5, (double)owner.method_59922().method_43057() - 0.5);
                            spark.method_7485(movement.field_1352, movement.field_1351, movement.field_1350, 0.1f, 0.2f);
                            serverLevel.method_8649((class_1297)spark);
                        }
                        SpecialItemCooldown.setCooldown(owner, weapon.method_7909(), 75);
                    }
                }
            }
            if (ESDataAttachments.ARROW_TYPE.getData((class_1297)projectile).equals(STARFALL_ARROW) && (living2 = projectile.method_24921()) instanceof class_1309) {
                class_1309 livingEntity;
                class_3966 entityHitResult3;
                class_1297 class_12973;
                class_1309 owner = (class_1309)living2;
                ESDataAttachments.ARROW_TYPE.setData((class_1297)projectile, "");
                class_243 location = result.method_17784();
                AethersentMeteor.createMeteorShower((class_1937)serverLevel, owner, result instanceof class_3966 && (class_12973 = (entityHitResult3 = (class_3966)result).method_17782()) instanceof class_1309 ? (livingEntity = (class_1309)class_12973) : null, location.field_1352, location.field_1351, location.field_1350, 30.0);
            }
        }
    }

    public static void onPlayerNaturalWake(class_3222 serverPlayer, class_2338 pos) {
    }

    public static void onCompleteAdvancement(class_1657 player, class_8779 advancement) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            ESBookUtil.unlock(serverPlayer, advancement.comp_1919().method_45138("advancement_"));
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static void onC2sNoParamPacket(class_3222 player, String id) {
        var2_2 = id;
        var3_3 = -1;
        switch (var2_2.hashCode()) {
            case 1570723308: {
                if (!var2_2.equals("switch_crest")) break;
                var3_3 = 0;
            }
        }
        switch (var3_3) {
            case 0: {
                crests = ESCrestUtil.getOwnedCrests((class_1657)player);
                mainHand = player.method_6047();
                offHand = player.method_6079();
                component = null;
                nextCrest = null;
                if (mainHand.method_57826(ESDataComponents.CURRENT_CREST.get())) {
                    component = (class_6880)mainHand.method_57824(ESDataComponents.CURRENT_CREST.get());
                    spellItem /* !! */  = mainHand;
                } else if (offHand.method_57826(ESDataComponents.CURRENT_CREST.get())) {
                    component = (class_6880)offHand.method_57824(ESDataComponents.CURRENT_CREST.get());
                    spellItem /* !! */  = offHand;
                } else {
                    spellItem /* !! */  = mainHand.method_31574(ESItems.ORB_OF_PROPHECY.get()) != false ? mainHand : (offHand.method_31574(ESItems.ORB_OF_PROPHECY.get()) != false ? offHand : null);
                }
                if (component == null) ** GOTO lbl32
                for (i = 0; i < crests.size(); ++i) {
                    if (!crests.get(i).crest().method_55838(component) || i >= crests.size() - 1) continue;
                    for (j = i + 1; j < crests.size(); ++j) {
                        if (!((Crest)crests.get(j).crest().comp_349()).getSpell().isPresent()) continue;
                        nextCrest = crests.get(j).crest();
                        ** GOTO lbl36
                    }
                }
                ** GOTO lbl36
lbl32:
                // 2 sources

                for (Crest.Instance instance : crests) {
                    if (!((Crest)instance.crest().comp_349()).getSpell().isPresent()) continue;
                    nextCrest = instance.crest();
                    break;
                }
lbl36:
                // 4 sources

                if (spellItem /* !! */  == null) break;
                if (nextCrest != null && nextCrest.method_40227()) {
                    spellItem /* !! */ .method_59692(class_9326.method_57841().method_57854(ESDataComponents.CURRENT_CREST.get(), nextCrest).method_57852());
                    break;
                }
                spellItem /* !! */ .method_57381(ESDataComponents.CURRENT_CREST.get());
            }
        }
    }

    static {
        ticksSinceLastUpdate = 0;
        AMARAMBER_BONUS = new class_1322(EternalStarlight.id("armor.amaramber_bonus"), 7.0, class_1322.class_1323.field_6328);
    }
}

