/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.item.misc;

import cn.leolezury.eternalstarlight.common.item.component.LargeItemStackList;
import cn.leolezury.eternalstarlight.common.item.tooltip.GalacticQuiverTooltipComponent;
import cn.leolezury.eternalstarlight.common.registry.ESDataComponents;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2596;
import net.minecraft.class_2653;
import net.minecraft.class_3222;
import net.minecraft.class_3489;
import net.minecraft.class_3532;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_5632;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

public class GalacticQuiverItem
extends class_1792 {
    private static final int MAX_ARROWS = 512;

    public GalacticQuiverItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public static boolean hasArrows(class_1799 itemStack) {
        return ((List)itemStack.method_57825(ESDataComponents.ARROWS.get(), List.of())).stream().anyMatch(stack -> !stack.isEmpty());
    }

    public static boolean addArrowToInventory(class_1661 inventory, class_1799 stack) {
        if (!stack.method_31573(class_3489.field_18317) || stack.method_7960()) {
            return false;
        }
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 inventoryItem = inventory.method_5438(i);
            if (inventoryItem.method_31574(ESItems.GALACTIC_QUIVER.get())) {
                ArrayList<LargeItemStackList.LargeItemStack> arrows = new ArrayList<LargeItemStackList.LargeItemStack>((Collection)inventoryItem.method_57825(ESDataComponents.ARROWS.get(), (Object)new LargeItemStackList(List.of())));
                AtomicInteger totalCount = new AtomicInteger();
                arrows.forEach(arrow -> totalCount.addAndGet(arrow.getCount()));
                if (totalCount.intValue() < 512) {
                    class_1799 taken = stack.method_7971(512 - totalCount.intValue());
                    boolean newArrow = true;
                    for (LargeItemStackList.LargeItemStack arrowStack : arrows) {
                        if (!class_1799.method_31577((class_1799)arrowStack.getItem(), (class_1799)taken)) continue;
                        arrowStack.setCount(arrowStack.getCount() + taken.method_7947());
                        newArrow = false;
                        break;
                    }
                    if (newArrow) {
                        arrows.add(new LargeItemStackList.LargeItemStack(taken));
                    }
                }
                arrows.removeIf(LargeItemStackList.LargeItemStack::isEmpty);
                inventoryItem.method_57379(ESDataComponents.ARROWS.get(), (Object)new LargeItemStackList(Collections.unmodifiableList(arrows)));
                class_1657 class_16572 = inventory.field_7546;
                if (class_16572 instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)class_16572;
                    serverPlayer.field_13987.method_14364((class_2596)new class_2653(-2, 0, i, inventoryItem));
                }
            }
            if (stack.method_7960()) break;
        }
        return stack.method_7960();
    }

    public boolean method_31565(class_1799 stack, class_1735 slot, class_5536 action, class_1657 player) {
        if (stack.method_7947() != 1 || action != class_5536.field_27014) {
            return false;
        }
        ArrayList<LargeItemStackList.LargeItemStack> arrows = new ArrayList<LargeItemStackList.LargeItemStack>((Collection)stack.method_57825(ESDataComponents.ARROWS.get(), List.of()));
        class_1799 slotItem = slot.method_7677();
        if (slotItem.method_7960()) {
            LargeItemStackList.LargeItemStack removed;
            if (!arrows.isEmpty() && (removed = (LargeItemStackList.LargeItemStack)arrows.getLast()) != null) {
                class_1799 remain = slot.method_32756(removed.splitMaxStack());
                removed.grow(remain.method_7947());
            }
        } else if (slotItem.method_31573(class_3489.field_18317)) {
            AtomicInteger totalCount = new AtomicInteger();
            arrows.forEach(arrow -> totalCount.addAndGet(arrow.getCount()));
            if (totalCount.intValue() < 512) {
                class_1799 taken = slot.method_32753(slotItem.method_7947(), 512 - totalCount.intValue(), player);
                boolean newArrow = true;
                for (LargeItemStackList.LargeItemStack arrowStack : arrows) {
                    if (!class_1799.method_31577((class_1799)arrowStack.getItem(), (class_1799)taken)) continue;
                    arrowStack.setCount(arrowStack.getCount() + taken.method_7947());
                    newArrow = false;
                    break;
                }
                if (newArrow) {
                    arrows.add(new LargeItemStackList.LargeItemStack(taken));
                }
            }
        }
        arrows.removeIf(LargeItemStackList.LargeItemStack::isEmpty);
        stack.method_57379(ESDataComponents.ARROWS.get(), (Object)new LargeItemStackList(Collections.unmodifiableList(arrows)));
        return true;
    }

    public boolean method_31566(class_1799 stack, class_1799 other, class_1735 slot, class_5536 action, class_1657 player, class_5630 access) {
        if (stack.method_7947() != 1) {
            return false;
        }
        if (!other.method_7960() && !other.method_31573(class_3489.field_18317)) {
            return false;
        }
        if (action == class_5536.field_27014 && slot.method_32754(player)) {
            ArrayList<LargeItemStackList.LargeItemStack> arrows = new ArrayList<LargeItemStackList.LargeItemStack>((Collection)stack.method_57825(ESDataComponents.ARROWS.get(), List.of()));
            if (other.method_7960()) {
                LargeItemStackList.LargeItemStack removed;
                if (!arrows.isEmpty() && (removed = (LargeItemStackList.LargeItemStack)arrows.getLast()) != null) {
                    access.method_32332(removed.splitMaxStack());
                }
            } else if (other.method_31573(class_3489.field_18317)) {
                AtomicInteger totalCount = new AtomicInteger();
                arrows.forEach(arrow -> totalCount.addAndGet(arrow.getCount()));
                if (totalCount.intValue() < 512) {
                    int capacity = 512 - totalCount.intValue();
                    boolean newArrow = true;
                    for (LargeItemStackList.LargeItemStack arrowStack : arrows) {
                        if (!class_1799.method_31577((class_1799)arrowStack.getItem(), (class_1799)other)) continue;
                        arrowStack.setCount(arrowStack.getCount() + Math.min(other.method_7947(), capacity));
                        if (other.method_7947() > capacity) {
                            other.method_7934(capacity);
                        } else {
                            other.method_7939(0);
                        }
                        newArrow = false;
                        break;
                    }
                    if (newArrow) {
                        arrows.add(new LargeItemStackList.LargeItemStack(other.method_7971(capacity)));
                    }
                }
            }
            arrows.removeIf(LargeItemStackList.LargeItemStack::isEmpty);
            stack.method_57379(ESDataComponents.ARROWS.get(), (Object)new LargeItemStackList(Collections.unmodifiableList(arrows)));
            return true;
        }
        return false;
    }

    public void method_33261(class_1542 itemEntity) {
        List arrows = (List)itemEntity.method_6983().method_57824(ESDataComponents.ARROWS.get());
        if (arrows != null) {
            itemEntity.method_6983().method_57379(ESDataComponents.ARROWS.get(), (Object)new LargeItemStackList(List.of()));
            for (LargeItemStackList.LargeItemStack arrowStack : arrows) {
                while (!arrowStack.isEmpty()) {
                    class_1799 split = arrowStack.splitMaxStack();
                    itemEntity.method_37908().method_8649((class_1297)new class_1542(itemEntity.method_37908(), itemEntity.method_23317(), itemEntity.method_23318(), itemEntity.method_23321(), split));
                }
            }
        }
    }

    public boolean method_31567(class_1799 stack) {
        List arrows = (List)stack.method_57824(ESDataComponents.ARROWS.get());
        return arrows != null && !arrows.isEmpty();
    }

    public int method_31569(class_1799 stack) {
        List arrows = (List)stack.method_57825(ESDataComponents.ARROWS.get(), List.of());
        AtomicInteger totalCount = new AtomicInteger();
        arrows.forEach(arrow -> totalCount.addAndGet(arrow.getCount()));
        return class_3532.method_15340((int)Math.round((float)totalCount.intValue() / 512.0f * 13.0f), (int)0, (int)13);
    }

    public int method_31571(class_1799 stack) {
        return 9461416;
    }

    @NotNull
    public Optional<class_5632> method_32346(class_1799 stack) {
        if (!stack.method_57826(class_9334.field_50074) && !stack.method_57826(class_9334.field_49638)) {
            LargeItemStackList arrows = (LargeItemStackList)stack.method_57825(ESDataComponents.ARROWS.get(), (Object)new LargeItemStackList(List.of()));
            return arrows.isEmpty() ? Optional.empty() : Optional.of(new GalacticQuiverTooltipComponent(arrows));
        }
        return Optional.empty();
    }
}

