/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.spell;

import cn.leolezury.eternalstarlight.common.entity.interfaces.SpellCaster;
import cn.leolezury.eternalstarlight.common.registry.ESDataAttachments;
import cn.leolezury.eternalstarlight.common.spell.ManaType;
import cn.leolezury.eternalstarlight.common.spell.SpellCastData;
import cn.leolezury.eternalstarlight.common.util.ESSpellUtil;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;

public abstract class AbstractSpell {
    private final Properties properties;

    public Properties spellProperties() {
        return this.properties;
    }

    public AbstractSpell(Properties properties) {
        this.properties = properties;
    }

    public boolean canCast(class_1309 entity, boolean checkCrystal) {
        class_1657 player;
        boolean crystalCheck = !checkCrystal || entity instanceof class_1657 && ((player = (class_1657)entity).method_56992() || this.hasNeededCrystal(player.method_31548()));
        return crystalCheck && ESSpellUtil.getCooldown(entity, this) <= 0 && this.checkExtraConditions(entity);
    }

    public boolean hasNeededCrystal(class_1661 inventory) {
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (!this.spellProperties().types().stream().anyMatch(t -> stack.method_31573(t.getCrystalsTag()))) continue;
            return true;
        }
        return false;
    }

    public boolean canContinueToCast(class_1309 entity, int totalTicks) {
        return totalTicks <= this.properties.preparationTicks() + this.properties.spellTicks() && this.checkExtraConditionsToContinue(entity, totalTicks);
    }

    public void start(class_1309 entity, boolean damageCrystal) {
        this.start(entity, 1, damageCrystal);
    }

    public void start(class_1309 entity, int strength, boolean damageCrystal) {
        class_1657 player;
        if (damageCrystal && entity instanceof class_1657 && !(player = (class_1657)entity).method_56992()) {
            this.damageCrystal(player);
        }
        this.onStart(entity);
        if (!entity.method_37908().field_9236 && entity instanceof SpellCaster) {
            SpellCastData.ItemSpellSource source;
            SpellCastData.SpellSource spellSource = ESDataAttachments.SPELL_SOURCE.getData((class_1297)entity);
            ESDataAttachments.SPELL_CAST_DATA.setData((class_1297)entity, new SpellCastData(true, this, strength, 0, spellSource instanceof SpellCastData.ItemSpellSource && (source = (SpellCastData.ItemSpellSource)spellSource).hand() == class_1268.field_5810));
        }
    }

    public void damageCrystal(class_1657 player) {
        class_1661 inventory = player.method_31548();
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (!this.spellProperties().types().stream().anyMatch(t -> stack.method_31573(t.getCrystalsTag()))) continue;
            stack.method_7970(1, (class_1309)player, class_1304.field_6173);
            return;
        }
    }

    public void tick(class_1309 entity, int ticks) {
        if (ticks <= this.spellProperties().preparationTicks()) {
            this.onPreparationTick(entity, ticks);
        } else if (ticks <= this.spellProperties().preparationTicks() + this.spellProperties().spellTicks()) {
            this.onSpellTick(entity, ticks - this.spellProperties().preparationTicks());
        }
        if (ticks % 15 == 0 && entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            this.damageCrystal(player);
        }
    }

    public void stop(class_1309 entity, int ticks) {
        this.onStop(entity, ticks);
        ESSpellUtil.setCooldown(entity, this, this.properties.cooldownTicks());
        if (!entity.method_37908().field_9236 && entity instanceof SpellCaster) {
            ESDataAttachments.SPELL_CAST_DATA.removeData((class_1297)entity);
        }
    }

    public abstract boolean checkExtraConditions(class_1309 var1);

    public abstract boolean checkExtraConditionsToContinue(class_1309 var1, int var2);

    public abstract void onPreparationTick(class_1309 var1, int var2);

    public abstract void onSpellTick(class_1309 var1, int var2);

    public abstract void onStart(class_1309 var1);

    public abstract void onStop(class_1309 var1, int var2);

    public record Properties(List<ManaType> types, int preparationTicks, int spellTicks, int cooldownTicks) {
        public int totalTicks() {
            return this.preparationTicks() + this.spellTicks();
        }
    }
}

