/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.util;

import cn.leolezury.eternalstarlight.common.item.component.Accessory;
import cn.leolezury.eternalstarlight.common.item.component.ItemStackList;
import cn.leolezury.eternalstarlight.common.registry.ESDataComponents;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.minecraft.class_9334;

public class ESAccessoryUtil {
    public static Set<class_1792> getActiveAccessoriesOnArmors(class_1309 entity) {
        return ESAccessoryUtil.getActiveAccessories(entity, Set.of(class_1304.field_6169, class_1304.field_6174, class_1304.field_6172, class_1304.field_6166));
    }

    public static Set<class_1792> getActiveAccessories(class_1309 entity, Set<class_1304> slots) {
        HashSet<class_1792> result = new HashSet<class_1792>();
        for (class_1304 slot : slots) {
            result.addAll(ESAccessoryUtil.getAccessories(entity.method_6118(slot)));
        }
        return result;
    }

    public static Set<class_1792> getAccessories(class_1799 stack) {
        return ((List)stack.method_57825(ESDataComponents.ACCESSORIES.get(), List.of())).stream().map(class_1799::method_7909).collect(Collectors.toSet());
    }

    public static int getAccessorySlotCount(class_1799 stack) {
        return (Integer)stack.method_57825(ESDataComponents.ACCESSORY_SLOT_COUNT.get(), (Object)1);
    }

    public static void applyAccessory(class_1799 equipmentStack, class_1799 accessoryStack) {
        if (accessoryStack.method_7960()) {
            return;
        }
        class_9285.class_9286 builder = class_9285.method_57480();
        Accessory data = (Accessory)accessoryStack.method_57824(ESDataComponents.ACCESSORY.get());
        class_9285 accessoryModifiers = data != null ? data.attributeModifiers() : class_9285.field_49326;
        for (class_9274 slotGroup : class_9274.values()) {
            equipmentStack.method_60617(slotGroup, (attribute, modifier) -> builder.method_57487(attribute, modifier, slotGroup));
        }
        for (class_9285.class_9287 entry : accessoryModifiers.comp_2393()) {
            builder.method_57487(entry.comp_2395(), entry.comp_2396(), entry.comp_2397());
        }
        equipmentStack.method_57379(class_9334.field_49636, (Object)builder.method_57486());
        ArrayList<class_1799> accessories = new ArrayList<class_1799>((Collection)equipmentStack.method_57825(ESDataComponents.ACCESSORIES.get(), List.of()));
        accessories.add(accessoryStack.method_46651(1));
        equipmentStack.method_57379(ESDataComponents.ACCESSORIES.get(), (Object)new ItemStackList(Collections.unmodifiableList(accessories)));
    }

    public static void removeAccessory(class_1799 equipmentStack, class_1799 accessoryStack) {
        Accessory data = (Accessory)accessoryStack.method_57824(ESDataComponents.ACCESSORY.get());
        class_9285 accessoryModifiers = data != null ? data.attributeModifiers() : class_9285.field_49326;
        class_9285 modifiers = (class_9285)equipmentStack.method_57825(class_9334.field_49636, (Object)class_9285.field_49326);
        ArrayList<class_9285.class_9287> entries = new ArrayList<class_9285.class_9287>(modifiers.comp_2393());
        entries.removeIf(entry -> accessoryModifiers.comp_2393().stream().anyMatch(e -> entry.comp_2396().comp_2447().equals((Object)e.comp_2396().comp_2447())));
        equipmentStack.method_57379(class_9334.field_49636, (Object)new class_9285(Collections.unmodifiableList(entries), modifiers.comp_2394()));
        ArrayList<class_1799> accessories = new ArrayList<class_1799>((Collection)equipmentStack.method_57825(ESDataComponents.ACCESSORIES.get(), List.of()));
        accessories.removeIf(stack -> stack.method_7909() == accessoryStack.method_7909());
        equipmentStack.method_57379(ESDataComponents.ACCESSORIES.get(), (Object)new ItemStackList(Collections.unmodifiableList(accessories)));
    }

    public static boolean overrideEquipmentOnAccessory(class_1799 stack, class_1735 slot, class_5536 action, class_1657 player) {
        if (stack.method_7947() != 1 || action != class_5536.field_27014) {
            return false;
        }
        List accessories = (List)stack.method_57825(ESDataComponents.ACCESSORIES.get(), List.of());
        class_1799 slotItem = slot.method_7677();
        Accessory accessory = (Accessory)slotItem.method_57824(ESDataComponents.ACCESSORY.get());
        if (accessories.isEmpty() && accessory == null) {
            return false;
        }
        if (slotItem.method_7960()) {
            if (!accessories.isEmpty()) {
                class_1799 removed = (class_1799)accessories.getLast();
                ESAccessoryUtil.removeAccessory(stack, removed);
                class_1799 remain = slot.method_32756(removed.method_7972());
                ESAccessoryUtil.applyAccessory(stack, remain);
            }
        } else if (accessory != null && stack.method_31573(accessory.combinationTarget()) && ESAccessoryUtil.getAccessorySlotCount(stack) > accessories.size() && accessories.stream().noneMatch(s -> s.method_7909() == slotItem.method_7909())) {
            class_1799 taken = slot.method_32753(slotItem.method_7947(), 1, player);
            ESAccessoryUtil.applyAccessory(stack, taken);
        }
        return true;
    }

    public static boolean overrideAccessoryOnEquipment(class_1799 stack, class_1799 other, class_1735 slot, class_5536 action, class_1657 player, class_5630 access) {
        if (stack.method_7947() != 1) {
            return false;
        }
        Accessory accessory = (Accessory)other.method_57824(ESDataComponents.ACCESSORY.get());
        if (!other.method_7960() && accessory == null) {
            return false;
        }
        if (action == class_5536.field_27014 && slot.method_32754(player)) {
            List accessories = (List)stack.method_57825(ESDataComponents.ACCESSORIES.get(), List.of());
            if (other.method_7960()) {
                if (!accessories.isEmpty()) {
                    class_1799 removed = (class_1799)accessories.getLast();
                    ESAccessoryUtil.removeAccessory(stack, removed);
                    access.method_32332(removed.method_7972());
                }
            } else if (accessory != null && stack.method_31573(accessory.combinationTarget()) && ESAccessoryUtil.getAccessorySlotCount(stack) > accessories.size() && accessories.stream().noneMatch(s -> s.method_7909() == other.method_7909())) {
                ESAccessoryUtil.applyAccessory(stack, other);
                other.method_7934(1);
            }
            return true;
        }
        return false;
    }
}

