/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.util;

import cn.leolezury.eternalstarlight.common.registry.ESDataAttachments;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public record SpecialItemCooldown(class_6880<class_1792> item, int cooldown) {
    public static final Codec<SpecialItemCooldown> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_7923.field_41178.method_40294().fieldOf("item").forGetter(SpecialItemCooldown::item), (App)Codec.INT.fieldOf("cooldown").forGetter(SpecialItemCooldown::cooldown)).apply((Applicative)instance, SpecialItemCooldown::new));
    public static final Codec<List<SpecialItemCooldown>> LIST_CODEC = CODEC.listOf();

    public static boolean isOnCooldown(class_1297 entity, class_1792 item) {
        return SpecialItemCooldown.getCooldown(entity, item) > 0;
    }

    public static int getCooldown(class_1297 entity, class_1792 item) {
        return ESDataAttachments.SPECIAL_ITEM_COOLDOWNS.getData(entity).stream().filter(c -> c.item().comp_349() == item).map(SpecialItemCooldown::cooldown).findFirst().orElse(0);
    }

    public static void setCooldown(class_1297 entity, class_1792 item, int time) {
        ArrayList<SpecialItemCooldown> cooldowns = new ArrayList<SpecialItemCooldown>((Collection)ESDataAttachments.SPECIAL_ITEM_COOLDOWNS.getData(entity));
        cooldowns.removeIf(c -> c.item().comp_349() == item);
        cooldowns.add(new SpecialItemCooldown((class_6880<class_1792>)item.method_40131(), time));
        ESDataAttachments.SPECIAL_ITEM_COOLDOWNS.setData(entity, cooldowns);
    }

    public static void removeCooldown(class_1297 entity, class_1792 item) {
        SpecialItemCooldown.setCooldown(entity, item, 0);
    }

    public static void tick(class_1297 entity) {
        if (entity.method_37908().field_9236) {
            return;
        }
        ArrayList cooldowns = new ArrayList(ESDataAttachments.SPECIAL_ITEM_COOLDOWNS.getData(entity));
        if (!cooldowns.isEmpty()) {
            ArrayList<SpecialItemCooldown> newCooldowns = new ArrayList<SpecialItemCooldown>();
            Iterator iterator = cooldowns.iterator();
            while (iterator.hasNext()) {
                SpecialItemCooldown cd = (SpecialItemCooldown)iterator.next();
                if (cd.cooldown() <= 0) {
                    iterator.remove();
                    continue;
                }
                newCooldowns.add(new SpecialItemCooldown(cd.item(), cd.cooldown() - 1));
            }
            ESDataAttachments.SPECIAL_ITEM_COOLDOWNS.setData(entity, newCooldowns);
        }
    }
}

