/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.util;

import cn.leolezury.eternalstarlight.common.util.ESMathUtil;
import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;

public class TrailEffect {
    private static final int MAX_CAPACITY = 65536;
    private final ArrayList<TrailPoint> points = new ArrayList();
    private final ArrayList<TrailPoint> renderPoints = new ArrayList();
    private final float width;
    private float oldLength;
    private float length;

    public float getWidth() {
        return this.width;
    }

    public float getLength() {
        return this.length;
    }

    public void setLength(float length) {
        this.length = length;
    }

    public TrailEffect(float width, int length) {
        this.width = width;
        this.length = length;
    }

    public void update(TrailPoint point) {
        if (this.points.isEmpty() || this.points.getFirst().pos().method_1022(point.pos()) > 0.01) {
            this.points.addFirst(point);
        }
        if (this.points.size() > 65536) {
            this.points.removeLast();
        }
    }

    public void update(class_243 pos) {
        this.oldLength = this.length;
        this.update(new TrailPoint(pos, 1.0f));
    }

    public void prepareRender(class_243 pos, float partialTicks) {
        this.renderPoints.clear();
        this.renderPoints.addAll(this.points);
        this.prepare(new TrailPoint(pos), partialTicks);
    }

    private void prepare(TrailPoint point, float partialTicks) {
        ArrayList<TrailPoint> modified = new ArrayList<TrailPoint>();
        this.renderPoints.addFirst(point);
        float totalLength = 0.0f;
        float renderLength = class_3532.method_16439((float)partialTicks, (float)this.oldLength, (float)this.length);
        for (int i = 0; i < this.renderPoints.size() - 1; ++i) {
            TrailPoint from = this.renderPoints.get(i);
            TrailPoint to = this.renderPoints.get(i + 1);
            float distance = (float)from.pos().method_1022(to.pos());
            if (!((totalLength += distance) > renderLength)) continue;
            this.renderPoints.set(i + 1, this.interpolateTrailPoint((totalLength - renderLength) / distance, to, from));
            modified.addAll(this.renderPoints.subList(0, i + 2));
            totalLength = renderLength;
            break;
        }
        if (!modified.isEmpty()) {
            this.renderPoints.clear();
            this.renderPoints.addAll(modified);
        }
        float currentLength = 0.0f;
        for (int i = 0; i < this.renderPoints.size() - 1; ++i) {
            TrailPoint from = this.renderPoints.get(i);
            TrailPoint to = this.renderPoints.get(i + 1);
            float distance = (float)from.pos().method_1022(to.pos());
            this.renderPoints.set(i, this.renderPoints.get(i).withAlphaFactor((totalLength - currentLength) / renderLength));
            currentLength += distance;
        }
        if (this.renderPoints.size() > 1) {
            this.renderPoints.set(this.renderPoints.size() - 1, this.renderPoints.getLast().withAlphaFactor(0.01f));
        }
    }

    private TrailPoint interpolateTrailPoint(float progress, TrailPoint first, TrailPoint second) {
        return new TrailPoint(ESMathUtil.lerpVec(progress, first.pos(), second.pos()));
    }

    @Environment(value=EnvType.CLIENT)
    public void render(class_4588 consumer, class_4587 stack, float r, float g, float b, float a, int light) {
        if (this.renderPoints.size() >= 2) {
            for (int i = 0; i < this.renderPoints.size() - 1; ++i) {
                TrailPoint from = this.renderPoints.get(i);
                TrailPoint to = this.renderPoints.get(i + 1);
                class_243 fromDelta = to.pos().method_1020(from.pos());
                class_243 toDelta = i == this.renderPoints.size() - 2 ? fromDelta : this.renderPoints.get(i + 2).pos().method_1020(to.pos());
                class_4587.class_4665 pose = stack.method_23760();
                consumer.method_56824(pose, (float)from.getUpperPoint((class_243)fromDelta, (float)this.width, (class_4184)class_310.method_1551().field_1773.method_19418()).field_1352, (float)from.getUpperPoint((class_243)fromDelta, (float)this.width, (class_4184)class_310.method_1551().field_1773.method_19418()).field_1351, (float)from.getUpperPoint((class_243)fromDelta, (float)this.width, (class_4184)class_310.method_1551().field_1773.method_19418()).field_1350).method_22915(r, g, b, class_3532.method_15363((float)(a * from.alphaFactor()), (float)0.0f, (float)1.0f)).method_22913(0.0f, 0.0f).method_22922(class_4608.field_21444).method_60803(light).method_60831(pose, 0.0f, 1.0f, 0.0f);
                consumer.method_56824(pose, (float)to.getUpperPoint((class_243)toDelta, (float)this.width, (class_4184)class_310.method_1551().field_1773.method_19418()).field_1352, (float)to.getUpperPoint((class_243)toDelta, (float)this.width, (class_4184)class_310.method_1551().field_1773.method_19418()).field_1351, (float)to.getUpperPoint((class_243)toDelta, (float)this.width, (class_4184)class_310.method_1551().field_1773.method_19418()).field_1350).method_22915(r, g, b, class_3532.method_15363((float)(a * to.alphaFactor()), (float)0.0f, (float)1.0f)).method_22913(1.0f, 0.0f).method_22922(class_4608.field_21444).method_60803(light).method_60831(pose, 0.0f, 1.0f, 0.0f);
                consumer.method_56824(pose, (float)to.getLowerPoint((class_243)toDelta, (float)this.width, (class_4184)class_310.method_1551().field_1773.method_19418()).field_1352, (float)to.getLowerPoint((class_243)toDelta, (float)this.width, (class_4184)class_310.method_1551().field_1773.method_19418()).field_1351, (float)to.getLowerPoint((class_243)toDelta, (float)this.width, (class_4184)class_310.method_1551().field_1773.method_19418()).field_1350).method_22915(r, g, b, class_3532.method_15363((float)(a * to.alphaFactor()), (float)0.0f, (float)1.0f)).method_22913(1.0f, 1.0f).method_22922(class_4608.field_21444).method_60803(light).method_60831(pose, 0.0f, 1.0f, 0.0f);
                consumer.method_56824(pose, (float)from.getLowerPoint((class_243)fromDelta, (float)this.width, (class_4184)class_310.method_1551().field_1773.method_19418()).field_1352, (float)from.getLowerPoint((class_243)fromDelta, (float)this.width, (class_4184)class_310.method_1551().field_1773.method_19418()).field_1351, (float)from.getLowerPoint((class_243)fromDelta, (float)this.width, (class_4184)class_310.method_1551().field_1773.method_19418()).field_1350).method_22915(r, g, b, class_3532.method_15363((float)(a * from.alphaFactor()), (float)0.0f, (float)1.0f)).method_22913(0.0f, 1.0f).method_22922(class_4608.field_21444).method_60803(light).method_60831(pose, 0.0f, 1.0f, 0.0f);
            }
        }
    }

    public record TrailPoint(class_243 pos, float alphaFactor) {
        public TrailPoint(class_243 pos) {
            this(pos, 1.0f);
        }

        public class_243 getUpperPoint(class_243 delta, float width, class_4184 camera) {
            return this.pos.method_1019(delta.method_1036(new class_243(camera.method_19335())).method_1029().method_1021((double)(width / 2.0f)));
        }

        public class_243 getLowerPoint(class_243 delta, float width, class_4184 camera) {
            return this.pos.method_1019(delta.method_1036(new class_243(camera.method_19335())).method_1029().method_1021((double)(-width / 2.0f)));
        }

        public TrailPoint withAlphaFactor(float alpha) {
            return new TrailPoint(this.pos(), alpha);
        }
    }
}

