/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.world;

import cn.leolezury.eternalstarlight.common.block.ESPortalBlock;
import cn.leolezury.eternalstarlight.common.data.ESDimensions;
import cn.leolezury.eternalstarlight.common.registry.ESBlocks;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2784;
import net.minecraft.class_2874;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_5454;
import org.jetbrains.annotations.Nullable;

public class ESTeleporter {
    protected static Optional<class_2338> getOrMakePortal(class_3218 level, class_1297 entity, class_2338 entrancePos, class_2338 pos) {
        Optional<class_2338> existingPortal = ESTeleporter.getExistingPortal(level, pos);
        if (existingPortal.isPresent()) {
            return existingPortal;
        }
        class_2350.class_2351 portalAxis = entity.method_37908().method_8320(entrancePos).method_28500(ESPortalBlock.AXIS).orElse(class_2350.class_2351.field_11048);
        return ESTeleporter.makePortal(level, pos, portalAxis);
    }

    public static Optional<class_2338> getExistingPortal(class_3218 level, class_2338 pos) {
        int maxHeight = level.method_31600();
        int minHeight = level.method_31607();
        class_2784 border = level.method_8621();
        class_2338.class_2339 blockPos = new class_2338.class_2339();
        for (int x = pos.method_10263() - 16; x <= pos.method_10263() + 16; ++x) {
            for (int z = pos.method_10260() - 16; z <= pos.method_10260() + 16; ++z) {
                for (int y = minHeight; y <= maxHeight; ++y) {
                    blockPos.method_10103(x, y, z);
                    if (!border.method_11952((class_2338)blockPos) || !level.method_8320((class_2338)blockPos).method_27852((class_2248)ESBlocks.STARLIGHT_PORTAL.get())) continue;
                    return Optional.of(blockPos);
                }
            }
        }
        return Optional.empty();
    }

    public static Optional<class_2338> makePortal(class_3218 level, class_2338 blockPos, class_2350.class_2351 axis) {
        int maxHeight = level.method_31600();
        int minHeight = level.method_31607();
        class_2784 border = level.method_8621();
        for (class_2338.class_2339 pos : class_2338.method_30512((class_2338)blockPos, (int)32, (class_2350)class_2350.field_11034, (class_2350)class_2350.field_11035)) {
            int height;
            int to;
            int worldSurface = level.method_8624(class_2902.class_2903.field_13202, pos.method_10263(), pos.method_10260());
            int from = Math.max(minHeight, worldSurface - 10);
            if (from < (to = Math.min(maxHeight, worldSurface + 10))) {
                for (height = from; height < to; ++height) {
                    pos.method_33098(height);
                    if (!border.method_11952((class_2338)pos) || !ESPortalBlock.placePortal((class_1936)level, (class_2338)pos, axis, 2)) continue;
                    return Optional.of(pos.method_10093(class_2350.field_11036));
                }
            }
            pos.method_33098(blockPos.method_10264());
            for (height = blockPos.method_10264(); height < maxHeight; ++height) {
                pos.method_33098(height);
                if (!border.method_11952((class_2338)pos) || !ESPortalBlock.placePortal((class_1936)level, (class_2338)pos, axis, 2)) continue;
                return Optional.of(pos.method_10093(class_2350.field_11036));
            }
            pos.method_33098(blockPos.method_10264());
            for (height = blockPos.method_10264(); height > minHeight; --height) {
                pos.method_33098(height);
                if (!border.method_11952((class_2338)pos) || !ESPortalBlock.placePortal((class_1936)level, (class_2338)pos, axis, 2)) continue;
                return Optional.of(pos.method_10093(class_2350.field_11036));
            }
        }
        return Optional.empty();
    }

    @Nullable
    public static class_5454 getPortalInfo(class_1297 entity, class_2338 entrancePos, class_3218 dest) {
        if (entity.method_37908().method_27983() != ESDimensions.STARLIGHT_KEY && dest.method_27983() != ESDimensions.STARLIGHT_KEY) {
            return null;
        }
        class_2784 border = dest.method_8621();
        double coordinateDifference = class_2874.method_31109((class_2874)entity.method_37908().method_8597(), (class_2874)dest.method_8597());
        class_2338 pos = border.method_39538(entity.method_23317() * coordinateDifference, entity.method_23318(), entity.method_23321() * coordinateDifference);
        return ESTeleporter.getOrMakePortal(dest, entity, entrancePos, pos).map(result -> new class_5454(dest, class_243.method_24953((class_2382)result), class_243.field_1353, entity.method_36454(), entity.method_36455(), class_5454.field_52247)).orElse(null);
    }
}

