/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.world.gen.feature.tree.trunk;

import cn.leolezury.eternalstarlight.common.registry.ESTreePlacers;
import cn.leolezury.eternalstarlight.common.util.ESMathUtil;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2404;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3031;
import net.minecraft.class_3481;
import net.minecraft.class_3746;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_4970;
import net.minecraft.class_5141;
import net.minecraft.class_5142;
import net.minecraft.class_5819;
import net.minecraft.class_6016;
import net.minecraft.class_6017;

public class BranchingTrunkPlacer
extends class_5141 {
    public static final MapCodec<BranchingTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> BranchingTrunkPlacer.method_28904((RecordCodecBuilder.Instance)instance).and((App)class_6017.method_35004((int)0, (int)3).fieldOf("trunk_radius").forGetter(placer -> placer.trunkRadius)).and((App)class_6017.method_35004((int)0, (int)24).fieldOf("branch_length").forGetter(placer -> placer.branchLen)).and((App)class_6017.method_35004((int)0, (int)10).fieldOf("branch_layer_num").forGetter(placer -> placer.branchLayerNum)).and((App)class_6017.method_35004((int)0, (int)10).fieldOf("branch_num").forGetter(placer -> placer.branchNum)).apply((Applicative)instance, BranchingTrunkPlacer::new));
    private final class_6017 trunkRadius;
    private final class_6017 branchLen;
    private final class_6017 branchLayerNum;
    private final class_6017 branchNum;
    private static final double SQRT_3 = Math.sqrt(3.0);

    public BranchingTrunkPlacer(int baseHeight, int randomHeightA, int randomHeightB, class_6017 branchLen, class_6017 branchNum) {
        this(baseHeight, randomHeightA, randomHeightB, (class_6017)class_6016.method_34998((int)1), branchLen, (class_6017)class_6016.method_34998((int)4), branchNum);
    }

    public BranchingTrunkPlacer(int baseHeight, int randomHeightA, int randomHeightB, class_6017 trunkRadius, class_6017 branchLen, class_6017 branchLayerNum, class_6017 branchNum) {
        super(baseHeight, randomHeightA, randomHeightB);
        this.trunkRadius = trunkRadius;
        this.branchLen = branchLen;
        this.branchLayerNum = branchLayerNum;
        this.branchNum = branchNum;
    }

    protected class_5142<BranchingTrunkPlacer> method_28903() {
        return ESTreePlacers.TRUNK_BRANCHING.get();
    }

    public List<class_4647.class_5208> method_26991(class_3746 reader, BiConsumer<class_2338, class_2680> placer, class_5819 random, int height, class_2338 startPos, class_4643 config) {
        int numBranchesLayer = this.branchLayerNum.method_35008(random);
        int numBranches = this.branchNum.method_35008(random);
        int lenBranches = this.branchLen.method_35008(random);
        for (int x = 0; x <= 1; ++x) {
            for (int z = 0; z <= 1; ++z) {
                class_2338 pos = startPos.method_10069(x, 0, z);
                if (!reader.method_16358(pos, state -> state.method_26215() || state.method_26164(class_3481.field_15462))) continue;
                placer.accept(pos, config.field_21288.method_23455(random, pos));
                placer.accept(pos, class_2246.field_10124.method_9564());
            }
        }
        return this.placeBranchingTrunk(reader, placer, startPos, random, height, numBranchesLayer, numBranches, lenBranches, config);
    }

    private List<class_4647.class_5208> placeBranchingTrunk(class_3746 level, BiConsumer<class_2338, class_2680> placer, class_2338 origin, class_5819 random, int height, int numBranchesLayer, int numBranches, int lenBranches, class_4643 config) {
        ArrayList leafAttachments = Lists.newArrayList();
        int distBetweenLayers = height / (2 * numBranchesLayer);
        int radius = this.trunkRadius.method_35008(random);
        leafAttachments.add(new class_4647.class_5208(origin.method_10069(0, height, 0), 2, false));
        for (int y = 0; y <= height; ++y) {
            boolean shouldAddLayer = y >= height / 2 && y < height - distBetweenLayers && y % distBetweenLayers == 0 || y == height - 2;
            boolean bigLayer = y == height - 2;
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    if (radius != 0 && (x == radius && (z == radius || z == -radius) || x == -radius && (z == radius || z == -radius))) continue;
                    BranchingTrunkPlacer.safeSetDirt(level, placer, random, origin.method_10069(x, -1, z), config);
                    class_2338 pos = origin.method_10069(x, y, z);
                    if (shouldAddLayer && x == 0 & z == 0) {
                        float yawOffset = random.method_43057() * 360.0f;
                        for (int i = 0; i < numBranches; ++i) {
                            class_2338 branchLayerPos = pos.method_10069(0, random.method_43048(5) - 2, 0);
                            class_243 vec3 = ESMathUtil.rotationToPosition(new class_243((double)branchLayerPos.method_10263(), (double)branchLayerPos.method_10264(), (double)branchLayerPos.method_10260()), ((float)lenBranches - (float)(bigLayer ? 2 : 0) / 2.0f) * (float)SQRT_3, 30.0f, 360.0f / (float)numBranches * (float)i + yawOffset);
                            class_2338 endPos = new class_2338((int)vec3.field_1352, (int)vec3.field_1351, (int)vec3.field_1350);
                            List<int[]> points = ESMathUtil.getBresenham3DPoints(branchLayerPos.method_10263(), branchLayerPos.method_10264(), branchLayerPos.method_10260(), endPos.method_10263(), endPos.method_10264(), endPos.method_10260());
                            for (int[] point : points) {
                                this.method_35375(level, placer, random, new class_2338(point[0], point[1], point[2]), config);
                            }
                            int len = points.size();
                            if (radius == 0) {
                                this.method_35375(level, placer, random, new class_2338(points.get(len - 1)[0], points.get(len - 1)[1], points.get(len - 1)[2]), config);
                            }
                            this.method_35375(level, placer, random, new class_2338(points.get(len - 1)[0] + 1, points.get(len - 1)[1], points.get(len - 1)[2] + 1), config);
                            this.method_35375(level, placer, random, new class_2338(points.get(len - 1)[0] + 1, points.get(len - 1)[1], points.get(len - 1)[2] - 1), config);
                            this.method_35375(level, placer, random, new class_2338(points.get(len - 1)[0] - 1, points.get(len - 1)[1], points.get(len - 1)[2] + 1), config);
                            this.method_35375(level, placer, random, new class_2338(points.get(len - 1)[0] - 1, points.get(len - 1)[1], points.get(len - 1)[2] - 1), config);
                            leafAttachments.add(new class_4647.class_5208(endPos, bigLayer ? 1 : 0, false));
                        }
                    }
                    this.method_35375(level, placer, random, pos, config);
                    if (y != height) continue;
                    this.method_35375(level, placer, random, pos.method_10069(1, 0, 1), config);
                    this.method_35375(level, placer, random, pos.method_10069(1, 0, -1), config);
                    this.method_35375(level, placer, random, pos.method_10069(-1, 0, 1), config);
                    this.method_35375(level, placer, random, pos.method_10069(-1, 0, -1), config);
                }
            }
        }
        return leafAttachments;
    }

    protected static void safeSetDirt(class_3746 level, BiConsumer<class_2338, class_2680> placer, class_5819 random, class_2338 pos, class_4643 config) {
        if ((level.method_16358(pos, class_4970.class_4971::method_26215) || level.method_16358(pos, class_4970.class_4971::method_45474) || level.method_16358(pos, state -> state.method_26204() instanceof class_2404)) && (config.field_29281 || !BranchingTrunkPlacer.isDirt(level, pos))) {
            placer.accept(pos, config.field_29279.method_23455(random, pos));
        }
    }

    private static boolean isDirt(class_3746 level, class_2338 blockPos) {
        return level.method_16358(blockPos, blockState -> class_3031.method_23396((class_2680)blockState) && !blockState.method_27852(class_2246.field_10219) && !blockState.method_27852(class_2246.field_10402));
    }
}

