/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.model.entity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.client.model.animation.AnimatedEntityModel;
import cn.leolezury.eternalstarlight.common.client.model.animation.definition.RatlinAnimation;
import cn.leolezury.eternalstarlight.common.entity.living.animal.Ratlin;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RatlinModel<T extends Ratlin>
extends AnimatedEntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(EternalStarlight.id("ratlin"), "main");
    private final ModelPart root;
    private final ModelPart head;

    public RatlinModel(ModelPart root) {
        this.root = root.getChild("root");
        this.head = root.getChild("root").getChild("body").getChild("head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-6.5f, -11.0f, -8.0f, 13.0f, 11.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-3.0f, (float)0.0f));
        body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(26, 27).addBox(-2.0f, -2.0f, -0.5f, 4.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)5.5f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 27).addBox(-3.5f, -4.0f, -6.0f, 7.0f, 11.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.5f, (float)-7.0f, (float)-8.0f));
        head.addOrReplaceChild("left_ear", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-0.5f, -6.0f, 0.0f, 7.0f, 10.0f, 0.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)3.0f, (float)0.0f, (float)-3.0f));
        head.addOrReplaceChild("right_ear", CubeListBuilder.create().texOffs(0, 0).addBox(-6.5f, -6.0f, 0.0f, 7.0f, 10.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)0.0f, (float)-3.0f));
        root.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(39, 41).addBox(-2.0f, 0.0f, -2.5f, 4.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)-3.0f, (float)-4.5f));
        root.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(39, 41).addBox(-2.0f, 0.0f, -2.5f, 4.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)-3.0f, (float)-4.5f));
        root.addOrReplaceChild("left_rear_leg", CubeListBuilder.create().texOffs(26, 38).addBox(-2.0f, 0.0f, -2.5f, 4.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)-3.0f, (float)4.5f));
        root.addOrReplaceChild("right_rear_leg", CubeListBuilder.create().texOffs(39, 41).addBox(-2.0f, 0.0f, -2.5f, 4.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)-3.0f, (float)4.5f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        if (this.young) {
            this.root.xScale = 0.6f;
            this.root.yScale = 0.6f;
            this.root.zScale = 0.6f;
            this.head.xScale = 1.67f;
            this.head.yScale = 1.67f;
            this.head.zScale = 1.67f;
        }
        this.animate(((Ratlin)((Object)entity)).idleAnimationState, RatlinAnimation.IDLE, ageInTicks);
        this.animateWalk(RatlinAnimation.WALK, limbSwing, limbSwingAmount, this.young ? 3.0f : 5.0f, 1.0f);
    }

    @Override
    public ModelPart root() {
        return this.root;
    }
}

