/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.renderer.blockentity;

import cn.leolezury.eternalstarlight.common.block.ESPortalBlock;
import cn.leolezury.eternalstarlight.common.block.entity.ESPortalBlockEntity;
import cn.leolezury.eternalstarlight.common.client.ESRenderType;
import cn.leolezury.eternalstarlight.common.client.handler.ClientHandlers;
import cn.leolezury.eternalstarlight.common.config.ESConfig;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ESPortalRenderer<T extends ESPortalBlockEntity>
implements BlockEntityRenderer<T> {
    public ESPortalRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(T portal, float f, PoseStack stack, MultiBufferSource bufferSource, int light, int overlay) {
        if (ESConfig.INSTANCE.enablePortalShader && ((Boolean)portal.getBlockState().getValue((Property)ESPortalBlock.CENTER)).booleanValue()) {
            VertexConsumer vertexConsumer = ClientHandlers.DELAYED_BUFFER_SOURCE.getBuffer(ESRenderType.PORTAL);
            PoseStack.Pose pose = stack.last();
            float radius = 0.6f * (float)((Integer)portal.getBlockState().getValue((Property)ESPortalBlock.SIZE)).intValue() * (Math.min((float)((ESPortalBlockEntity)((Object)portal)).getClientSideTickCount() + Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(Minecraft.getInstance().level != null && Minecraft.getInstance().level.tickRateManager().runsNormally()), 60.0f) / 60.0f);
            if (portal.getBlockState().getValue(ESPortalBlock.AXIS) == Direction.Axis.X) {
                vertexConsumer.addVertex(pose, -radius, -radius, 0.5f).setColor(1, 1, 1, 1).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 1.0f, 0.0f);
                vertexConsumer.addVertex(pose, -radius, 1.0f + radius, 0.5f).setColor(1, 1, 1, 1).setUv(0.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 1.0f, 0.0f);
                vertexConsumer.addVertex(pose, 1.0f + radius, 1.0f + radius, 0.5f).setColor(1, 1, 1, 1).setUv(1.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 1.0f, 0.0f);
                vertexConsumer.addVertex(pose, 1.0f + radius, -radius, 0.5f).setColor(1, 1, 1, 1).setUv(1.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 1.0f, 0.0f);
            } else {
                vertexConsumer.addVertex(pose, 0.5f, -radius, -radius).setColor(1, 1, 1, 1).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 1.0f, 0.0f);
                vertexConsumer.addVertex(pose, 0.5f, 1.0f + radius, -radius).setColor(1, 1, 1, 1).setUv(0.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 1.0f, 0.0f);
                vertexConsumer.addVertex(pose, 0.5f, 1.0f + radius, 1.0f + radius).setColor(1, 1, 1, 1).setUv(1.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 1.0f, 0.0f);
                vertexConsumer.addVertex(pose, 0.5f, -radius, 1.0f + radius).setColor(1, 1, 1, 1).setUv(1.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 1.0f, 0.0f);
            }
        }
    }
}

