/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.projectile;

import cn.leolezury.eternalstarlight.common.data.ESDimensions;
import cn.leolezury.eternalstarlight.common.network.ParticlePacket;
import cn.leolezury.eternalstarlight.common.particle.ESExplosionParticleOptions;
import cn.leolezury.eternalstarlight.common.particle.ExplosionShockParticleOptions;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.registry.ESEntities;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import cn.leolezury.eternalstarlight.common.registry.ESWeathers;
import cn.leolezury.eternalstarlight.common.util.ESWeatherUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class AetherstrikeRocketEntity
extends Projectile
implements ItemSupplier {
    private final String TAG_LIFE = "life";
    private final String TAG_LIFETIME = "lifetime";
    private final String TAG_ITEM = "item";
    private final String TAG_SHOT_AT_ANGLE = "shot_at_angle";
    private static final EntityDataAccessor<ItemStack> ITEM = SynchedEntityData.defineId(AetherstrikeRocketEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private static final EntityDataAccessor<Boolean> SHOT_AT_ANGLE = SynchedEntityData.defineId(AetherstrikeRocketEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private int life;
    private int lifetime;

    public AetherstrikeRocketEntity(EntityType<? extends AetherstrikeRocketEntity> entityType, Level level) {
        super(entityType, level);
    }

    public AetherstrikeRocketEntity(Level level, double x, double y, double z, ItemStack stack) {
        super(ESEntities.AETHERSTRIKE_ROCKET.get(), level);
        this.life = 0;
        this.setPos(x, y, z);
        this.entityData.set(ITEM, (Object)stack.copy());
        this.setDeltaMovement(this.random.triangle(0.0, 0.002297), 0.05, this.random.triangle(0.0, 0.002297));
        this.lifetime = 25 + this.random.nextInt(6) + this.random.nextInt(7);
    }

    public AetherstrikeRocketEntity(Level level, @Nullable Entity shooter, double x, double y, double z, ItemStack stack) {
        this(level, x, y, z, stack);
        this.setOwner(shooter);
    }

    public AetherstrikeRocketEntity(Level level, ItemStack stack, double x, double y, double z, boolean shotAtAngle) {
        this(level, x, y, z, stack);
        this.entityData.set(SHOT_AT_ANGLE, (Object)shotAtAngle);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(ITEM, (Object)AetherstrikeRocketEntity.getDefaultItem()).define(SHOT_AT_ANGLE, (Object)false);
    }

    public void tick() {
        super.tick();
        if (!this.isShotAtAngle()) {
            double horizontal = this.horizontalCollision ? 1.0 : 1.15;
            this.setDeltaMovement(this.getDeltaMovement().multiply(horizontal, 1.0, horizontal).add(0.0, 0.04, 0.0));
        }
        Vec3 movement = this.getDeltaMovement();
        this.move(MoverType.SELF, movement);
        this.setDeltaMovement(movement);
        HitResult hitResult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, x$0 -> this.canHitEntity((Entity)x$0));
        if (!this.noPhysics) {
            this.hitTargetOrDeflectSelf(hitResult);
            this.hasImpulse = true;
        }
        this.updateRotation();
        if (this.life == 0 && !this.isSilent()) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.FIREWORK_ROCKET_LAUNCH, SoundSource.AMBIENT, 3.0f, 1.0f);
        }
        ++this.life;
        if (this.level().isClientSide && this.life % 2 == 0) {
            this.level().addParticle((ParticleOptions)ESExplosionParticleOptions.AETHERSENT, this.getX() - movement.x, this.getY() - movement.y, this.getZ() - movement.z, this.random.nextGaussian() * 0.05, -this.getDeltaMovement().y * 0.5, this.random.nextGaussian() * 0.05);
        }
        if (!this.level().isClientSide && this.life > this.lifetime) {
            this.explode();
        }
    }

    private void explode() {
        ServerLevel serverLevel;
        this.gameEvent((Holder)GameEvent.EXPLODE, this.getOwner());
        this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.FIREWORK_ROCKET_LARGE_BLAST, SoundSource.AMBIENT, 25.0f, 0.95f + this.random.nextFloat() * 0.1f);
        Level level = this.level();
        if (level instanceof ServerLevel && (serverLevel = (ServerLevel)level).dimension().location().equals((Object)ESDimensions.STARLIGHT_KEY.location())) {
            int i;
            for (i = 0; i < 4; ++i) {
                Vec3 vec3 = this.position().offsetRandom(this.getRandom(), 1.5f);
                for (int s = 0; s < serverLevel.players().size(); ++s) {
                    ServerPlayer serverPlayer = (ServerPlayer)serverLevel.players().get(s);
                    serverLevel.sendParticles(serverPlayer, (ParticleOptions)ESExplosionParticleOptions.AETHERSENT, true, vec3.x, vec3.y, vec3.z, 3, 0.0, 0.0, 0.0, 0.0);
                }
            }
            for (i = 0; i < 30; ++i) {
                Vec3 speed = new Vec3((double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f), (double)(this.random.nextFloat() * 0.05f), (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f)).normalize();
                ESPlatform.INSTANCE.sendToAllClients(serverLevel, new ParticlePacket(ExplosionShockParticleOptions.AETHERSENT, this.getEyePosition().x + speed.x * 1.2, this.getEyePosition().y + speed.y * 1.2, this.getEyePosition().z + speed.z * 1.2, speed.x, speed.y, speed.z));
            }
            if ((double)this.getRandom().nextFloat() < 0.6 && this.level().canSeeSky(this.blockPosition())) {
                ESWeatherUtil.getOrCreateWeathers(serverLevel).setActiveWeather(ESWeathers.METEOR_SHOWER.get(), ESWeathers.METEOR_SHOWER.get().weatherProperties().duration().sample(serverLevel.getRandom()));
                Entity entity = this.getOwner();
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    player.getCooldowns().addCooldown(this.getItem().getItem(), 2400);
                }
            }
        }
        this.discard();
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        if (!this.level().isClientSide) {
            this.explode();
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        BlockPos blockpos = new BlockPos((Vec3i)result.getBlockPos());
        this.level().getBlockState(blockpos).entityInside(this.level(), blockpos, (Entity)this);
        if (!this.level().isClientSide()) {
            this.explode();
        }
        super.onHitBlock(result);
    }

    public boolean isShotAtAngle() {
        return (Boolean)this.entityData.get(SHOT_AT_ANGLE);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("life", this.life);
        compound.putInt("lifetime", this.lifetime);
        compound.put("item", this.getItem().save((HolderLookup.Provider)this.registryAccess()));
        compound.putBoolean("shot_at_angle", ((Boolean)this.entityData.get(SHOT_AT_ANGLE)).booleanValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.life = compound.getInt("life");
        this.lifetime = compound.getInt("lifetime");
        if (compound.contains("item", 10)) {
            this.entityData.set(ITEM, (Object)ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)compound.getCompound("item")).orElseGet(AetherstrikeRocketEntity::getDefaultItem));
        } else {
            this.entityData.set(ITEM, (Object)AetherstrikeRocketEntity.getDefaultItem());
        }
        if (compound.contains("shot_at_angle")) {
            this.entityData.set(SHOT_AT_ANGLE, (Object)compound.getBoolean("shot_at_angle"));
        }
    }

    public ItemStack getItem() {
        return (ItemStack)this.entityData.get(ITEM);
    }

    public boolean isAttackable() {
        return false;
    }

    private static ItemStack getDefaultItem() {
        return new ItemStack((ItemLike)ESItems.AETHERSTRIKE_ROCKET.get());
    }
}

