/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.projectile;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.client.ESRenderType;
import cn.leolezury.eternalstarlight.common.data.ESDamageTypes;
import cn.leolezury.eternalstarlight.common.entity.attack.EnergizedFlame;
import cn.leolezury.eternalstarlight.common.entity.attack.PermafrostCloud;
import cn.leolezury.eternalstarlight.common.entity.interfaces.TrailOwner;
import cn.leolezury.eternalstarlight.common.particle.ESExplosionParticleOptions;
import cn.leolezury.eternalstarlight.common.registry.ESEntities;
import cn.leolezury.eternalstarlight.common.util.ESEntityUtil;
import cn.leolezury.eternalstarlight.common.util.ESMathUtil;
import cn.leolezury.eternalstarlight.common.util.TrailEffect;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Vector4f;

public class PermafrostSpit
extends ThrowableProjectile
implements TrailOwner {
    private static final ResourceLocation TRAIL_TEXTURE = EternalStarlight.id("textures/entity/trail.png");
    private static final String TAG_SMALL = "small";
    protected static final EntityDataAccessor<Boolean> SMALL = SynchedEntityData.defineId(PermafrostSpit.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public boolean isSmall() {
        return (Boolean)this.getEntityData().get(SMALL);
    }

    public void setSmall(boolean small) {
        this.getEntityData().set(SMALL, (Object)small);
    }

    public PermafrostSpit(EntityType<? extends PermafrostSpit> entityType, Level level) {
        super(entityType, level);
    }

    public PermafrostSpit(Level level, LivingEntity livingEntity) {
        super(ESEntities.PERMAFROST_SPIT.get(), livingEntity, level);
    }

    public PermafrostSpit(Level level, double x, double y, double z) {
        super(ESEntities.PERMAFROST_SPIT.get(), x, y, z, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(SMALL, (Object)false);
    }

    protected void onHit(HitResult hitResult) {
        super.onHit(hitResult);
        if (hitResult.getType() != HitResult.Type.MISS) {
            Level i2;
            LivingEntity living;
            PermafrostCloud cloud = new PermafrostCloud(ESEntities.PERMAFROST_CLOUD.get(), this.level());
            Entity entity = this.getOwner();
            if (entity instanceof LivingEntity) {
                living = (LivingEntity)entity;
                cloud.setOwner(living);
            }
            cloud.setSmall(this.isSmall());
            cloud.setPos(hitResult.getLocation());
            this.level().addFreshEntity((Entity)cloud);
            if (!this.isSmall() && (entity = this.getOwner()) instanceof LivingEntity) {
                living = (LivingEntity)entity;
                for (int i2 = 0; i2 < 5; ++i2) {
                    Vec3 delta = ESMathUtil.rotationToPosition(1.0f, 35.0f, 360.0f * (float)i2 / 5.0f + (float)this.getRandom().nextInt(30));
                    PermafrostSpit spit = new PermafrostSpit(this.level(), living);
                    spit.shoot(delta.x, delta.y, delta.z, 0.4f, 0.1f);
                    spit.setPos(this.position());
                    spit.setSmall(true);
                    this.level().addFreshEntity((Entity)spit);
                }
            }
            if ((i2 = this.level()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)i2;
                serverLevel.sendParticles((ParticleOptions)ESExplosionParticleOptions.ENERGY, this.getX(), this.getY() + (double)(this.getBbHeight() / 2.0f), this.getZ(), 20, (double)(this.getBbWidth() / 2.0f), (double)(this.getBbHeight() / 2.0f), (double)(this.getBbWidth() / 2.0f), 0.0);
            }
            for (int x = -4; x <= 4; ++x) {
                for (int y = -4; y <= 4; ++y) {
                    for (int z = -4; z <= 4; ++z) {
                        BlockPos pos = this.blockPosition().offset(x, y, z);
                        if (this.level().getBlockState(pos).is(Blocks.FIRE) && this.blockPosition().distSqr((Vec3i)pos) <= 16.0) {
                            this.level().setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                        }
                        if (this.level().getBlockState(pos).is(Blocks.WATER) && this.level().getFluidState(pos).isSource() && this.blockPosition().distSqr((Vec3i)pos) <= 16.0) {
                            this.level().setBlockAndUpdate(pos, Blocks.ICE.defaultBlockState());
                        }
                        if (!this.level().getBlockState(pos).is(Blocks.LAVA) || !this.level().getFluidState(pos).isSource() || !(this.blockPosition().distSqr((Vec3i)pos) <= 4.0)) continue;
                        this.level().setBlockAndUpdate(pos, Blocks.MAGMA_BLOCK.defaultBlockState());
                    }
                }
            }
            this.level().getEntitiesOfClass(EnergizedFlame.class, this.getBoundingBox().inflate(5.0)).forEach(Entity::discard);
            this.discard();
        }
    }

    protected void onHitEntity(EntityHitResult hitResult) {
        LivingEntity owner;
        Entity entity;
        if (hitResult.getType() != HitResult.Type.MISS && (entity = this.getOwner()) instanceof LivingEntity && ESEntityUtil.shouldHarm((Entity)(owner = (LivingEntity)entity), hitResult.getEntity())) {
            hitResult.getEntity().hurt(ESDamageTypes.getIndirectEntityDamageSource(this.level(), ESDamageTypes.FREEZE, (Entity)this, (Entity)owner), (float)((owner.getAttribute(Attributes.ATTACK_SPEED) != null ? owner.getAttributeValue(Attributes.ATTACK_SPEED) : 12.0) * 1.25));
        }
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setSmall(tag.getBoolean(TAG_SMALL));
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean(TAG_SMALL, this.isSmall());
    }

    @Override
    public TrailEffect newTrail() {
        return new TrailEffect(0.3f, 8);
    }

    @Override
    public void updateTrail(TrailEffect effect) {
        Vec3 oldPos = new Vec3(this.xOld, this.yOld, this.zOld);
        effect.update(oldPos.add(0.0, (double)(this.getBbHeight() / 2.0f), 0.0));
        if (this.isRemoved()) {
            effect.setLength(Math.max(effect.getLength() - 0.9f, 0.0f));
        }
    }

    @Override
    public Vector4f getTrailColor() {
        return new Vector4f(0.40784314f, 0.8f, 1.0f, 1.0f);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public RenderType getTrailRenderType() {
        return ESRenderType.entityTranslucentNoDepth(TRAIL_TEXTURE);
    }
}

