/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.spell;

import cn.leolezury.eternalstarlight.common.registry.ESSpells;
import cn.leolezury.eternalstarlight.common.spell.AbstractSpell;
import java.util.Objects;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;

public record SpellCastData(boolean hasSpell, AbstractSpell spell, int strength, int castTicks, boolean offhand) {
    private final boolean hasSpell;
    public static final StreamCodec<RegistryFriendlyByteBuf, SpellCastData> STREAM_CODEC = StreamCodec.ofMember(SpellCastData::toNetwork, SpellCastData::fromNetwork);

    public static SpellCastData getDefault() {
        return new SpellCastData(false, ESSpells.GUIDANCE_OF_STARS.get(), 0, 0, false);
    }

    public boolean hasSpell() {
        return this.hasSpell && this.spell() != null;
    }

    public SpellCastData increaseTick() {
        return new SpellCastData(this.hasSpell(), this.spell(), this.strength(), this.castTicks() + 1, this.offhand());
    }

    public static SpellCastData fromNetwork(RegistryFriendlyByteBuf buf) {
        boolean hasSpell = buf.readBoolean();
        AbstractSpell spell = (AbstractSpell)buf.readById(arg_0 -> ESSpells.SPELLS.registry().byId(arg_0));
        int strength = buf.readInt();
        int ticks = buf.readInt();
        boolean offhand = buf.readBoolean();
        return new SpellCastData(hasSpell, spell, strength, ticks, offhand);
    }

    public void toNetwork(RegistryFriendlyByteBuf buf) {
        buf.writeBoolean(this.hasSpell());
        buf.writeById(arg_0 -> ESSpells.SPELLS.registry().getId(arg_0), (Object)this.spell());
        buf.writeInt(this.strength());
        buf.writeInt(this.castTicks());
        buf.writeBoolean(this.offhand());
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpellCastData that = (SpellCastData)o;
        return this.strength == that.strength && this.castTicks == that.castTicks && this.offhand == that.offhand && this.hasSpell == that.hasSpell && Objects.equals(this.spell, that.spell);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.hasSpell, this.spell, this.strength, this.castTicks, this.offhand);
    }

    public static interface SpellSource {
        public boolean canContinue(LivingEntity var1);
    }

    public record ItemSpellSource(Item item, InteractionHand hand) implements SpellSource
    {
        @Override
        public boolean canContinue(LivingEntity living) {
            return living.getItemInHand(this.hand()).is(this.item());
        }
    }
}

