/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.weather;

import cn.leolezury.eternalstarlight.common.registry.ESWeathers;
import cn.leolezury.eternalstarlight.common.weather.AbstractWeather;
import cn.leolezury.eternalstarlight.common.weather.WeatherInstance;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public class Weathers
extends SavedData {
    private static final String TAG_WEATHERS = "weathers";
    private final ServerLevel serverLevel;
    private final List<WeatherInstance> weathers = new ArrayList<WeatherInstance>();

    public Weathers(ServerLevel serverLevel) {
        this.serverLevel = serverLevel;
        ESWeathers.WEATHERS.registry().forEach(weather -> {
            WeatherInstance instance = new WeatherInstance(serverLevel, (AbstractWeather)weather);
            this.weathers.add(instance);
        });
    }

    public List<WeatherInstance> getWeathers() {
        return this.weathers;
    }

    public Optional<WeatherInstance> getActiveWeather() {
        for (WeatherInstance instance : this.getWeathers()) {
            if (!instance.active) continue;
            return Optional.of(instance);
        }
        return Optional.empty();
    }

    public void setActiveWeather(AbstractWeather weather, int duration) {
        for (WeatherInstance instance : this.getWeathers()) {
            if (!instance.active && instance.getWeather() == weather) {
                instance.start();
                instance.currentDuration = duration;
            }
            if (!instance.active || instance.getWeather() == weather) continue;
            instance.stop();
        }
        this.setDirty();
    }

    public void clearAllWeathers(int duration) {
        for (WeatherInstance instance : this.getWeathers()) {
            instance.stop();
            instance.ticksUntilNext = duration;
        }
        this.setDirty();
    }

    public static SavedData.Factory<Weathers> factory(ServerLevel serverLevel) {
        return new SavedData.Factory(() -> new Weathers(serverLevel), (compoundTag, lookup) -> Weathers.load(serverLevel, compoundTag), null);
    }

    public void tick() {
        ArrayList<WeatherInstance> canStartWeathers = new ArrayList<WeatherInstance>();
        boolean hasActive = false;
        for (WeatherInstance instance : this.weathers) {
            if (instance.tick()) {
                canStartWeathers.add(instance);
            }
            hasActive = hasActive || instance.active;
        }
        if (!hasActive && !canStartWeathers.isEmpty()) {
            ((WeatherInstance)canStartWeathers.get(this.serverLevel.getRandom().nextInt(canStartWeathers.size()))).start();
        }
        this.setDirty();
    }

    public static Weathers load(ServerLevel serverLevel, CompoundTag compoundTag) {
        Weathers weathersData = new Weathers(serverLevel);
        if (compoundTag.contains(TAG_WEATHERS, 10)) {
            CompoundTag weathersTag = compoundTag.getCompound(TAG_WEATHERS);
            ESWeathers.WEATHERS.registry().forEach(weather -> {
                WeatherInstance instance = new WeatherInstance(serverLevel, (AbstractWeather)weather);
                String id = Objects.requireNonNull(ESWeathers.WEATHERS.registry().getKey(weather)).toString();
                if (weathersTag.contains(id, 10)) {
                    instance.load(weathersTag.getCompound(id));
                }
                weathersData.weathers.add(instance);
            });
        }
        return weathersData;
    }

    public CompoundTag save(CompoundTag compoundTag, HolderLookup.Provider provider) {
        CompoundTag weathersTag = new CompoundTag();
        for (WeatherInstance instance : this.weathers) {
            String id = Objects.requireNonNull(ESWeathers.WEATHERS.registry().getKey((Object)instance.getWeather())).toString();
            CompoundTag weatherTag = new CompoundTag();
            instance.save(weatherTag);
            weathersTag.put(id, (Tag)weatherTag);
        }
        compoundTag.put(TAG_WEATHERS, (Tag)weathersTag);
        return compoundTag;
    }
}

