/*
 * Decompiled with CFR 0.152.
 */
package com.hermitowo.tfcvesseltooltip;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.dries007.tfc.common.component.fluid.FluidContainerInfo;
import net.dries007.tfc.common.component.mold.Vessel;
import net.dries007.tfc.common.items.VesselItem;
import net.dries007.tfc.common.recipes.HeatingRecipe;
import net.dries007.tfc.util.FluidAlloy;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

@Mod(value="tfcvesseltooltip")
@EventBusSubscriber(modid="tfcvesseltooltip", value={Dist.CLIENT})
public class TFCVesselTooltip {
    public static final String MOD_ID = "tfcvesseltooltip";

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onItemTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        List text = event.getToolTip();
        if (stack.isEmpty()) {
            return;
        }
        if (!(stack.getItem() instanceof VesselItem)) {
            return;
        }
        Vessel vessel = Vessel.get((ItemStack)stack);
        Vessel vessel2 = vessel = vessel != null && vessel.isInventory() ? vessel : null;
        if (vessel == null) {
            return;
        }
        HashMap<Fluid, Integer> map = new HashMap<Fluid, Integer>();
        for (Object item : vessel.contents()) {
            FluidStack fluid2;
            @Nullable HeatingRecipe heatingRecipe = HeatingRecipe.getRecipe((ItemStack)item);
            if (heatingRecipe == null || (fluid2 = heatingRecipe.assembleFluid((ItemStack)item)).isEmpty()) continue;
            map.computeIfPresent(fluid2.getFluid(), (arg_0, arg_1) -> TFCVesselTooltip.lambda$onItemTooltip$0(fluid2, (ItemStack)item, arg_0, arg_1));
            map.putIfAbsent(fluid2.getFluid(), fluid2.getAmount() * item.getCount());
        }
        if (!map.isEmpty()) {
            text.add(Component.translatable((String)"tfc.tooltip.small_vessel.contents").withStyle(ChatFormatting.DARK_GREEN));
            int total = map.values().stream().reduce(0, Integer::sum);
            for (Map.Entry entry : map.entrySet()) {
                Fluid fluid2 = (Fluid)entry.getKey();
                int amount2 = (Integer)entry.getValue();
                String percentage = String.format("%.1f", Float.valueOf((float)amount2 / (float)total * 100.0f)) + "%";
                text.add(Component.translatable((String)"tfcvesseltooltip.tooltip.metal", (Object[])new Object[]{amount2, fluid2.getFluidType().getDescription(), Component.literal((String)percentage).withStyle(ChatFormatting.GREEN)}));
            }
            if (map.size() > 1) {
                text.add(Component.translatable((String)"tfcvesseltooltip.tooltip.smelts_into").withStyle(ChatFormatting.DARK_GREEN));
                FluidAlloy alloy = FluidAlloy.empty();
                Vessel.ContainerInfo containerInfo = vessel.containerInfo();
                map.forEach((fluid, amount) -> alloy.fill(new FluidStack(fluid, amount.intValue()), IFluidHandler.FluidAction.EXECUTE, (FluidContainerInfo)containerInfo));
                text.add(Component.translatable((String)"tfcvesseltooltip.tooltip.alloy", (Object[])new Object[]{total, alloy.getResult().getHoverName()}));
            }
        }
    }

    private static /* synthetic */ Integer lambda$onItemTooltip$0(FluidStack fluid, ItemStack item, Fluid key, Integer value) {
        return value + fluid.getAmount() * item.getCount();
    }
}

