/*
 * Decompiled with CFR 0.152.
 */
package me.dreamvoid.miraimcaddon.overflow;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import me.dreamvoid.miraimc.api.MiraiMC;
import me.dreamvoid.miraimcaddon.overflow.Platform;
import me.dreamvoid.miraimcaddon.overflow.objects.Overflow;
import net.mamoe.mirai.Bot;
import net.mamoe.mirai.utils.LoggerAdapters;
import org.slf4j.Logger;
import top.mrxiaom.overflow.BotBuilder;

public class OverflowLifeCycle {
    private final Platform plugin;
    private Overflow overflowConfig;
    private Bot bot;

    public OverflowLifeCycle(Platform plugin) {
        this.plugin = plugin;
    }

    public void loadOverflowLibrary() {
        try {
            MiraiMC.getPlatform().getLibraryLoader().loadLibraryMaven(System.getProperty("MiraiMC.Overflow.dependency.groupId", "top.mrxiaom.mirai"), System.getProperty("MiraiMC.Overflow.dependency.artifactId", "overflow-core-all"), System.getProperty("MiraiMC.Overflow.dependency.version", "1.0.6"), System.getProperty("MiraiMC.Overflow.repo.url", "https://repo.huaweicloud.com/repository/maven/"), "-all.jar", this.plugin.getDataPath().resolve("libs"));
            System.setProperty("MiraiMC.do-not-load-mirai-core", "Overflow");
        }
        catch (Exception e) {
            this.plugin.getPluginLogger().error("\u65e0\u6cd5\u52a0\u8f7d Overflow\uff01", (Throwable)e);
        }
    }

    public void loadConfig() {
        File file = this.plugin.getDataPath().resolve("overflow.json").toFile();
        if (!file.exists()) {
            try (InputStream is = this.getClass().getResourceAsStream("/overflow.json");){
                assert (is != null);
                Files.copy(is, file.toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                this.plugin.getPluginLogger().error("\u65e0\u6cd5\u4fdd\u5b58\u9ed8\u8ba4\u7684 overflow.json\uff01", (Throwable)e);
            }
        }
        try {
            this.overflowConfig = (Overflow)new Gson().fromJson((Reader)new FileReader(file), Overflow.class);
        }
        catch (FileNotFoundException e) {
            this.plugin.getPluginLogger().error("\u8bfb\u53d6 Overflow \u914d\u7f6e\u65f6\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
        }
    }

    public void connect() {
        MiraiMC.getPlatform().runTaskAsync(() -> {
            Platform platform = this.plugin;
            synchronized (platform) {
                if (this.bot != null) {
                    this.plugin.getPluginLogger().info("\u53e6\u4e00\u4e2a\u673a\u5668\u4eba\u8fdb\u7a0b\u5df2\u7ecf\u5b58\u5728\uff0c\u6b63\u5728\u5173\u95ed\u5176\u4ed6\u673a\u5668\u4eba...");
                    this.disconnect();
                }
                BotBuilder builder = this.overflowConfig.getReversedWsPort() == -1 ? BotBuilder.positive((String)this.overflowConfig.getWsHost()) : BotBuilder.reversed((int)this.overflowConfig.getReversedWsPort());
                builder.token(this.overflowConfig.getToken());
                if (this.overflowConfig.isNoPlatform()) {
                    builder.noPlatform();
                }
                if (this.overflowConfig.isUseCqCode()) {
                    builder.useCQCode();
                }
                builder.retryTimes(this.overflowConfig.getRetryTimes());
                builder.retryWaitMills(this.overflowConfig.getRetryWaitMills());
                builder.retryRestMills(this.overflowConfig.getRetryRestMills());
                builder.heartbeatCheckSeconds(this.overflowConfig.getHeartbeatCheckSeconds());
                if (!this.overflowConfig.isDropEventsBeforeConnected()) {
                    builder.keepEventsBeforeConnected();
                }
                this.bot = builder.modifyBotConfiguration(configuration -> {
                    if (MiraiMC.getConfig().Bot_DisableBotLogs) {
                        configuration.noBotLog();
                    } else if (MiraiMC.getConfig().Bot_UseMinecraftLogger_BotLogs) {
                        configuration.setBotLoggerSupplier(bot1 -> LoggerAdapters.asMiraiLogger((Logger)this.plugin.getPluginLogger()));
                    }
                    if (MiraiMC.getConfig().Bot_DisableNetworkLogs) {
                        configuration.noNetworkLog();
                    } else if (MiraiMC.getConfig().Bot_UseMinecraftLogger_NetworkLogs) {
                        configuration.setNetworkLoggerSupplier(bot1 -> LoggerAdapters.asMiraiLogger((Logger)this.plugin.getPluginLogger()));
                    }
                }).overrideLogger(this.plugin.getPluginLogger()).connect();
            }
        });
    }

    public void disconnect() {
        if (this.bot != null) {
            this.plugin.getPluginLogger().info("\u6b63\u5728\u5173\u95ed Overflow \u673a\u5668\u4eba");
            this.bot.close();
            this.bot = null;
        }
    }
}

