/*
 * Decompiled with CFR 0.152.
 */
package me.dreamvoid.miraimcaddon.overflow.velocity;

import com.google.inject.Inject;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandManager;
import com.velocitypowered.api.command.CommandMeta;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.Dependency;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import java.nio.file.Path;
import java.util.Map;
import me.dreamvoid.miraimcaddon.overflow.OverflowLifeCycle;
import me.dreamvoid.miraimcaddon.overflow.Platform;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.slf4j.Logger;

@Plugin(id="miraimcaddon-overflow", name="MiraiMCAddon-Overflow", version="1.3", description="Overflow support for MiraiMC", authors={"DreamVoid"}, dependencies={@Dependency(id="miraimc")})
public class VelocityPlugin
implements Platform {
    private final ProxyServer proxy;
    private final Logger logger;
    private final Path dataDirectory;
    private final OverflowLifeCycle lifeCycle = new OverflowLifeCycle(this);
    private Map<String, Object> config;

    @Inject
    public VelocityPlugin(ProxyServer proxy, Logger logger, @DataDirectory Path dataDirectory) {
        this.proxy = proxy;
        this.logger = logger;
        this.dataDirectory = dataDirectory;
        this.lifeCycle.loadOverflowLibrary();
    }

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        this.logger.info("\u6b63\u5728\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6");
        this.lifeCycle.loadConfig();
        this.logger.info("\u6b63\u5728\u6ce8\u518c\u547d\u4ee4");
        CommandManager manager = this.proxy.getCommandManager();
        CommandMeta overflow = manager.metaBuilder("overflow").build();
        manager.register(overflow, (Command)new SimpleCommand(){

            public void execute(SimpleCommand.Invocation invocation) {
                String[] args = (String[])invocation.arguments();
                CommandSource sender = invocation.source();
                if (args.length > 0) {
                    if (args[0].equalsIgnoreCase("reload")) {
                        VelocityPlugin.this.lifeCycle.loadConfig();
                        sender.sendMessage(Component.text((String)"\u5df2\u91cd\u65b0\u52a0\u8f7dOverflow\u914d\u7f6e\u3002").color((TextColor)NamedTextColor.GREEN));
                    } else if (args[0].equalsIgnoreCase("connect")) {
                        sender.sendMessage(Component.text((String)"\u5c1d\u8bd5\u8fde\u63a5\u5230Onebot\uff0c\u8bf7\u67e5\u770b\u63a7\u5236\u53f0\u4ee5\u4e86\u89e3\u66f4\u591a\u4fe1\u606f\u3002").color((TextColor)NamedTextColor.GREEN));
                        VelocityPlugin.this.lifeCycle.connect();
                    } else {
                        sender.sendMessage(Component.text((String)"\u7528\u6cd5: /overflow <reload|connect>").color((TextColor)NamedTextColor.RED));
                    }
                } else {
                    VelocityPlugin.this.proxy.getPluginManager().getPlugin("miraimcaddon-overflow").ifPresent(plugin -> sender.sendMessage((Component)Component.text((String)("This server is running " + String.valueOf(plugin.getDescription().getName()) + " version " + String.valueOf(plugin.getDescription().getVersion()) + " by " + String.join((CharSequence)", ", plugin.getDescription().getAuthors())))));
                }
            }

            public boolean hasPermission(SimpleCommand.Invocation invocation) {
                return invocation.source().hasPermission("miraimc.command.overflow");
            }
        });
        this.lifeCycle.connect();
    }

    @Subscribe
    public void onProxyShutdown(ProxyShutdownEvent event) {
        this.lifeCycle.disconnect();
    }

    @Override
    public Logger getPluginLogger() {
        return this.logger;
    }

    @Override
    public Path getDataPath() {
        return this.dataDirectory;
    }
}

