/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.item.set;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1320;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_9285;
import net.spell_engine.api.item.set.EquipmentSet;
import net.spell_engine.api.item.set.EquipmentSetRegistry;
import net.spell_engine.api.spell.SpellDataComponents;
import net.spell_engine.client.gui.SpellTooltip;
import net.spell_engine.mixin.client.ItemStackTooltipAccessor;
import org.jetbrains.annotations.Nullable;

public class EquipmentSetTooltip {
    public static void appendLines(class_1799 stack, List<class_2561> tooltip) {
        List<class_2561> text;
        if (stack.method_57824(SpellDataComponents.EQUIPMENT_SET) != null && !(text = EquipmentSetTooltip.textFor(stack, (class_1657)class_310.method_1551().field_1724)).isEmpty()) {
            tooltip.addAll(text);
        }
    }

    public static List<class_2561> textFor(class_1799 stack, @Nullable class_1657 player) {
        ArrayList<class_2561> text = new ArrayList<class_2561>();
        class_2960 component = (class_2960)stack.method_57824(SpellDataComponents.EQUIPMENT_SET);
        if (component == null) {
            return text;
        }
        Optional optionalEntry = EquipmentSetRegistry.from(player.method_37908()).method_55841(component);
        if (optionalEntry.isPresent() && player != null && player.method_37908() != null) {
            class_6880.class_6883 equipmentSetEntry = (class_6880.class_6883)optionalEntry.get();
            EquipmentSet.Definition equipmentSet = (EquipmentSet.Definition)equipmentSetEntry.comp_349();
            int setSize = equipmentSet.items().method_40247();
            List<EquipmentSet.Result> activeSets = ((EquipmentSet.Owner)player).getActiveEquipmentSets();
            List<Object> wornItems = List.of();
            for (EquipmentSet.Result entry : activeSets) {
                if (!((class_5321)entry.set().method_40230().get()).equals(equipmentSetEntry.method_40230().get())) continue;
                wornItems = entry.items();
            }
            text.add((class_2561)class_2561.method_43470((String)" "));
            text.add((class_2561)class_2561.method_43471((String)EquipmentSet.translationKey((class_6880<EquipmentSet.Definition>)equipmentSetEntry)).method_10852((class_2561)class_2561.method_43470((String)(" (" + wornItems.size() + "/" + setSize + ")"))).method_27692(class_124.field_1065));
            for (class_6880 item : equipmentSet.items()) {
                boolean isWorn = wornItems.stream().anyMatch(wornItem -> wornItem.method_31574((class_1792)item.comp_349()));
                text.add((class_2561)class_2561.method_43470((String)" ").method_10852((class_2561)class_2561.method_43471((String)((class_1792)item.comp_349()).method_7876()).method_27692(isWorn ? class_124.field_1080 : class_124.field_1063)));
            }
            for (EquipmentSet.Bonus bonus : equipmentSet.bonuses()) {
                boolean isActive = wornItems.size() >= bonus.requiredPieceCount();
                text.addAll(EquipmentSetTooltip.bonusText(player, stack, bonus, isActive));
            }
        }
        return text;
    }

    public static List<class_2561> bonusText(class_1657 player, class_1799 itemStack, EquipmentSet.Bonus bonus, boolean isActive) {
        class_124 formatting;
        SpellTooltip.SpellInfo spellText;
        class_5250 bonusTitle = class_2561.method_43469((String)"equipment_set.logic.bonus.count", (Object[])new Object[]{bonus.requiredPieceCount()});
        ArrayList<class_2561> bonusLines = new ArrayList<class_2561>();
        if (bonus.attributes() != null) {
            ItemStackTooltipAccessor tooltipUtil = (ItemStackTooltipAccessor)class_1799.field_8037;
            for (class_9285.class_9287 modifier : bonus.attributes().comp_2393()) {
                tooltipUtil.spellEngine_appendAttributeModifierTooltip(bonusLines::add, player, (class_6880<class_1320>)modifier.comp_2395(), modifier.comp_2396());
            }
        }
        if (bonus.spells() != null && (spellText = SpellTooltip.getSpellInfo(itemStack, bonus.spells(), player, true, false)) != null) {
            bonusLines.addAll(spellText.content());
        }
        ArrayList<class_2561> finalLines = new ArrayList<class_2561>();
        class_124 class_1242 = formatting = isActive ? class_124.field_1080 : class_124.field_1063;
        if (bonusLines.size() == 1) {
            class_2561 line = (class_2561)bonusLines.get(0);
            finalLines.add((class_2561)bonusTitle.method_10852((class_2561)(isActive ? line : class_2561.method_43470((String)line.getString()))).method_27692(formatting));
        } else {
            finalLines.add((class_2561)bonusTitle.method_27692(formatting));
            for (class_2561 line : bonusLines) {
                finalLines.add((class_2561)class_2561.method_43470((String)" ").method_10852((class_2561)(isActive ? line : class_2561.method_43470((String)line.getString()))).method_27692(formatting));
            }
        }
        return finalLines;
    }
}

