/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.effect;

import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.spell_engine.api.config.ConfigUtil;
import net.spell_engine.api.config.EffectConfig;

public class Effects {
    public static void register(List<Entry> entries, Map<String, EffectConfig> effects) {
        for (Entry entry : entries) {
            String key = entry.id.toString();
            EffectConfig current = effects.get(key);
            if (current != null) {
                entry.config = current;
            } else {
                effects.put(key, entry.config);
            }
            List<ConfigUtil.Entry> modifiers = ConfigUtil.modifiersFrom(entry.id, entry.config.attributes());
            for (ConfigUtil.Entry modifier : modifiers) {
                entry.effect.addAttributeModifier(modifier.attribute(), modifier.modifier().id(), modifier.modifier().amount(), modifier.modifier().operation());
            }
        }
        for (Entry entry : entries) {
            entry.entry = Registry.registerForHolder((Registry)BuiltInRegistries.MOB_EFFECT, (ResourceLocation)entry.id, (Object)entry.effect);
        }
    }

    public static final class Entry {
        public final ResourceLocation id;
        public final String title;
        public final String description;
        public final MobEffect effect;
        public final EffectConfig defaults;
        public EffectConfig config;
        public Holder<MobEffect> entry;

        public Entry(ResourceLocation id, String title, String description, MobEffect effect) {
            this(id, title, description, effect, EffectConfig.EMPTY);
        }

        public Entry(ResourceLocation id, String title, String description, MobEffect effect, EffectConfig config) {
            this.id = id;
            this.title = title;
            this.description = description;
            this.effect = effect;
            this.defaults = config;
            this.config = config;
        }

        public EffectConfig config() {
            return this.config;
        }
    }
}

