/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.effect;

import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.level.Level;
import net.spell_engine.entity.DamageSourceExtension;
import org.jetbrains.annotations.Nullable;

public interface RemoveOnHit {
    @Nullable
    public Args getRemovalOnHit();

    public MobEffect setRemovalOnHit(Args var1);

    @Deprecated
    public static void configure(MobEffect effect, boolean removeOnHit) {
        RemoveOnHit.configure(effect, Trigger.ANY_HIT);
    }

    public static void configure(MobEffect effect, Trigger condition) {
        RemoveOnHit.configure(effect, condition, 1.0f);
    }

    public static void configure(MobEffect effect, Trigger condition, float chance) {
        ((RemoveOnHit)effect).setRemovalOnHit(new Args(condition, 1, chance));
    }

    public static void configure(MobEffect effect, Trigger condition, int count, float chance) {
        ((RemoveOnHit)effect).setRemovalOnHit(new Args(condition, count, chance));
    }

    public static boolean shouldRemoveOnHit(Level world, MobEffect effect, DamageSource damageSource) {
        Args args = ((RemoveOnHit)effect).getRemovalOnHit();
        if (args == null) {
            return false;
        }
        if (args.chance < 1.0f && world.random.nextFloat() > args.chance) {
            return false;
        }
        boolean isInDirect = !damageSource.isDirect() || ((DamageSourceExtension)damageSource).isSpellIndirect();
        return switch (args.trigger.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> true;
            case 1 -> {
                if (!isInDirect) {
                    yield true;
                }
                yield false;
            }
            case 2 -> isInDirect;
        };
    }

    public static int removeCount(Level world, MobEffect effect, DamageSource damageSource) {
        Args args = ((RemoveOnHit)effect).getRemovalOnHit();
        return RemoveOnHit.shouldRemoveOnHit(world, effect, damageSource) ? (args.count > 0 ? args.count : -1) : 0;
    }

    public static enum Trigger {
        ANY_HIT,
        DIRECT_HIT,
        INDIRECT_HIT;

    }

    public record Args(Trigger trigger, int count, float chance) {
    }
}

