/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.item.armor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.ItemLike;
import net.spell_engine.api.config.ArmorSetConfig;
import net.spell_engine.api.item.Equipment;
import net.spell_engine.api.item.armor.ConfigurableAttributes;
import net.spell_engine.mixin.item.ArmorMaterialLayerAccessor;
import org.jetbrains.annotations.Nullable;

public class Armor {
    public static void register(Map<String, ArmorSetConfig> configs, List<Entry> entries, ResourceKey<CreativeModeTab> itemGroupKey) {
        for (Entry entry : entries) {
            ArmorSetConfig config = configs.get(entry.name());
            if (config == null) {
                config = entry.defaults();
                configs.put(entry.name(), config);
            }
            for (Object piece : entry.armorSet().pieces()) {
                EquipmentSlot slot = ((ArmorItem)piece).getEquipmentSlot();
                ((ConfigurableAttributes)piece).setAttributes(Armor.attributesFrom(config, ((ArmorItem)piece).getType()));
            }
            entry.armorSet().register(itemGroupKey);
        }
    }

    private static ItemAttributeModifiers attributesFrom(ArmorSetConfig config, ArmorItem.Type slot) {
        ArmorSetConfig.Piece piece = null;
        ResourceLocation modifierId = ResourceLocation.withDefaultNamespace((String)("armor." + slot.getName()));
        switch (slot) {
            case BOOTS: {
                piece = config.feet;
                break;
            }
            case LEGGINGS: {
                piece = config.legs;
                break;
            }
            case CHESTPLATE: {
                piece = config.chest;
                break;
            }
            case HELMET: {
                piece = config.head;
            }
        }
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
        EquipmentSlotGroup attributeModifierSlot = EquipmentSlotGroup.bySlot((EquipmentSlot)slot.getSlot());
        if (config.armor_toughness != 0.0f) {
            builder.add(Attributes.ARMOR_TOUGHNESS, new AttributeModifier(modifierId, (double)config.armor_toughness, AttributeModifier.Operation.ADD_VALUE), attributeModifierSlot);
        }
        if (config.knockback_resistance != 0.0f) {
            builder.add(Attributes.KNOCKBACK_RESISTANCE, new AttributeModifier(modifierId, (double)config.knockback_resistance, AttributeModifier.Operation.ADD_VALUE), attributeModifierSlot);
        }
        if (piece.armor != 0) {
            builder.add(Attributes.ARMOR, new AttributeModifier(modifierId, (double)piece.armor, AttributeModifier.Operation.ADD_VALUE), attributeModifierSlot);
        }
        for (net.spell_engine.api.config.AttributeModifier attribute : piece.selectedAttributes()) {
            try {
                Holder.Reference entityAttribute = (Holder.Reference)BuiltInRegistries.ATTRIBUTE.getHolder(ResourceLocation.parse((String)attribute.attribute)).get();
                builder.add((Holder)entityAttribute, new AttributeModifier(modifierId, (double)attribute.value, attribute.operation), attributeModifierSlot);
            }
            catch (Exception e) {
                System.err.println("Failed to add item attribute modifier: " + e.getMessage());
            }
        }
        return builder.build();
    }

    public record Entry(Holder<ArmorMaterial> material, Set armorSet, ArmorSetConfig defaults, Equipment.LootProperties lootProperties) {
        public static Entry create(Holder<ArmorMaterial> material, ResourceLocation id, int durability, Set.ItemFactory factory, ArmorSetConfig defaults) {
            return Entry.create(material, id, durability, factory, defaults, Equipment.LootProperties.EMPTY);
        }

        public static Entry create(Holder<ArmorMaterial> material, ResourceLocation id, int durability, Set.ItemFactory factory, ArmorSetConfig defaults, Equipment.LootProperties lootProperties) {
            return Entry.create(material, id, durability, factory, defaults, lootProperties, null);
        }

        public static Entry create(Holder<ArmorMaterial> material, ResourceLocation id, int durability, Set.ItemFactory factory, ArmorSetConfig defaults, Equipment.LootProperties lootProperties, @Nullable ItemSettingsTweaker settingsTweaker) {
            int tier;
            Item.Properties helmetSettings = new Item.Properties().durability(ArmorItem.Type.HELMET.getDurability(durability));
            Item.Properties chestplateSettings = new Item.Properties().durability(ArmorItem.Type.CHESTPLATE.getDurability(durability));
            Item.Properties leggingsSettings = new Item.Properties().durability(ArmorItem.Type.LEGGINGS.getDurability(durability));
            Item.Properties bootsSettings = new Item.Properties().durability(ArmorItem.Type.BOOTS.getDurability(durability));
            if (settingsTweaker != null) {
                settingsTweaker.helmet.accept(helmetSettings);
                settingsTweaker.chestplate.accept(chestplateSettings);
                settingsTweaker.leggings.accept(leggingsSettings);
                settingsTweaker.boots.accept(bootsSettings);
            }
            if ((tier = lootProperties.tier()) >= 3) {
                helmetSettings.fireResistant();
                chestplateSettings.fireResistant();
                leggingsSettings.fireResistant();
                bootsSettings.fireResistant();
            }
            Set set = new Set(id.getNamespace(), id.getPath(), factory.create(material, ArmorItem.Type.HELMET, helmetSettings), factory.create(material, ArmorItem.Type.CHESTPLATE, chestplateSettings), factory.create(material, ArmorItem.Type.LEGGINGS, leggingsSettings), factory.create(material, ArmorItem.Type.BOOTS, bootsSettings));
            return new Entry(material, set, defaults, lootProperties);
        }

        public Entry translatedName(String headName, String chestName, String legsName, String feetName) {
            this.armorSet.translate(headName, chestName, legsName, feetName);
            return this;
        }

        public String name() {
            return this.armorSet.name;
        }

        public <T extends ArmorItem> Entry bundle(Function<Holder<ArmorMaterial>, Set<T>> factory) {
            Set<T> armorSet = factory.apply(this.material);
            return new Entry(this.material, armorSet, this.defaults, this.lootProperties);
        }

        public <T extends ArmorItem> Entry put(ArrayList<Entry> list) {
            list.add(this);
            return this;
        }
    }

    public static class Set<A extends ArmorItem> {
        public final String namespace;
        public final String name;
        public final A head;
        public final A chest;
        public final A legs;
        public final A feet;
        public String headTranslation;
        public String chestTranslation;
        public String legsTranslation;
        public String feetTranslation = "";

        public Set(String namespace, String name, A head, A chest, A legs, A feet) {
            this.namespace = namespace;
            this.name = name;
            this.head = head;
            this.chest = chest;
            this.legs = legs;
            this.feet = feet;
        }

        public List<A> pieces() {
            return Stream.of(this.head, this.chest, this.legs, this.feet).filter(Objects::nonNull).collect(Collectors.toList());
        }

        public ResourceLocation idOf(ArmorItem piece) {
            String name = this.name + "_" + piece.getEquipmentSlot().getName();
            return ResourceLocation.fromNamespaceAndPath((String)this.namespace, (String)name);
        }

        public List<String> idStrings() {
            return this.pieces().stream().map(piece -> this.idOf((ArmorItem)piece).toString()).toList();
        }

        public List<ResourceLocation> pieceIds() {
            return this.pieces().stream().map(this::idOf).toList();
        }

        public Set<A> translate(String headName, String chestName, String legsName, String feetName) {
            this.headTranslation = headName;
            this.chestTranslation = chestName;
            this.legsTranslation = legsName;
            this.feetTranslation = feetName;
            return this;
        }

        public void register(ResourceKey<CreativeModeTab> itemGroupKey) {
            for (ArmorItem piece : this.pieces()) {
                Registry.register((Registry)BuiltInRegistries.ITEM, (ResourceLocation)this.idOf(piece), (Object)piece);
            }
            ItemGroupEvents.modifyEntriesEvent(itemGroupKey).register(content -> {
                for (ArmorItem piece : this.pieces()) {
                    content.accept((ItemLike)piece);
                }
            });
        }

        public static interface ItemFactory<T extends ArmorItem> {
            public T create(Holder<ArmorMaterial> var1, ArmorItem.Type var2, Item.Properties var3);
        }
    }

    public record ItemSettingsTweaker(Consumer<Item.Properties> helmet, Consumer<Item.Properties> chestplate, Consumer<Item.Properties> leggings, Consumer<Item.Properties> boots) {
        public static ItemSettingsTweaker standard(Consumer<Item.Properties> consumer) {
            return new ItemSettingsTweaker(consumer, consumer, consumer, consumer);
        }
    }

    public static class CustomItem
    extends ArmorItem
    implements ConfigurableAttributes {
        private ItemAttributeModifiers attributeModifiers = ItemAttributeModifiers.builder().build();
        public final Holder<ArmorMaterial> customMaterial;

        public CustomItem(Holder<ArmorMaterial> material, ArmorItem.Type slot, Item.Properties settings) {
            super(material, slot, settings);
            this.customMaterial = material;
        }

        @Override
        public void setAttributes(ItemAttributeModifiers attributeModifiers) {
            this.attributeModifiers = attributeModifiers;
        }

        public ItemAttributeModifiers getDefaultAttributeModifiers() {
            return this.attributeModifiers;
        }

        public ResourceLocation getFirstLayerId() {
            ArmorMaterial.Layer fristLayer = (ArmorMaterial.Layer)((ArmorMaterial)this.customMaterial.value()).layers().getFirst();
            return ((ArmorMaterialLayerAccessor)fristLayer).spellEngine_getId();
        }
    }
}

