/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.render;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.spell_engine.api.effect.CustomParticleStatusEffect;

public class StunParticleSpawner
implements CustomParticleStatusEffect.Spawner {
    private final ParticleOptions particleEffect;

    public StunParticleSpawner() {
        this.particleEffect = ParticleTypes.CRIT;
    }

    public StunParticleSpawner(ResourceLocation particleId) {
        ParticleOptions particleType = (ParticleOptions)BuiltInRegistries.PARTICLE_TYPE.get(particleId);
        if (particleType == null) {
            throw new IllegalArgumentException("Particle type not found: " + String.valueOf(particleId));
        }
        this.particleEffect = particleType;
    }

    @Override
    public void spawnParticles(LivingEntity livingEntity, int amplifier) {
        Level world = livingEntity.level();
        if (world.isClientSide && world instanceof ClientLevel) {
            ClientLevel clientWorld = (ClientLevel)world;
            int time = livingEntity.tickCount;
            double angle = Math.toRadians((float)(time % 360) * 18.0f);
            Vec3 rotated = new Vec3(0.0, 0.0, (double)(livingEntity.getBbWidth() * 0.5f)).yRot((float)angle);
            Vec3 spawnPosition = livingEntity.position().add(0.0, (double)(livingEntity.getBbHeight() * 1.2f), 0.0).add(rotated);
            clientWorld.addParticle(this.particleEffect, true, spawnPosition.x, spawnPosition.y, spawnPosition.z, 0.0, 0.0, 0.0);
        }
    }
}

