/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.client;

import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.ConfigSerializer;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import me.shedaniel.autoconfig.serializer.PartitioningSerializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.spell_engine.api.effect.CustomParticleStatusEffect;
import net.spell_engine.api.effect.SpellEngineEffects;
import net.spell_engine.api.item.set.EquipmentSetTooltip;
import net.spell_engine.api.render.StunParticleSpawner;
import net.spell_engine.client.ClientNetwork;
import net.spell_engine.client.compatibility.CompatFeatures;
import net.spell_engine.client.gui.SpellTooltip;
import net.spell_engine.client.particle.ShiftedParticle;
import net.spell_engine.client.particle.SpellAreaParticle;
import net.spell_engine.client.particle.SpellExplosionParticle;
import net.spell_engine.client.particle.SpellFlameParticle;
import net.spell_engine.client.particle.SpellSmokeParticle;
import net.spell_engine.client.particle.SpellSnowflakeParticle;
import net.spell_engine.client.particle.SpellUniversalParticle;
import net.spell_engine.client.particle.UniversalSpellParticle;
import net.spell_engine.client.render.BeamRenderer;
import net.spell_engine.client.render.ModelPredicateHelper;
import net.spell_engine.client.render.SpellBindingBlockEntityRenderer;
import net.spell_engine.client.render.SpellCloudRenderer;
import net.spell_engine.client.render.SpellProjectileRenderer;
import net.spell_engine.config.ClientConfig;
import net.spell_engine.config.ClientConfigWrapper;
import net.spell_engine.config.HudConfig;
import net.spell_engine.entity.SpellCloud;
import net.spell_engine.entity.SpellProjectile;
import net.spell_engine.fx.SpellEngineParticles;
import net.spell_engine.spellbinding.SpellBindingBlockEntity;
import net.spell_engine.spellbinding.SpellBindingScreen;
import net.spell_engine.spellbinding.SpellBindingScreenHandler;
import net.tiny_config.ConfigManager;

public class SpellEngineClient {
    public static ClientConfig config;
    public static ConfigManager<HudConfig> hudConfig;

    public static void init() {
        AutoConfig.register(ClientConfigWrapper.class, (ConfigSerializer.Factory)PartitioningSerializer.wrap(JanksonConfigSerializer::new));
        config = ((ClientConfigWrapper)AutoConfig.getConfigHolder(ClientConfigWrapper.class).getConfig()).client;
        hudConfig.refresh();
        ClientNetwork.initializeHandlers();
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> SpellEngineClient.injectRangedWeaponModelPredicates());
        MenuScreens.register(SpellBindingScreenHandler.HANDLER_TYPE, SpellBindingScreen::new);
        BlockEntityRenderers.register(SpellBindingBlockEntity.ENTITY_TYPE, SpellBindingBlockEntityRenderer::new);
        CompatFeatures.initialize();
        BeamRenderer.setup();
        SpellEngineClient.registerEffectParticles();
        ItemTooltipCallback.EVENT.register((itemStack, tooltipContext, tooltipType, lines) -> {
            SpellTooltip.addSpellLines(itemStack, tooltipType, lines);
            EquipmentSetTooltip.appendLines(itemStack, lines);
        });
        EntityRendererRegistry.register(SpellProjectile.ENTITY_TYPE, SpellProjectileRenderer::new);
        EntityRendererRegistry.register(SpellCloud.ENTITY_TYPE, SpellCloudRenderer::new);
    }

    private static void injectRangedWeaponModelPredicates() {
        for (ResourceLocation itemId : BuiltInRegistries.ITEM.keySet()) {
            Item item = (Item)BuiltInRegistries.ITEM.get(itemId);
            if (item instanceof BowItem) {
                ModelPredicateHelper.injectBowSkillUsePredicate(item);
                continue;
            }
            if (!(item instanceof CrossbowItem)) continue;
            ModelPredicateHelper.injectCrossBowSkillUsePredicate(item);
        }
    }

    private static void registerEffectParticles() {
        CustomParticleStatusEffect.register(SpellEngineEffects.STUN.effect, new StunParticleSpawner());
    }

    public static void registerParticleAppearances() {
        ParticleFactoryRegistry.getInstance().register((ParticleType)SpellEngineParticles.flame.particleType(), SpellFlameParticle.FlameFactory::new);
        ParticleFactoryRegistry.getInstance().register((ParticleType)SpellEngineParticles.flame_spark.particleType(), SpellFlameParticle.AnimatedFlameFactory::new);
        ParticleFactoryRegistry.getInstance().register((ParticleType)SpellEngineParticles.flame_ground.particleType(), SpellFlameParticle.AnimatedFlameFactory::new);
        ParticleFactoryRegistry.getInstance().register((ParticleType)SpellEngineParticles.flame_medium_a.particleType(), SpellFlameParticle.MediumFlameFactory::new);
        ParticleFactoryRegistry.getInstance().register((ParticleType)SpellEngineParticles.flame_medium_b.particleType(), SpellFlameParticle.MediumFlameFactory::new);
        ParticleFactoryRegistry.getInstance().register((ParticleType)SpellEngineParticles.snowflake.particleType(), SpellSnowflakeParticle.FrostFactory::new);
        ParticleFactoryRegistry.getInstance().register((ParticleType)SpellEngineParticles.frost_shard.particleType(), SpellFlameParticle.FrostShard::new);
        ParticleFactoryRegistry.getInstance().register((ParticleType)SpellEngineParticles.electric_arc_A.particleType(), SpellFlameParticle.ElectricSparkFactory::new);
        ParticleFactoryRegistry.getInstance().register((ParticleType)SpellEngineParticles.electric_arc_B.particleType(), SpellFlameParticle.ElectricSparkFactory::new);
        ParticleFactoryRegistry.getInstance().register((ParticleType)SpellEngineParticles.smoke_medium.particleType(), SpellFlameParticle.SmokeFactory::new);
        ParticleFactoryRegistry.getInstance().register((ParticleType)SpellEngineParticles.weakness_smoke.particleType(), SpellFlameParticle.WeaknessSmokeFactory::new);
        ParticleFactoryRegistry.getInstance().register((ParticleType)SpellEngineParticles.shield_small.particleType(), provider -> new UniversalSpellParticle.Opaque((SpriteSet)provider, SpellEngineParticles.MagicParticleFamily.Motion.DECELERATE));
        ParticleFactoryRegistry.getInstance().register((ParticleType)SpellEngineParticles.dripping_blood.particleType(), SpellSnowflakeParticle.DrippingBloodFactory::new);
        ParticleFactoryRegistry.getInstance().register((ParticleType)SpellEngineParticles.roots.particleType(), ShiftedParticle.RootsFactory::new);
        ParticleFactoryRegistry.getInstance().register((ParticleType)SpellEngineParticles.fire_explosion.particleType(), SpellExplosionParticle.TemplateFactory::new);
        ParticleFactoryRegistry.getInstance().register((ParticleType)SpellEngineParticles.smoke_large.particleType(), SpellSmokeParticle.CosySmokeFactory::new);
        for (SpellEngineParticles.TemplateEntry entry : SpellEngineParticles.areaEffects()) {
            ParticleFactoryRegistry.getInstance().register((ParticleType)entry.particleType(), provider -> new SpellAreaParticle.Factory((SpriteSet)provider, entry.texture(), entry.fading(), entry.orientation()));
        }
        for (SpellEngineParticles.TemplateEntry entry : SpellEngineParticles.signEffects()) {
            ParticleFactoryRegistry.getInstance().register((ParticleType)entry.particleType(), provider -> new SpellFlameParticle.SignFactory((SpriteSet)provider, entry.texture()));
        }
        for (SpellEngineParticles.MagicParticles.Variant variant : SpellEngineParticles.MagicParticles.all) {
            ParticleFactoryRegistry.getInstance().register((ParticleType)variant.entry().particleType(), provider -> new SpellUniversalParticle.MagicVariant((SpriteSet)provider, variant));
        }
    }

    static {
        hudConfig = new ConfigManager("hud_config", (Object)HudConfig.createDefault()).builder().setDirectory("spell_engine").sanitize(true).validate(HudConfig::isValid).build();
    }
}

