/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.client.gui;

import com.ibm.icu.text.DecimalFormat;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.mixin.client.keybinding.KeyBindingAccessor;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.spell_engine.SpellEngineMod;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.container.SpellContainer;
import net.spell_engine.api.spell.container.SpellContainerHelper;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.api.tags.SpellEngineItemTags;
import net.spell_engine.client.SpellEngineClient;
import net.spell_engine.client.input.Keybindings;
import net.spell_engine.config.ClientConfig;
import net.spell_engine.config.ServerConfig;
import net.spell_engine.internals.Ammo;
import net.spell_engine.internals.SpellHelper;
import net.spell_power.api.SpellPower;
import net.spell_power.api.SpellSchool;
import org.jetbrains.annotations.NotNull;

public class SpellTooltip {
    public static final String damageToken = "damage";
    public static final String healToken = "heal";
    public static final String rangeToken = "range";
    public static final String durationToken = "duration";
    public static final String itemToken = "item";
    public static final String effectDurationToken = "effect_duration";
    public static final String effectAmplifierToken = "effect_amplifier";
    public static final String effectAmplifierCapToken = "effect_amplifier_cap";
    public static final String impactRangeToken = "impact_range";
    public static final String teleportDistanceToken = "teleport_distance";
    public static final String countToken = "count";
    public static final String impact_chance = "impact_chance";
    public static final String trigger_chance = "trigger_chance";
    public static final String trigger_list = "trigger_list";
    public static final String additional_placement_count = "additional_placement_count";
    private static final Map<ResourceLocation, DescriptionMutator> descriptionMutators = new HashMap<ResourceLocation, DescriptionMutator>();

    public static String placeholder(String token) {
        return "{" + token + "}";
    }

    public static void addSpellLines(ItemStack itemStack, TooltipFlag tooltipType, List<Component> lines) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        int addSectionDivider = 0;
        ClientConfig config = SpellEngineClient.config;
        ArrayList<Object> spellTextLines = new ArrayList<Object>();
        SpellContainer container = SpellContainerHelper.containerFromItemStack(itemStack);
        if (container != null && container.isValid()) {
            if (container.is_proxy() && config.showSpellBookSuppportTooltip) {
                switch (container.content()) {
                    case MAGIC: {
                        spellTextLines.add(Component.translatable((String)"spell.tooltip.host.proxy.spell").withStyle(ChatFormatting.GRAY));
                        break;
                    }
                    case ARCHERY: {
                        spellTextLines.add(Component.translatable((String)"spell.tooltip.host.proxy.archery").withStyle(ChatFormatting.GRAY));
                    }
                }
                ++addSectionDivider;
            }
            SpellInfo spellInfo = SpellTooltip.getSpellInfo(itemStack, container, (Player)player, false, true);
            spellTextLines.addAll(spellInfo.content());
            addSectionDivider += spellInfo.sectionDividersAdded();
            if (!spellInfo.showDetails() && config.showSpellBindingTooltip && container.pool() != null && !container.pool().isEmpty() && container.spell_ids().isEmpty()) {
                spellTextLines.add(Component.translatable((String)"spell.tooltip.spell_binding_tip").withStyle(ChatFormatting.GRAY));
            }
        }
        if (spellTextLines.isEmpty()) {
            return;
        }
        int found = 0;
        if (tooltipType.isAdvanced()) {
            Style searchedStyle = Component.literal((String)"x").withStyle(ChatFormatting.DARK_GRAY).getStyle();
            int reverseIndex = lines.size();
            for (Component line : lines.reversed()) {
                --reverseIndex;
                Style style = line.getStyle();
                if (style == null) continue;
                boolean newFind = searchedStyle.getColor().equals((Object)style.getColor());
                if (found != 0 && !newFind) break;
                found = reverseIndex;
            }
        }
        if (found <= 0) {
            if (addSectionDivider > 0) {
                spellTextLines.addFirst(Component.literal((String)""));
            }
            lines.addAll(spellTextLines);
        } else {
            if (addSectionDivider > 0) {
                boolean hasPreceedignEmptyLine = false;
                if (found > 0) {
                    String previousLine = lines.get(found - 1).getString();
                    hasPreceedignEmptyLine = previousLine.isBlank();
                }
                if (!hasPreceedignEmptyLine) {
                    spellTextLines.addFirst(Component.literal((String)""));
                }
            }
            lines.addAll(found, spellTextLines);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static SpellInfo getSpellInfo(ItemStack itemStack, SpellContainer container, Player player, boolean forceHideHeader, boolean allowDetailsHint) {
        int indentLevel;
        ClientConfig config = SpellEngineClient.config;
        List<Object> spells = List.of();
        ClientLevel world = Minecraft.getInstance().level;
        ArrayList<Component> spellTextLines = new ArrayList<Component>();
        int addSectionDivider = 0;
        if (world != null) {
            spells = container.spell_ids().stream().map(idString -> {
                ResourceLocation spellId = ResourceLocation.parse((String)idString);
                Optional optionalSpellEntry = SpellRegistry.from((Level)world).getHolder(spellId);
                if (optionalSpellEntry.isPresent()) {
                    return (Holder)optionalSpellEntry.get();
                }
                return null;
            }).filter(Objects::nonNull).toList();
        }
        forceHideHeader = forceHideHeader || itemStack.is(SpellEngineItemTags.SPELL_BOOK_MERGEABLE);
        boolean showListHeader = false;
        if (!forceHideHeader) {
            for (Holder holder : spells) {
                Spell spell = (Spell)holder.value();
                Spell.Tooltip tooltip = spell.tooltip();
                showListHeader = showListHeader || tooltip.show_header;
            }
        }
        int n = indentLevel = showListHeader ? 1 : 0;
        if (!spells.isEmpty() && showListHeader) {
            void var12_16;
            String string = "";
            if (container.max_spell_count() > 0) {
                String string2 = I18n.get((String)"spell.tooltip.host.limit", (Object[])new Object[0]).replace(SpellTooltip.placeholder("current"), "" + container.spell_ids().size()).replace(SpellTooltip.placeholder("max"), "" + container.max_spell_count());
            }
            String key = "spell.tooltip.host.list.spell";
            switch (container.content()) {
                case MAGIC: {
                    key = "spell.tooltip.host.list.spell";
                    break;
                }
                case ARCHERY: {
                    key = "spell.tooltip.host.list.archery";
                }
            }
            spellTextLines.add((Component)Component.translatable((String)key).append((Component)Component.literal((String)(" " + (String)var12_16))).withStyle(ChatFormatting.GRAY));
            ++addSectionDivider;
        }
        KeyMapping keyMapping = Keybindings.bypass_spell_hotbar;
        boolean showDetails = config.alwaysShowFullTooltip || !keyMapping.isUnbound() && InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)((KeyBindingAccessor)keyMapping).fabric_getBoundKey().getValue());
        for (int i = 0; i < spells.size(); ++i) {
            Holder spellEntry = (Holder)spells.get(i);
            List<Component> info = SpellTooltip.spellEntry((Holder<Spell>)spellEntry, player, itemStack, showDetails, indentLevel);
            if (info.isEmpty()) continue;
            if (i > 0 && showDetails) {
                spellTextLines.add((Component)Component.literal((String)" "));
            }
            spellTextLines.addAll(info);
        }
        if (allowDetailsHint && !showDetails && !keyMapping.isUnbound() && container.spell_ids().size() > 0) {
            spellTextLines.add((Component)Component.translatable((String)"spell.tooltip.hold_for_details", (Object[])new Object[]{keyMapping.getTranslatedKeyMessage()}).withStyle(ChatFormatting.DARK_GRAY));
        }
        return new SpellInfo(spellTextLines, addSectionDivider, showDetails);
    }

    public static List<Component> spellEntry(ResourceLocation spellId, Player player, ItemStack itemStack, boolean details, int indentLevel) {
        Level world = player.level();
        if (world == null) {
            return List.of();
        }
        Optional optionalSpellEntry = SpellRegistry.from(world).getHolder(spellId);
        if (optionalSpellEntry.isEmpty()) {
            return List.of();
        }
        return SpellTooltip.spellEntry((Holder<Spell>)((Holder)optionalSpellEntry.get()), player, itemStack, details, indentLevel);
    }

    public static List<Component> spellEntry(Holder<Spell> spellEntry, Player player, ItemStack itemStack, boolean details, int indentLevel) {
        Spell.Tooltip tooltipData;
        ArrayList<Component> lines = new ArrayList<Component>();
        Spell spell = (Spell)spellEntry.value();
        ResourceLocation spellId = ((ResourceKey)spellEntry.unwrapKey().get()).location();
        Spell.Tooltip tooltip = tooltipData = spell.tooltip != null ? spell.tooltip : Spell.Tooltip.DEFAULT;
        if (SpellTooltip.shouldShow(tooltipData.name, details)) {
            String translatedGroup;
            ChatFormatting color = ChatFormatting.getByName((String)tooltipData.name.color);
            MutableComponent name = Component.empty().withStyle(ChatFormatting.BOLD);
            name.append((Component)Component.translatable((String)SpellTooltip.spellTranslationKey(spellId)).withStyle(ChatFormatting.BOLD));
            if (spell.type == Spell.Type.PASSIVE) {
                name.append((Component)Component.literal((String)" ")).withStyle(ChatFormatting.RESET);
                name.append((Component)Component.translatable((String)"spell.type.passive"));
            }
            if (spell.group != null && !(translatedGroup = SpellTooltip.spellGroup(spell.group)).isEmpty()) {
                name.append((Component)Component.literal((String)" ")).withStyle(ChatFormatting.RESET);
                name.append((Component)Component.literal((String)translatedGroup)).withStyle(color);
            }
            name = name.withStyle(color);
            lines.add((Component)SpellTooltip.indentation(indentLevel).append((Component)name));
            ++indentLevel;
        }
        SpellTooltip.addSpellDescription(spellEntry, player, itemStack, details, indentLevel, lines);
        if (details) {
            SpellTooltip.addSpellDetails(spellEntry, player, itemStack, indentLevel, lines);
        }
        return lines;
    }

    private static void addSpellDescription(Holder<Spell> spellEntry, Player player, ItemStack itemStack, boolean details, int indentLevel, ArrayList<Component> lines) {
        Spell.Tooltip tooltipData;
        Spell spell = (Spell)spellEntry.value();
        Spell.Tooltip tooltip = tooltipData = spell.tooltip != null ? spell.tooltip : Spell.Tooltip.DEFAULT;
        if (SpellTooltip.shouldShow(tooltipData.description, details)) {
            SpellPower.Result primaryPower = SpellPower.getSpellPower((SpellSchool)spell.school, (LivingEntity)player);
            ChatFormatting color = ChatFormatting.getByName((String)tooltipData.description.color);
            String description = SpellTooltip.createDescription(spellEntry, player, itemStack, spell, primaryPower);
            lines.add((Component)SpellTooltip.indentation(indentLevel).append((Component)Component.translatable((String)description)).withStyle(color));
        }
    }

    public static List<Component> spellDescriptionWithDetails(ResourceLocation spellId, Player player, ItemStack itemStack, int indentLevel) {
        Level world = player.level();
        if (world == null) {
            return List.of();
        }
        Optional optionalSpellEntry = SpellRegistry.from(world).getHolder(spellId);
        if (optionalSpellEntry.isEmpty()) {
            return List.of();
        }
        ArrayList<Component> lines = new ArrayList<Component>();
        Holder.Reference spellEntry = (Holder.Reference)optionalSpellEntry.get();
        SpellTooltip.addSpellDescription((Holder<Spell>)spellEntry, player, itemStack, true, indentLevel, lines);
        SpellTooltip.addSpellDetails((Holder<Spell>)spellEntry, player, itemStack, indentLevel, lines);
        return lines;
    }

    private static void addSpellDetails(Holder<Spell> spellEntry, Player player, ItemStack itemStack, int indentLevel, ArrayList<Component> lines) {
        Ammo.Result ammoResult;
        float cooldownDuration;
        Spell spell = (Spell)spellEntry.value();
        Spell.Active active = spell.active;
        if (spell.tooltip().show_activation) {
            Spell.Passive passive;
            if (active != null && active.cast != null) {
                if (SpellHelper.isInstant(spell)) {
                    lines.add((Component)SpellTooltip.indentation(indentLevel).append((Component)Component.translatable((String)"spell.tooltip.cast_instant")).withStyle(ChatFormatting.GOLD));
                } else {
                    float castDuration = SpellHelper.getCastDuration((LivingEntity)player, spell, itemStack);
                    String castTimeKey = SpellTooltip.keyWithPlural("spell.tooltip.cast_time", castDuration);
                    String castTime = I18n.get((String)castTimeKey, (Object[])new Object[0]).replace(SpellTooltip.placeholder(durationToken), SpellTooltip.formattedNumber(castDuration));
                    lines.add((Component)SpellTooltip.indentation(indentLevel).append((Component)Component.literal((String)castTime)).withStyle(ChatFormatting.GOLD));
                }
            }
            if ((passive = spell.passive) != null && !passive.triggers.isEmpty()) {
                List<String> triggerList = passive.triggers.stream().map(trigger -> "spell.tooltip.trigger." + trigger.type.toString().toLowerCase(Locale.ENGLISH)).map(x$0 -> I18n.get((String)x$0, (Object[])new Object[0])).toList();
                String joinedTriggers = String.join((CharSequence)", ", triggerList);
                String triggerText = I18n.get((String)"spell.tooltip.trigger.base", (Object[])new Object[0]).replace(SpellTooltip.placeholder(trigger_list), joinedTriggers);
                lines.add((Component)SpellTooltip.indentation(indentLevel).append((Component)Component.literal((String)triggerText)).withStyle(ChatFormatting.GOLD));
            }
        }
        if (spell.tooltip().show_range && (spell.range > 0.0f || spell.range_mechanic != null)) {
            String rangeText = "";
            if (spell.range_mechanic != null) {
                switch (spell.range_mechanic) {
                    case MELEE: {
                        if (spell.range == 0.0f) {
                            rangeText = I18n.get((String)"spell.tooltip.range.melee", (Object[])new Object[0]);
                            break;
                        }
                        String key = spell.range > 0.0f ? "spell.tooltip.range.melee.plus" : "spell.tooltip.range.melee.minus";
                        String rangeKey = SpellTooltip.keyWithPlural(key, spell.range);
                        rangeText = I18n.get((String)rangeKey, (Object[])new Object[0]).replace(SpellTooltip.placeholder(rangeToken), SpellTooltip.formattedNumber(Math.abs(spell.range)));
                    }
                }
            } else {
                String rangeKey = SpellTooltip.keyWithPlural("spell.tooltip.range", spell.range);
                rangeText = I18n.get((String)rangeKey, (Object[])new Object[0]).replace(SpellTooltip.placeholder(rangeToken), SpellTooltip.formattedNumber(spell.range));
            }
            lines.add((Component)SpellTooltip.indentation(indentLevel).append((Component)Component.literal((String)rangeText)).withStyle(ChatFormatting.GOLD));
        }
        if ((cooldownDuration = SpellHelper.getCooldownDuration((LivingEntity)player, spellEntry, itemStack)) > 0.0f) {
            String cooldown;
            if (spell.cost.cooldown.proportional) {
                cooldown = I18n.get((String)"spell.tooltip.cooldown.proportional", (Object[])new Object[0]);
            } else {
                String cooldownKey = SpellTooltip.keyWithPlural("spell.tooltip.cooldown", cooldownDuration);
                cooldown = I18n.get((String)cooldownKey, (Object[])new Object[0]).replace(SpellTooltip.placeholder(durationToken), SpellTooltip.formattedNumber(cooldownDuration));
            }
            lines.add((Component)SpellTooltip.indentation(indentLevel).append((Component)Component.literal((String)cooldown)).withStyle(ChatFormatting.GOLD));
        }
        boolean showItemCost = true;
        ServerConfig config = SpellEngineMod.config;
        if (config != null) {
            showItemCost = config.spell_cost_item_allowed;
        }
        if (showItemCost && (ammoResult = Ammo.ammoForSpell(player, spell, itemStack)).item() != null) {
            int amount = spell.cost.item.amount;
            String ammoKey = SpellTooltip.keyWithPlural("spell.tooltip.ammo", amount);
            String itemName = I18n.get((String)ammoResult.item().getTranslationKey(), (Object[])new Object[0]);
            String ammo = I18n.get((String)ammoKey, (Object[])new Object[0]).replace(SpellTooltip.placeholder(itemToken), itemName).replace(SpellTooltip.placeholder(countToken), "" + amount);
            lines.add((Component)SpellTooltip.indentation(indentLevel).append((Component)Component.literal((String)ammo).withStyle(ammoResult.satisfied() ? ChatFormatting.GREEN : ChatFormatting.RED)));
        }
    }

    public static boolean shouldShow(Spell.Tooltip.LineOptions options, boolean details) {
        return details ? options.show_in_details : options.show_in_compact;
    }

    private static String createDescription(Holder<Spell> spellEntry, Player player, ItemStack itemStack, Spell spell, SpellPower.Result primaryPower) {
        ResourceLocation spellId = ((ResourceKey)spellEntry.unwrapKey().get()).location();
        String description = I18n.get((String)SpellTooltip.spellDescriptionTranslationKey(spellId), (Object[])new Object[0]);
        ArrayList<Spell.Trigger> triggers = new ArrayList<Spell.Trigger>();
        HashMap<String, List<String>> tokenReplacements = new HashMap<String, List<String>>();
        if (spell.passive != null) {
            triggers.addAll(spell.passive.triggers);
        }
        if (spell.deliver != null) {
            Spell.Delivery.Cloud cloud;
            Spell.ProjectileData projectile = null;
            if (spell.deliver.projectile != null) {
                projectile = spell.deliver.projectile.projectile;
            }
            if (spell.deliver.meteor != null) {
                projectile = spell.deliver.meteor.projectile;
            }
            if (projectile != null) {
                SpellTooltip.tokenizeProjectilePerks(projectile.perks, tokenReplacements);
            }
            Object launchProperties = null;
            if (spell.deliver.projectile != null) {
                launchProperties = spell.deliver.projectile.launch_properties;
            }
            if (spell.deliver.meteor != null) {
                launchProperties = spell.deliver.meteor.launch_properties;
            }
            if (launchProperties != null) {
                SpellTooltip.tokenizeProjectileLaunch((Spell.LaunchProperties)launchProperties, tokenReplacements);
            }
            if (spell.deliver.clouds != null && !spell.deliver.clouds.isEmpty() && (cloud = spell.deliver.clouds.get(0)) != null) {
                float cloud_duration = cloud.time_to_live_seconds;
                if (cloud_duration > 0.0f) {
                    SpellTooltip.addToken("cloud_duration", SpellTooltip.formattedNumber(cloud_duration), tokenReplacements);
                }
                float radius = cloud.volume.combinedRadius(primaryPower.baseValue());
                SpellTooltip.addToken("cloud_radius", SpellTooltip.formattedNumber(radius), tokenReplacements);
            }
            if (spell.deliver.stash_effect != null) {
                Spell.Delivery.StashEffect stashEffect = spell.deliver.stash_effect;
                SpellTooltip.addToken("stash_amplifier", SpellTooltip.formattedNumber(stashEffect.amplifier + 1), tokenReplacements);
                SpellTooltip.addToken("stash_duration", SpellTooltip.formattedNumber(stashEffect.duration), tokenReplacements);
                triggers.addAll(stashEffect.triggers);
            }
        }
        ArrayList<Spell.Impact> impacts = new ArrayList<Spell.Impact>();
        if (spell.impacts != null) {
            impacts.addAll(spell.impacts);
        }
        if (spell.modifiers != null) {
            for (Spell.Modifier modifier : spell.modifiers) {
                impacts.addAll(modifier.impacts);
            }
        }
        if (!impacts.isEmpty()) {
            Iterator<Spell.Modifier> estimatedOutput = SpellHelper.estimate(spell, player, itemStack);
            for (Spell.Impact impact : impacts) {
                if (impact.chance != 1.0f) {
                    SpellTooltip.addToken(impact_chance, SpellTooltip.percent(impact.chance), tokenReplacements);
                }
                switch (impact.action.type) {
                    case DAMAGE: {
                        description = SpellTooltip.replaceDamageTokens(description, damageToken, ((SpellHelper.EstimatedOutput)((Object)estimatedOutput)).damage());
                        break;
                    }
                    case HEAL: {
                        description = SpellTooltip.replaceDamageTokens(description, healToken, ((SpellHelper.EstimatedOutput)((Object)estimatedOutput)).heal());
                        break;
                    }
                    case STATUS_EFFECT: {
                        Spell.Impact.Action.StatusEffect statusEffect = impact.action.status_effect;
                        SpellTooltip.addToken(effectAmplifierToken, "" + (statusEffect.amplifier + 1), tokenReplacements);
                        if (statusEffect.amplifier_cap > 0) {
                            SpellTooltip.addToken(effectAmplifierCapToken, "" + (statusEffect.amplifier_cap + 1), tokenReplacements);
                        }
                        SpellTooltip.addToken(effectDurationToken, SpellTooltip.formattedNumber(statusEffect.duration), tokenReplacements);
                        break;
                    }
                    case TELEPORT: {
                        Spell.Impact.Action.Teleport teleport = impact.action.teleport;
                        switch (teleport.mode) {
                            case FORWARD: {
                                Spell.Impact.Action.Teleport.Forward forward = teleport.forward;
                                SpellTooltip.addToken(teleportDistanceToken, SpellTooltip.formattedNumber(forward.distance), tokenReplacements);
                            }
                        }
                        break;
                    }
                }
            }
            Spell.AreaImpact areaImpact = spell.area_impact;
            SpellTooltip.tokenizeAreaImpact(primaryPower, areaImpact, tokenReplacements);
        }
        for (Spell.Trigger trigger : triggers) {
            SpellTooltip.addToken(trigger_chance, SpellTooltip.percent(trigger.chance), tokenReplacements);
        }
        for (Spell.Modifier modifier : spell.modifiers) {
            if (modifier.range_add != 0.0f) {
                SpellTooltip.addToken("range_add", SpellTooltip.formattedNumber(modifier.range_add), tokenReplacements);
            }
            if (modifier.power_modifier != null) {
                SpellTooltip.addToken("power_multiplier", SpellTooltip.percent(modifier.power_modifier.power_multiplier), tokenReplacements);
                SpellTooltip.addToken("critical_chance_bonus", SpellTooltip.percent(modifier.power_modifier.critical_chance_bonus), tokenReplacements);
                SpellTooltip.addToken("critical_damage_bonus", SpellTooltip.percent(modifier.power_modifier.critical_damage_bonus), tokenReplacements);
            }
            if (modifier.replacing_area_impact != null) {
                SpellTooltip.tokenizeAreaImpact(primaryPower, modifier.replacing_area_impact, tokenReplacements);
            }
            if (modifier.knockback_multiply_base != 0.0f) {
                SpellTooltip.addToken("knockback_multiply_base", SpellTooltip.percent(modifier.knockback_multiply_base), tokenReplacements);
            }
            if (modifier.projectile_perks != null) {
                SpellTooltip.tokenizeProjectilePerks(modifier.projectile_perks, tokenReplacements);
            }
            if (modifier.projectile_launch != null) {
                SpellTooltip.tokenizeProjectileLaunch(modifier.projectile_launch, tokenReplacements);
            }
            if (modifier.effect_amplifier_add != 0) {
                SpellTooltip.addToken("effect_amplifier_add", SpellTooltip.formattedNumber(modifier.effect_amplifier_add), tokenReplacements);
            }
            if (modifier.effect_amplifier_cap_add != 0) {
                SpellTooltip.addToken("effect_amplifier_cap_add", SpellTooltip.formattedNumber(modifier.effect_amplifier_cap_add), tokenReplacements);
            }
            if (modifier.effect_duration_add != 0.0f) {
                SpellTooltip.addToken("effect_duration_add", SpellTooltip.formattedNumber(modifier.effect_duration_add), tokenReplacements);
            }
            if (modifier.stash_amplifier_add != 0) {
                SpellTooltip.addToken("stash_amplifier_add", SpellTooltip.formattedNumber(modifier.stash_amplifier_add), tokenReplacements);
            }
            if (modifier.spawn_duration_add != 0.0f) {
                SpellTooltip.addToken("spawn_duration_add", SpellTooltip.formattedNumber(modifier.spawn_duration_add), tokenReplacements);
            }
            if (modifier.cooldown_duration_deduct != 0.0f) {
                SpellTooltip.addToken("cooldown_duration_deduct", SpellTooltip.formattedNumber(modifier.cooldown_duration_deduct), tokenReplacements);
            }
            if (modifier.additional_placements.isEmpty()) continue;
            SpellTooltip.addToken(additional_placement_count, SpellTooltip.formattedNumber(modifier.additional_placements.size()), tokenReplacements);
        }
        HashSet<String> tokenStarts = new HashSet<String>();
        String string = "\\{[a-z]{3}";
        Pattern pattern = Pattern.compile(string);
        Matcher matcher = pattern.matcher(description);
        while (matcher.find()) {
            tokenStarts.add(matcher.group().substring(1));
        }
        for (Map.Entry<String, List<String>> entry : tokenReplacements.entrySet()) {
            String token = entry.getKey();
            if (!tokenStarts.contains(token.substring(0, 3))) continue;
            List<String> values = entry.getValue();
            description = SpellTooltip.replaceTokens(description, token, values);
        }
        DescriptionMutator mutator = descriptionMutators.get(spellId);
        if (mutator != null) {
            DescriptionMutator.Args args = new DescriptionMutator.Args(description, player, spellEntry);
            description = mutator.mutate(args);
        }
        return description;
    }

    private static void tokenizeAreaImpact(SpellPower.Result primaryPower, Spell.AreaImpact area_impact, HashMap<String, List<String>> tokenReplacements) {
        if (area_impact != null) {
            float radius = area_impact.combinedRadius(primaryPower.baseValue());
            SpellTooltip.addToken(impactRangeToken, SpellTooltip.formattedNumber(radius), tokenReplacements);
        }
    }

    private static void tokenizeProjectileLaunch(Spell.LaunchProperties launchProperties, HashMap<String, List<String>> tokenReplacements) {
        int extra_launch_count = launchProperties.extra_launch_count;
        if (extra_launch_count > 0) {
            SpellTooltip.addToken("extra_launch", SpellTooltip.formattedNumber(extra_launch_count), tokenReplacements);
        }
    }

    private static void tokenizeProjectilePerks(Spell.ProjectileData.Perks perks, HashMap<String, List<String>> tokenReplacements) {
        if (perks.ricochet > 0) {
            SpellTooltip.addToken("ricochet", SpellTooltip.formattedNumber(perks.ricochet), tokenReplacements);
        }
        if (perks.bounce > 0) {
            SpellTooltip.addToken("bounce", SpellTooltip.formattedNumber(perks.bounce), tokenReplacements);
        }
        if (perks.pierce > 0) {
            SpellTooltip.addToken("pierce", SpellTooltip.formattedNumber(perks.pierce), tokenReplacements);
        }
        if (perks.chain_reaction_size > 0) {
            SpellTooltip.addToken("chain_reaction_size", SpellTooltip.formattedNumber(perks.chain_reaction_size), tokenReplacements);
        }
    }

    private static void addToken(String token, String value, Map<String, List<String>> tokenReplacements) {
        if (!tokenReplacements.containsKey(token)) {
            tokenReplacements.put(token, new ArrayList());
        }
        tokenReplacements.get(token).add(value);
    }

    private static MutableComponent indentation(int level) {
        return Component.literal((String)(level > 0 ? " ".repeat(level) : ""));
    }

    private static String replaceDamageTokens(String text, String token, List<SpellHelper.EstimatedValue> values) {
        boolean indexTokens = values.size() > 1;
        for (int i = 0; i < values.size(); ++i) {
            SpellHelper.EstimatedValue range = values.get(i);
            String actualToken = indexTokens ? SpellTooltip.placeholder(token + "_" + (i + 1)) : SpellTooltip.placeholder(token);
            text = text.replace(actualToken, SpellTooltip.formattedRange(range.min(), range.max()));
        }
        return text;
    }

    public static String replaceTokens(String text, String token, List<String> values) {
        boolean indexTokens = values.size() > 1;
        for (int i = 0; i < values.size(); ++i) {
            String actualToken = indexTokens ? SpellTooltip.placeholder(token + "_" + (i + 1)) : SpellTooltip.placeholder(token);
            text = text.replace(actualToken, values.get(i));
        }
        return text;
    }

    public static String percent(float chance) {
        return (int)(chance * 100.0f) + "%";
    }

    public static String bonus(float amount, AttributeModifier.Operation operation) {
        switch (operation) {
            case ADD_VALUE: {
                return SpellTooltip.formattedNumber(amount);
            }
            case ADD_MULTIPLIED_BASE: {
                return SpellTooltip.percent(amount);
            }
            case ADD_MULTIPLIED_TOTAL: {
                return SpellTooltip.percent(amount - 1.0f);
            }
        }
        return "";
    }

    public static String formattedRange(double min, double max) {
        if (min == max) {
            return SpellTooltip.formattedNumber((float)min);
        }
        return SpellTooltip.formattedNumber((float)min) + " - " + SpellTooltip.formattedNumber((float)max);
    }

    public static String formattedNumber(float number) {
        DecimalFormat formatter = new DecimalFormat();
        formatter.setMaximumFractionDigits(1);
        return formatter.format((double)number);
    }

    public static String keyWithPlural(String key, float value) {
        if (value != 1.0f) {
            return key + ".plural";
        }
        return key;
    }

    public static String spellTranslationKey(ResourceLocation spellId) {
        return SpellTooltip.spellKeyPrefix(spellId) + ".name";
    }

    public static String spellDescriptionTranslationKey(ResourceLocation spellId) {
        return SpellTooltip.spellKeyPrefix(spellId) + ".description";
    }

    public static String spellKeyPrefix(ResourceLocation spellId) {
        return "spell." + spellId.getNamespace() + "." + spellId.getPath();
    }

    public static String spellGroup(String group) {
        String key = "spell.group." + group;
        if (I18n.exists((String)key)) {
            return I18n.get((String)key, (Object[])new Object[0]);
        }
        return "";
    }

    public static void addDescriptionMutator(ResourceLocation spellId, DescriptionMutator handler) {
        descriptionMutators.put(spellId, handler);
    }

    public record SpellInfo(List<Component> content, int sectionDividersAdded, boolean showDetails) {
    }

    public static interface DescriptionMutator {
        public String mutate(Args var1);

        public record Args(String description, Player player, Holder<Spell> spellEntry) {
        }
    }
}

