/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public class ShiftedParticle
extends TextureSheetParticle {
    private final SpriteSet spriteProvider;

    protected ShiftedParticle(ClientLevel world, double x, double y, double z, double velocityX, double velocityY, double velocityZ, SpriteSet spriteProvider) {
        super(world, x, y, z);
        this.gravity = 0.225f;
        this.friction = 1.0f;
        this.spriteProvider = spriteProvider;
        this.yd = velocityY + (Math.random() * 2.0 - 1.0) * (double)0.05f;
        this.quadSize = 0.1f * (this.random.nextFloat() * this.random.nextFloat() * 1.0f + 1.0f);
        this.lifetime = (int)(16.0 / ((double)this.random.nextFloat() * 0.8 + 0.2)) + 2;
        this.setSpriteFromAge(spriteProvider);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public void tick() {
        super.tick();
        this.setSpriteFromAge(this.spriteProvider);
        this.xd *= (double)0.95f;
        this.yd *= (double)0.9f;
        this.zd *= (double)0.95f;
    }

    protected void renderRotatedQuad(VertexConsumer vertexConsumer, Quaternionf quaternionf, float f, float g, float h, float i) {
        float y = g + this.getQuadSize(0.0f);
        super.renderRotatedQuad(vertexConsumer, quaternionf, f, y, h, i);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class RootsFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;

        public RootsFactory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(SimpleParticleType SimpleParticleType2, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            ShiftedParticle particle = new ShiftedParticle(clientWorld, d, e, f, g, h, i, this.spriteProvider);
            particle.setColor(1.0f, 1.0f, 1.0f);
            particle.alpha = 1.0f;
            particle.setSize(3.0f, 3.0f);
            particle.xd = 0.0;
            particle.zd = 0.0;
            particle.quadSize = 0.25f;
            return particle;
        }
    }
}

