/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.HugeExplosionParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.spell_engine.client.particle.TemplateParticleEffect;
import net.spell_engine.client.particle.TemplateParticleType;
import net.spell_engine.client.util.Color;

public class SpellExplosionParticle
extends HugeExplosionParticle {
    protected SpellExplosionParticle(ClientLevel world, double x, double y, double z, double d, SpriteSet spriteProvider) {
        super(world, x, y, z, d, spriteProvider);
    }

    public int getLightColor(float tint) {
        return 255;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class TemplateFactory
    implements ParticleProvider<TemplateParticleType> {
        private final SpriteSet spriteProvider;

        public TemplateFactory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(TemplateParticleType particleType, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            SpellExplosionParticle particle = new SpellExplosionParticle(clientWorld, d, e, f, g, this.spriteProvider);
            particle.quadSize = 1.2f;
            particle.rCol = 1.0f;
            particle.gCol = 1.0f;
            particle.bCol = 1.0f;
            particle.lifetime = 10;
            TemplateParticleType.apply(particleType, (Particle)particle);
            TemplateParticleEffect.Appearance appearance = particleType.getAppearance();
            if (appearance != null) {
                Color color = appearance.color;
                if (color != null) {
                    particle.alpha *= appearance.color.alpha();
                }
                particle.quadSize *= appearance.scale;
            }
            return particle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;

        public Factory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(SimpleParticleType SimpleParticleType2, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            SpellExplosionParticle particle = new SpellExplosionParticle(clientWorld, d, e, f, g, this.spriteProvider);
            particle.quadSize = 1.2f;
            particle.rCol = 1.0f;
            particle.gCol = 1.0f;
            particle.bCol = 1.0f;
            particle.lifetime = 10;
            return particle;
        }
    }
}

