/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.client.render;

import java.util.Map;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.internals.casting.SpellCast;
import net.spell_engine.internals.casting.SpellCasterEntity;
import net.spell_engine.mixin.client.render.ModelPredicateProviderRegistryAccessor;

public class ModelPredicateHelper {
    public static void injectBowSkillUsePredicate(Item item) {
        Map<Item, Map<ResourceLocation, ItemPropertyFunction>> itemSpecificPredicates = ModelPredicateProviderRegistryAccessor.itemSpecificPredicates_SpellEngine();
        if (itemSpecificPredicates == null || itemSpecificPredicates.isEmpty()) {
            System.err.println("Spell Engine: Failed to inject vanilla model predicates.");
            return;
        }
        ModelPredicateHelper.injectModelPredicate(itemSpecificPredicates, item, ResourceLocation.parse((String)"pull"), (stack, world, entity, seed) -> {
            SpellCast.Progress progress = ModelPredicateHelper.getItemStackRangedSkillProgress(stack, entity);
            if (progress != null) {
                return progress.ratio();
            }
            return -1.0f;
        });
        ModelPredicateHelper.injectModelPredicate(itemSpecificPredicates, item, ResourceLocation.parse((String)"pulling"), (stack, world, entity, seed) -> {
            if (ModelPredicateHelper.isItemStackUsedForRangedSkill(stack, entity)) {
                return 1.0f;
            }
            return -1.0f;
        });
    }

    public static void injectCrossBowSkillUsePredicate(Item item) {
        Map<Item, Map<ResourceLocation, ItemPropertyFunction>> itemSpecificPredicates = ModelPredicateProviderRegistryAccessor.itemSpecificPredicates_SpellEngine();
        if (itemSpecificPredicates == null || itemSpecificPredicates.isEmpty()) {
            System.err.println("Spell Engine: Failed to inject vanilla model predicates.");
            return;
        }
        ModelPredicateHelper.injectModelPredicate(itemSpecificPredicates, item, ResourceLocation.parse((String)"pull"), (stack, world, entity, seed) -> {
            SpellCast.Progress progress = ModelPredicateHelper.getItemStackRangedSkillProgress(stack, entity);
            if (progress != null) {
                return progress.ratio();
            }
            return -1.0f;
        });
        ModelPredicateHelper.injectModelPredicate(itemSpecificPredicates, item, ResourceLocation.parse((String)"pulling"), (stack, world, entity, seed) -> {
            if (ModelPredicateHelper.isItemStackUsedForRangedSkill(stack, entity)) {
                return 1.0f;
            }
            return -1.0f;
        });
        ModelPredicateHelper.injectModelPredicate(itemSpecificPredicates, item, ResourceLocation.parse((String)"charged"), (stack, world, entity, seed) -> {
            SpellCast.Progress progress = ModelPredicateHelper.getItemStackRangedSkillProgress(stack, entity);
            if (progress != null && progress.ratio() > 0.94f) {
                return 1.0f;
            }
            return -1.0f;
        });
    }

    private static void injectModelPredicate(Map<Item, Map<ResourceLocation, ItemPropertyFunction>> all, Item item, ResourceLocation id, ItemPropertyFunction customPredicate) {
        Map<ResourceLocation, ItemPropertyFunction> itemSpecific = all.get(item);
        if (itemSpecific == null) {
            return;
        }
        ItemPropertyFunction existingPredicate = itemSpecific.get(id);
        if (existingPredicate == null) {
            return;
        }
        ItemProperties.register((Item)item, (ResourceLocation)id, (stack, world, entity, seed) -> {
            float result;
            if (customPredicate != null && (result = customPredicate.call(stack, world, entity, seed)) >= 0.0f) {
                return result;
            }
            return existingPredicate.call(stack, world, entity, seed);
        });
    }

    private static SpellCast.Progress getItemStackRangedSkillProgress(ItemStack itemStack, LivingEntity entity) {
        if (entity instanceof SpellCasterEntity) {
            SpellCast.Process process;
            SpellCasterEntity caster = (SpellCasterEntity)entity;
            if (entity.getMainHandItem() == itemStack && (process = caster.getSpellCastProcess()) != null && ((Spell)process.spell().value()).active.cast.animates_ranged_weapon) {
                return process.progress(entity.level().getGameTime());
            }
        }
        return null;
    }

    private static boolean isItemStackUsedForRangedSkill(ItemStack itemStack, LivingEntity entity) {
        if (entity instanceof SpellCasterEntity) {
            SpellCast.Process process;
            SpellCasterEntity caster = (SpellCasterEntity)entity;
            if (entity.getMainHandItem() == itemStack && (process = caster.getSpellCastProcess()) != null && ((Spell)process.spell().value()).active.cast.animates_ranged_weapon) {
                return true;
            }
        }
        return false;
    }
}

