/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.spell_engine.api.render.CustomModels;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.client.render.SpellModelHelper;
import net.spell_engine.entity.SpellCloud;

public class SpellCloudRenderer<T extends SpellCloud>
extends EntityRenderer<T> {
    private final ItemRenderer itemRenderer;

    public SpellCloudRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.itemRenderer = context.getItemRenderer();
    }

    public ResourceLocation getTexture(T entity) {
        return null;
    }

    public void render(T entity, float yaw, float tickDelta, PoseStack matrixStack, MultiBufferSource vertexConsumers, int light) {
        super.render(entity, yaw, tickDelta, matrixStack, vertexConsumers, light);
        Spell.Delivery.Cloud data = ((SpellCloud)((Object)entity)).getCloudData();
        if (data == null) {
            return;
        }
        Spell.ProjectileModel renderData = data.client_data.model;
        if (renderData == null) {
            return;
        }
        matrixStack.pushPose();
        matrixStack.mulPose(Axis.YP.rotationDegrees(-1.0f * entity.getYRot() + 180.0f));
        matrixStack.translate(0.0, 0.5, 0.0);
        long time = entity.level().getGameTime();
        float absoluteTime = (float)time + tickDelta;
        matrixStack.mulPose(Axis.YP.rotationDegrees(absoluteTime * renderData.rotate_degrees_per_tick));
        matrixStack.scale(renderData.scale, renderData.scale, renderData.scale);
        if (renderData.model_id != null && !renderData.model_id.isEmpty()) {
            ResourceLocation modelId = ResourceLocation.parse((String)renderData.model_id);
            CustomModels.render(SpellModelHelper.LAYERS.get((Object)renderData.light_emission), this.itemRenderer, modelId, matrixStack, vertexConsumers, light, entity.getId());
        }
        matrixStack.popPose();
    }
}

