/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.compat.container;

import com.github.theredbrain.bundleapi.BundleAPI;
import com.github.theredbrain.bundleapi.component.type.CustomBundleContentsComponent;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.spell_engine.compat.container.ContainerCompat;

public class CustomBundleCompat {
    public static void init() {
        ContainerCompat.resolvers.add(itemStack -> {
            CustomBundleContentsComponent bundle = (CustomBundleContentsComponent)itemStack.get(BundleAPI.CUSTOM_BUNDLE_CONTENTS_COMPONENT);
            if (bundle != null) {
                return new CustomBundleAdapter(bundle);
            }
            return null;
        });
    }

    public record CustomBundleAdapter(CustomBundleContentsComponent component) implements ContainerCompat.Adapter
    {
        @Override
        public int size() {
            return this.component.size();
        }

        @Override
        public ItemStack get(int index) {
            return this.component.get(index);
        }

        @Override
        public ContainerCompat.Adapter createNewWithContents(List<ItemStack> contents) {
            CustomBundleContentsComponent.Builder newBundle = new CustomBundleContentsComponent.Builder(this.component).clear();
            for (ItemStack stackToAdd : contents) {
                newBundle.add(stackToAdd);
            }
            return new CustomBundleAdapter(newBundle.build());
        }

        @Override
        public void attachTo(ItemStack itemStack) {
            itemStack.set(BundleAPI.CUSTOM_BUNDLE_CONTENTS_COMPONENT, (Object)this.component);
        }
    }
}

