/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.entity;

import java.util.List;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.level.Level;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.fx.ParticleBatch;
import net.spell_engine.api.spell.fx.Sound;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.fx.ParticleHelper;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.utils.SoundPlayerWorld;
import org.jetbrains.annotations.Nullable;

public class SpellCloud
extends Entity
implements TraceableEntity {
    public static EntityType<SpellCloud> ENTITY_TYPE;
    @Nullable
    private LivingEntity owner;
    @Nullable
    private UUID ownerUuid;
    private int timeToLive;
    private int impactsPerformed = 0;
    private int impactCap = 0;
    private ResourceLocation spellId;
    private int dataIndex = 0;
    private SpellHelper.ImpactContext context;
    private static final EntityDataAccessor<String> SPELL_ID_TRACKER;
    private static final EntityDataAccessor<Integer> DATA_INDEX_TRACKER;
    private static final EntityDataAccessor<Float> RADIUS_TRACKER;
    private boolean presenceSoundFired = false;

    public SpellCloud(EntityType<? extends SpellCloud> entityType, Level world) {
        super(entityType, world);
    }

    public SpellCloud(Level world) {
        super(ENTITY_TYPE, world);
        this.noPhysics = true;
    }

    public void onCreatedFromSpell(ResourceLocation spellId, Spell.Delivery.Cloud cloudData, SpellHelper.ImpactContext context, float time_to_live_seconds) {
        this.spellId = spellId;
        this.context = context;
        Holder<Spell> spellEntry = this.getSpellEntry();
        if (spellEntry != null) {
            Spell spell = (Spell)spellEntry.value();
            int index = 0;
            List<Spell.Delivery.Cloud> dataList = spell.deliver.clouds;
            if (!dataList.isEmpty()) {
                index = dataList.indexOf(cloudData);
            }
            this.dataIndex = index;
        }
        this.getEntityData().set(SPELL_ID_TRACKER, (Object)this.spellId.toString());
        this.getEntityData().set(DATA_INDEX_TRACKER, (Object)this.dataIndex);
        this.getEntityData().set(RADIUS_TRACKER, (Object)Float.valueOf(this.calculateRadius()));
        this.timeToLive = (int)(time_to_live_seconds * 20.0f);
        this.impactCap = cloudData.impact_cap;
    }

    private float calculateRadius() {
        Spell.Delivery.Cloud cloudData = this.getCloudData();
        if (cloudData != null) {
            float radius = cloudData.volume.radius;
            if (this.context != null) {
                radius = cloudData.volume.combinedRadius(this.context.power().baseValue());
            }
            return radius;
        }
        return 0.0f;
    }

    public EntityDimensions getDimensions(Pose pose) {
        Spell.Delivery.Cloud cloudData = this.getCloudData();
        if (cloudData != null) {
            Float radius = (Float)this.getEntityData().get(RADIUS_TRACKER);
            float heightMultiplier = cloudData.volume.area.vertical_range_multiplier;
            return EntityDimensions.scalable((float)(radius.floatValue() * 2.0f), (float)(radius.floatValue() * heightMultiplier));
        }
        return super.getDimensions(pose);
    }

    public void setOwner(@Nullable LivingEntity owner) {
        this.owner = owner;
        this.ownerUuid = owner == null ? null : owner.getUUID();
    }

    @Nullable
    public Entity getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUuid != null && this.level() instanceof ServerLevel && (entity = ((ServerLevel)this.level()).getEntity(this.ownerUuid)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(SPELL_ID_TRACKER, (Object)"");
        builder.define(DATA_INDEX_TRACKER, (Object)this.dataIndex);
        builder.define(RADIUS_TRACKER, (Object)Float.valueOf(0.0f));
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> data) {
        super.onSyncedDataUpdated(data);
        if (this.level().isClientSide) {
            String rawSpellId = (String)this.getEntityData().get(SPELL_ID_TRACKER);
            if (rawSpellId != null && !rawSpellId.isEmpty()) {
                this.spellId = ResourceLocation.parse((String)rawSpellId);
            }
            this.dataIndex = (Integer)this.getEntityData().get(DATA_INDEX_TRACKER);
            this.refreshDimensions();
        }
    }

    protected void readAdditionalSaveData(CompoundTag nbt) {
        this.tickCount = nbt.getInt(NBTKey.AGE.key);
        this.timeToLive = nbt.getInt(NBTKey.TIME_TO_LIVE.key);
        this.spellId = ResourceLocation.parse((String)nbt.getString(NBTKey.SPELL_ID.key));
        this.dataIndex = nbt.getInt(NBTKey.DATA_INDEX.key);
    }

    protected void addAdditionalSaveData(CompoundTag nbt) {
        nbt.putInt(NBTKey.AGE.key, this.tickCount);
        nbt.putInt(NBTKey.TIME_TO_LIVE.key, this.timeToLive);
        nbt.putString(NBTKey.SPELL_ID.key, this.spellId.toString());
        nbt.putInt(NBTKey.DATA_INDEX.key, this.dataIndex);
    }

    public boolean isSilent() {
        return false;
    }

    public void tick() {
        super.tick();
        Spell.Delivery.Cloud cloudData = this.getCloudData();
        if (cloudData == null) {
            return;
        }
        Level world = this.level();
        if (world.isClientSide) {
            boolean spawnParticles;
            Spell.Delivery.Cloud.ClientData clientData = cloudData.client_data;
            boolean bl = spawnParticles = clientData.particle_spawn_interval <= 1 || this.tickCount % clientData.particle_spawn_interval == 0;
            if (spawnParticles) {
                for (ParticleBatch particleBatch : clientData.interval_particles) {
                    ParticleHelper.play(world, (Entity)this, particleBatch);
                }
            }
            for (ParticleBatch particleBatch : clientData.particles) {
                ParticleHelper.play(world, (Entity)this, particleBatch);
            }
            Sound presence_sound = cloudData.presence_sound;
            if (!this.presenceSoundFired && presence_sound != null) {
                SoundEvent soundEvent = (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)presence_sound.id()));
                if (soundEvent != null) {
                    ((SoundPlayerWorld)world).playSoundFromEntity(this, soundEvent, SoundSource.PLAYERS, presence_sound.volume(), presence_sound.randomizedPitch());
                    this.presenceSoundFired = true;
                } else {
                    System.out.println("SpellCloud: Failed to find presence sound " + presence_sound.id());
                }
            }
        } else {
            if (this.tickCount >= this.timeToLive || this.impactCap > 0 && this.impactsPerformed >= this.impactCap) {
                this.discard();
                return;
            }
            if (this.tickCount % cloudData.impact_tick_interval == 0) {
                Spell.AreaImpact area_impact = cloudData.volume;
                LivingEntity owner = (LivingEntity)this.getOwner();
                Holder<Spell> spellEntry = this.getSpellEntry();
                if (area_impact != null && owner != null && spellEntry != null) {
                    boolean performed;
                    Spell spell = (Spell)spellEntry.value();
                    SpellHelper.ImpactContext context = this.context;
                    if (context == null) {
                        context = new SpellHelper.ImpactContext();
                    }
                    if (performed = SpellHelper.lookupAndPerformAreaImpact(area_impact, spellEntry, owner, null, this, spell.impacts, context.position(this.position()), true)) {
                        ParticleHelper.play(world, (Entity)this, cloudData.impact_particles);
                        ++this.impactsPerformed;
                    }
                }
            }
        }
    }

    @Nullable
    public Spell.Delivery.Cloud getCloudData() {
        Holder<Spell> spellEntry = this.getSpellEntry();
        if (spellEntry != null) {
            Spell spell = (Spell)spellEntry.value();
            return spell.deliver.clouds.get(this.dataIndex);
        }
        return null;
    }

    @Nullable
    public Holder<Spell> getSpellEntry() {
        return SpellRegistry.from(this.level()).getHolder(this.spellId).orElse(null);
    }

    static {
        SPELL_ID_TRACKER = SynchedEntityData.defineId(SpellCloud.class, (EntityDataSerializer)EntityDataSerializers.STRING);
        DATA_INDEX_TRACKER = SynchedEntityData.defineId(SpellCloud.class, (EntityDataSerializer)EntityDataSerializers.INT);
        RADIUS_TRACKER = SynchedEntityData.defineId(SpellCloud.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    }

    private static enum NBTKey {
        AGE("Age"),
        TIME_TO_LIVE("TTL"),
        SPELL_ID("SpellId"),
        DATA_INDEX("DataIndex");

        public final String key;

        private NBTKey(String key) {
            this.key = key;
        }
    }
}

