/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.entity;

import com.google.gson.Gson;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.spell_engine.SpellEngineMod;
import net.spell_engine.api.entity.TwoWayCollisionChecker;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.fx.ParticleBatch;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.client.render.FlyingSpellEntity;
import net.spell_engine.fx.ParticleHelper;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.internals.target.EntityRelations;
import net.spell_engine.internals.target.SpellTarget;
import net.spell_engine.utils.SoundHelper;
import net.spell_engine.utils.VectorHelper;
import net.spell_power.api.SpellPower;
import net.spell_power.api.SpellSchool;
import org.jetbrains.annotations.Nullable;

public class SpellProjectile
extends Projectile
implements FlyingSpellEntity {
    public static EntityType<SpellProjectile> ENTITY_TYPE;
    private static Random random;
    public float range = 128.0f;
    private Spell.ProjectileData.Perks perks;
    private SpellHelper.ImpactContext context;
    public Vec3 previousVelocity;
    private boolean hasCustomDimensions = false;
    private boolean skipTravel = false;
    private int followTicks = 0;
    protected Set<Integer> impactHistory = new HashSet<Integer>();
    private Gson gson = new Gson();
    private Holder<Spell> spellEntry;
    private Entity followedTarget;
    private double distanceToFollow = 0.0;
    private ItemStack itemStackModel;
    private static String NBT_BEHAVIOUR;
    private static String NBT_SPELL_ID;
    private static String NBT_PERKS;
    private static String NBT_IMPACT_CONTEXT;
    private static String NBT_ITEM_MODEL_ID;
    private static final EntityDataAccessor<String> TRACKER_SPELL_ID;
    private static final EntityDataAccessor<String> TRACKER_BEHAVIOUR;
    private static final EntityDataAccessor<Integer> TRACKER_TARGET_ID;
    private static final EntityDataAccessor<String> TRACKER_ITEM_MODEL_ID;

    public SpellProjectile(EntityType<? extends Projectile> entityType, Level world) {
        super(entityType, world);
    }

    protected SpellProjectile(Level world, LivingEntity owner) {
        super(ENTITY_TYPE, world);
        this.setOwner((Entity)owner);
    }

    public SpellProjectile(Level world, LivingEntity caster, double x, double y, double z, Behaviour behaviour, Holder<Spell> spellEntry, SpellHelper.ImpactContext context, Spell.ProjectileData.Perks mutablePerks) {
        this(world, caster);
        this.setPos(x, y, z);
        this.setBehaviour(behaviour);
        this.setSpell(spellEntry);
        this.perks = mutablePerks;
        this.context = context;
        Spell.ProjectileData projectileData = this.projectileData();
        if (projectileData.client_data != null && projectileData.client_data.model != null) {
            Spell.ProjectileModel model = projectileData.client_data.model;
            if (model.use_held_item) {
                this.setItemStackModel(caster.getMainHandItem());
            }
        }
    }

    public Spell.ProjectileData.Perks mutablePerks() {
        return this.perks;
    }

    public Spell.ProjectileData projectileData() {
        Holder<Spell> spellEntry = this.getSpellEntry();
        if (spellEntry == null) {
            return null;
        }
        Spell spell = (Spell)this.getSpellEntry().value();
        Spell.Delivery release = spell.deliver;
        switch (release.type) {
            case PROJECTILE: {
                return release.projectile.projectile;
            }
            case METEOR: {
                return release.meteor.projectile;
            }
        }
        return null;
    }

    public void setVelocity(double x, double y, double z, float speed, float spread, float divergence) {
        double rotX = Math.toRadians(divergence * random.nextFloat(spread, 1.0f));
        double rotY = Math.toRadians(360.0f * random.nextFloat());
        Vec3 vec3d = new Vec3(x, y, z).xRot((float)rotX).yRot((float)rotY).scale((double)speed);
        this.setDeltaMovement(vec3d);
        double d = vec3d.horizontalDistance();
        this.setYRot((float)(Mth.atan2((double)vec3d.x, (double)vec3d.z) * 57.2957763671875));
        this.setXRot((float)(Mth.atan2((double)vec3d.y, (double)d) * 57.2957763671875));
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }

    public EntityDimensions getDimensions(Pose pose) {
        Spell.ProjectileData data = this.projectileData();
        if (data != null && data.hitbox != null) {
            this.hasCustomDimensions = true;
            float width = data.hitbox.width;
            float height = data.hitbox.height;
            return EntityDimensions.scalable((float)width, (float)height);
        }
        return super.getDimensions(pose);
    }

    public Entity getFollowedTarget() {
        Entity entityReference = null;
        if (this.level().isClientSide) {
            Integer id = (Integer)this.getEntityData().get(TRACKER_TARGET_ID);
            if (id != null && id > 0) {
                entityReference = this.level().getEntity(id.intValue());
            }
        } else {
            entityReference = this.followedTarget;
        }
        if (entityReference != null && entityReference.isAttackable() && entityReference.isAlive()) {
            return entityReference;
        }
        return entityReference;
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        double d0 = this.getBoundingBox().getSize() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        boolean result = distance < (d0 *= 128.0) * d0;
        return result;
    }

    public void tick() {
        this.skipTravel = false;
        Entity entity = this.getOwner();
        Behaviour behaviour = this.getBehaviour();
        Holder<Spell> spellEntry = this.getSpellEntry();
        if (!this.level().isClientSide) {
            if (spellEntry == null) {
                System.err.println("Spell Projectile safeguard termination, failed to resolve spell: " + String.valueOf(this.spellId()));
                this.kill();
                return;
            }
            switch (behaviour.ordinal()) {
                case 0: {
                    if (!(this.moveDist >= this.range) && this.tickCount <= 1200) break;
                    this.kill();
                    return;
                }
                case 1: {
                    if ((double)this.moveDist >= (double)this.range * 0.98) {
                        this.finishFalling();
                        this.kill();
                        return;
                    }
                    if (this.tickCount <= 1200) break;
                    this.kill();
                    return;
                }
            }
            if (this.moveDist >= this.range || this.tickCount > 1200) {
                this.kill();
                return;
            }
        }
        this.previousVelocity = new Vec3(this.getDeltaMovement().x, this.getDeltaMovement().y, this.getDeltaMovement().z);
        if (this.level().isClientSide || (entity == null || !entity.isRemoved()) && this.level().hasChunkAt(this.blockPosition())) {
            super.tick();
            if (!this.level().isClientSide) {
                HitResult hitResult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, x$0 -> this.canHitEntity((Entity)x$0));
                this.handleHitResult(hitResult, behaviour, spellEntry);
                if (hitResult.getType() == HitResult.Type.MISS && this.hasCustomDimensions) {
                    AABB boundingBox = this.getBoundingBox();
                    for (Entity areaTarget : this.level().getEntities(entity, this.getBoundingBox().inflate(1.0), x$0 -> this.canHitEntity((Entity)x$0))) {
                        areaTarget.getBoundingBox().intersects(boundingBox);
                        EntityHitResult areaHitResult = new EntityHitResult(areaTarget);
                        this.handleHitResult((HitResult)areaHitResult, behaviour, spellEntry);
                    }
                }
            }
            this.checkInsideBlocks();
            if (!this.skipTravel) {
                Spell.ProjectileData data;
                this.followTarget();
                Vec3 velocity = this.getDeltaMovement();
                double d = this.getX() + velocity.x;
                double e = this.getY() + velocity.y;
                double f = this.getZ() + velocity.z;
                ProjectileUtil.rotateTowardsMovement((Entity)this, (float)0.2f);
                float g = this.getDrag();
                if (this.isInWater()) {
                    for (int i = 0; i < 4; ++i) {
                        float h = 0.25f;
                        this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, d - velocity.x * 0.25, e - velocity.y * 0.25, f - velocity.z * 0.25, velocity.x, velocity.y, velocity.z);
                    }
                    g = 0.8f;
                }
                if ((data = this.projectileData()) != null) {
                    if (this.level().isClientSide) {
                        for (ParticleBatch travel_particles : data.client_data.travel_particles) {
                            ParticleHelper.play(this.level(), (Entity)this, this.getYRot(), this.getXRot(), travel_particles);
                        }
                    } else if (data.travel_sound != null && this.tickCount % data.travel_sound_interval == 0) {
                        SoundHelper.playSound(this.level(), (Entity)this, data.travel_sound);
                    }
                }
                this.setPos(d, e, f);
                this.moveDist = (float)((double)this.moveDist + velocity.length());
            }
        } else {
            this.discard();
        }
    }

    private void handleHitResult(HitResult hitResult, Behaviour behaviour, Holder<Spell> spellEntry) {
        if (hitResult.getType() != HitResult.Type.MISS) {
            switch (behaviour.ordinal()) {
                case 0: {
                    boolean shouldCollideWithEntity = true;
                    if (hitResult.getType() == HitResult.Type.ENTITY) {
                        Entity entity;
                        Entity target = ((EntityHitResult)hitResult).getEntity();
                        Spell spell = (Spell)spellEntry.value();
                        if (SpellEngineMod.config.projectiles_pass_thru_irrelevant_targets && spell != null && !spell.impacts.isEmpty() && !this.impactHistory.contains(target.getId()) && (entity = this.getOwner()) instanceof LivingEntity) {
                            LivingEntity owner = (LivingEntity)entity;
                            EnumSet<SpellTarget.Intent> intents = SpellHelper.impactIntents(spell);
                            boolean intentAllows = false;
                            for (SpellTarget.Intent intent : intents) {
                                intentAllows = intentAllows || EntityRelations.actionAllowed(SpellTarget.FocusMode.DIRECT, intent, owner, target);
                            }
                            shouldCollideWithEntity = intentAllows;
                        }
                    }
                    if (shouldCollideWithEntity) {
                        this.onHit(hitResult);
                        break;
                    }
                    this.setFollowedTarget(null);
                    break;
                }
                case 1: {
                    TwoWayCollisionChecker.CollisionResult result;
                    Entity target;
                    Function<Entity, TwoWayCollisionChecker.CollisionResult> reverse;
                    if (hitResult.getType() != HitResult.Type.ENTITY || (reverse = ((TwoWayCollisionChecker)(target = ((EntityHitResult)hitResult).getEntity())).getReverseCollisionChecker()) == null || (result = reverse.apply((Entity)this)) != TwoWayCollisionChecker.CollisionResult.COLLIDE) break;
                    this.finishFalling();
                }
            }
        }
    }

    private void finishFalling() {
        Entity owner = this.getOwner();
        if (owner == null || owner.isRemoved()) {
            return;
        }
        if (owner instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)owner;
            SpellHelper.fallImpact(livingEntity, (Entity)this, this.getSpellEntry(), this.context.position(this.position()));
        }
    }

    private void followTarget() {
        Entity target = this.getFollowedTarget();
        Spell.ProjectileData data = this.projectileData();
        if (data == null) {
            return;
        }
        float homing_angle = this.projectileData().homing_angle;
        if (this.projectileData().homing_angles != null && this.followTicks < this.projectileData().homing_angles.length) {
            homing_angle = this.projectileData().homing_angles[this.followTicks];
        }
        if (target != null && homing_angle > 0.0f) {
            if (data.homing_after_relative_distance > 0.0f || data.homing_after_absolute_distance > 0.0f) {
                boolean shouldFollow;
                boolean bl = shouldFollow = (double)this.moveDist >= this.distanceToFollow * (double)data.homing_after_relative_distance || this.moveDist >= data.homing_after_absolute_distance;
                if (!shouldFollow) {
                    return;
                }
            }
            Vec3 distanceVector = target.position().add(0.0, (double)(target.getBbHeight() / 2.0f), 0.0).subtract(this.position().add(0.0, (double)(this.getBbHeight() / 2.0f), 0.0));
            Vec3 newVelocity = VectorHelper.rotateTowards(this.getDeltaMovement(), distanceVector, homing_angle);
            if (newVelocity.lengthSqr() > 0.0) {
                this.setDeltaMovement(newVelocity);
                ++this.followTicks;
            }
        }
    }

    protected float getDrag() {
        return 0.95f;
    }

    protected void onHitEntity(EntityHitResult entityHitResult) {
        Entity entity;
        Entity target;
        if (!this.level().isClientSide && (target = entityHitResult.getEntity()) != null && !this.impactHistory.contains(target.getId()) && this.getOwner() != null && (entity = this.getOwner()) instanceof LivingEntity) {
            LivingEntity caster = (LivingEntity)entity;
            this.setFollowedTarget(null);
            SpellHelper.ImpactContext context = this.context;
            if (context == null) {
                context = new SpellHelper.ImpactContext();
                Spell spell = (Spell)this.getSpellEntry().value();
                Entity entity2 = this.getOwner();
                if (entity2 instanceof Player) {
                    Player player = (Player)entity2;
                    if (spell != null) {
                        context = context.power(SpellPower.getSpellPower((SpellSchool)spell.school, (LivingEntity)player));
                    }
                }
            }
            if (context.power() == null) {
                this.kill();
                return;
            }
            Vec3 prevProjectilePos = new Vec3(this.xo, this.yo, this.zo);
            Vec3 hitVector = entityHitResult.getLocation().subtract(prevProjectilePos).normalize().scale((double)(this.getBbWidth() * 0.5f));
            Vec3 hitPosition = entityHitResult.getLocation().subtract(hitVector);
            boolean performed = SpellHelper.projectileImpact(caster, (Entity)this, target, this.getSpellEntry(), context.position(hitPosition));
            if (performed) {
                this.chainReactionFrom(target);
                if (this.ricochetFrom(target, caster)) {
                    return;
                }
                if (this.pierced(target)) {
                    return;
                }
                this.kill();
            }
        }
    }

    protected boolean ricochetFrom(Entity target, LivingEntity caster) {
        if (this.perks == null || this.perks.ricochet <= 0) {
            return false;
        }
        this.impactHistory.add(target.getId());
        AABB box = this.getBoundingBox().inflate((double)this.perks.ricochet_range, (double)this.perks.ricochet_range, (double)this.perks.ricochet_range);
        Spell spell = (Spell)this.getSpellEntry().value();
        EnumSet<SpellTarget.Intent> intents = SpellHelper.impactIntents(spell);
        Predicate<Entity> intentMatches = entity -> {
            boolean intentAllows = false;
            for (SpellTarget.Intent intent : intents) {
                intentAllows = intentAllows || EntityRelations.actionAllowed(SpellTarget.FocusMode.AREA, intent, caster, entity);
            }
            return intentAllows;
        };
        List otherTargets = this.level().getEntities((Entity)this, box, entity -> entity.isAttackable() && entity instanceof LivingEntity && !this.impactHistory.contains(entity.getId()) && intentMatches.test((Entity)entity) && !entity.position().equals((Object)target.position()));
        if (otherTargets.isEmpty()) {
            this.setFollowedTarget(null);
            return false;
        }
        otherTargets.sort(Comparator.comparingDouble(o -> o.distanceToSqr(target)));
        Entity newTarget = (Entity)otherTargets.get(0);
        this.setPos(target.position().add(0.0, (double)(target.getBbHeight() * 0.5f), 0.0));
        this.setFollowedTarget(newTarget);
        Vec3 distanceVector = newTarget.position().add(0.0, (double)(newTarget.getBbHeight() / 2.0f), 0.0).subtract(this.position().add(0.0, (double)(this.getBbHeight() / 2.0f), 0.0));
        Vec3 newVelocity = distanceVector.normalize().scale(this.getDeltaMovement().length());
        this.setDeltaMovement(newVelocity);
        this.hasImpulse = true;
        --this.perks.ricochet;
        if (this.perks.bounce_ricochet_sync) {
            --this.perks.bounce;
        }
        return true;
    }

    private boolean pierced(Entity target) {
        if (this.perks == null || this.perks.pierce <= 0) {
            return false;
        }
        this.impactHistory.add(target.getId());
        this.setFollowedTarget(null);
        --this.perks.pierce;
        double tiny = 0.01 * (double)(-1 * (this.perks.pierce % 2));
        this.setDeltaMovement(this.getDeltaMovement().scale(1.0 + tiny));
        this.hasImpulse = true;
        return true;
    }

    private boolean bounceFrom(BlockHitResult blockHitResult) {
        if (this.perks == null || this.perks.bounce <= 0) {
            return false;
        }
        Vec3 previousPosition = this.position();
        Vec3 previousDirection = this.getDeltaMovement();
        Vec3 impactPosition = blockHitResult.getLocation();
        Direction impactSide = blockHitResult.getDirection();
        double speed = this.getDeltaMovement().length();
        Vec3 surfaceNormal = this.getSurfaceNormal(impactSide);
        Vec3 newDirection = this.calculateBounceVector(previousDirection, surfaceNormal);
        double remainingDistance = previousDirection.length() - impactPosition.subtract(previousPosition).length();
        Vec3 finalPosition = impactPosition.add(newDirection.normalize().scale(remainingDistance));
        this.setPosRaw(finalPosition.x(), finalPosition.y(), finalPosition.z());
        this.setDeltaMovement(newDirection.scale(speed));
        ProjectileUtil.rotateTowardsMovement((Entity)this, (float)0.2f);
        --this.perks.bounce;
        if (this.perks.bounce_ricochet_sync) {
            --this.perks.ricochet;
        }
        this.hasImpulse = true;
        this.skipTravel = true;
        return true;
    }

    public Vec3 calculateBounceVector(Vec3 previousDirection, Vec3 normal) {
        return previousDirection.subtract(normal.scale(2.0 * previousDirection.dot(normal)));
    }

    public Vec3 getSurfaceNormal(Direction blockSide) {
        return switch (blockSide) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> new Vec3(0.0, -1.0, 0.0);
            case Direction.UP -> new Vec3(0.0, 1.0, 0.0);
            case Direction.NORTH -> new Vec3(0.0, 0.0, -1.0);
            case Direction.SOUTH -> new Vec3(0.0, 0.0, 1.0);
            case Direction.WEST -> new Vec3(-1.0, 0.0, 0.0);
            case Direction.EAST -> new Vec3(1.0, 0.0, 0.0);
        };
    }

    private void chainReactionFrom(Entity target) {
        if (this.perks == null || this.perks.chain_reaction_size <= 0 || this.perks.chain_reaction_triggers <= 0 || this.impactHistory.contains(target)) {
            return;
        }
        if (this.level().isClientSide) {
            return;
        }
        Holder<Spell> spellEntry = this.getSpellEntry();
        if (spellEntry == null) {
            return;
        }
        Vec3 position = this.position();
        int spawnCount = this.perks.chain_reaction_size;
        Vec3 launchVector = new Vec3(1.0, 0.0, 0.0).scale(this.getDeltaMovement().length());
        int launchAngle = 360 / spawnCount;
        float launchAngleOffset = random.nextFloat() * (float)launchAngle;
        this.impactHistory.add(target.getId());
        --this.perks.chain_reaction_triggers;
        this.perks.chain_reaction_size += this.perks.chain_reaction_increment;
        for (int i = 0; i < spawnCount; ++i) {
            SpellProjectile projectile = new SpellProjectile(this.level(), (LivingEntity)this.getOwner(), position.x(), position.y(), position.z(), this.getBehaviour(), spellEntry, this.context, this.perks.copy());
            float angle = (float)(launchAngle * i) + launchAngleOffset;
            projectile.setDeltaMovement(launchVector.yRot((float)Math.toRadians(angle)));
            projectile.range = this.range;
            ProjectileUtil.rotateTowardsMovement((Entity)projectile, (float)0.2f);
            projectile.impactHistory = new HashSet<Integer>(this.impactHistory);
            this.level().addFreshEntity((Entity)projectile);
        }
    }

    public SpellHelper.ImpactContext getImpactContext() {
        return this.context;
    }

    public ItemStack getItemStackModel() {
        return this.itemStackModel;
    }

    @Override
    public Spell.ProjectileModel renderData() {
        Spell.ProjectileData data = this.projectileData();
        if (data != null && data.client_data != null) {
            return data.client_data.model;
        }
        return null;
    }

    public ItemStack getItem() {
        Spell.ProjectileData data = this.projectileData();
        if (data != null && data.client_data != null && data.client_data.model != null) {
            return ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)data.client_data.model.model_id))).getDefaultInstance();
        }
        return ItemStack.EMPTY;
    }

    protected void onHitBlock(BlockHitResult blockHitResult) {
        Entity entity;
        super.onHitBlock(blockHitResult);
        if (this.bounceFrom(blockHitResult)) {
            return;
        }
        if (this.getOwner() != null && (entity = this.getOwner()) instanceof LivingEntity) {
            LivingEntity caster = (LivingEntity)entity;
            Vec3 hitPosition = blockHitResult.getLocation();
            boolean bl = SpellHelper.projectileImpact(caster, (Entity)this, null, this.getSpellEntry(), this.context.position(hitPosition));
        }
        this.kill();
    }

    public void setBehaviour(Behaviour behaviour) {
        this.getEntityData().set(TRACKER_BEHAVIOUR, (Object)behaviour.toString());
    }

    public Behaviour getBehaviour() {
        String string = (String)this.getEntityData().get(TRACKER_BEHAVIOUR);
        if (string == null || string.isEmpty()) {
            return Behaviour.FLY;
        }
        return Behaviour.valueOf(string);
    }

    public void setSpell(Holder<Spell> entry) {
        this.spellEntry = entry;
        if (!this.level().isClientSide) {
            this.getEntityData().set(TRACKER_SPELL_ID, (Object)this.spellId().toString());
        }
        this.refreshDimensions();
    }

    @Nullable
    public Holder<Spell> getSpellEntry() {
        return this.spellEntry;
    }

    private ResourceLocation spellId() {
        if (this.spellEntry != null) {
            return ((ResourceKey)this.spellEntry.unwrapKey().get()).location();
        }
        return null;
    }

    public void setFollowedTarget(Entity target) {
        this.followedTarget = target;
        this.distanceToFollow = target != null ? (double)target.distanceTo((Entity)this) : 0.0;
        int id = -1;
        if (!this.level().isClientSide) {
            if (target != null) {
                id = target.getId();
            }
            this.getEntityData().set(TRACKER_TARGET_ID, (Object)id);
        }
    }

    public void setItemStackModel(ItemStack itemStack) {
        ResourceLocation modelId = BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem());
        this.getEntityData().set(TRACKER_ITEM_MODEL_ID, (Object)modelId.toString());
    }

    private void updateItemModel(String idString) {
        if (idString != null && !idString.isEmpty()) {
            ResourceLocation id = ResourceLocation.parse((String)((String)this.getEntityData().get(TRACKER_ITEM_MODEL_ID)));
            this.itemStackModel = ((Item)BuiltInRegistries.ITEM.get(id)).getDefaultInstance();
        }
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putString(NBT_BEHAVIOUR, this.getBehaviour().toString());
        if (this.spellId() != null) {
            nbt.putString(NBT_SPELL_ID, this.spellId().toString());
        }
        nbt.putString(NBT_IMPACT_CONTEXT, this.gson.toJson((Object)this.context));
        nbt.putString(NBT_PERKS, this.gson.toJson((Object)this.perks));
        String itemModelId = (String)this.getEntityData().get(TRACKER_ITEM_MODEL_ID);
        if (!itemModelId.isEmpty()) {
            nbt.putString(NBT_ITEM_MODEL_ID, itemModelId);
        }
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        if (nbt.contains(NBT_SPELL_ID, 8)) {
            try {
                Behaviour behaviour = Behaviour.valueOf(nbt.getString(NBT_BEHAVIOUR));
                this.setBehaviour(behaviour);
                ResourceLocation spellId = ResourceLocation.parse((String)nbt.getString(NBT_SPELL_ID));
                this.setSpell((Holder<Spell>)((Holder)SpellRegistry.from(this.level()).getHolder(spellId).orElse(null)));
                this.context = (SpellHelper.ImpactContext)this.gson.fromJson(nbt.getString(NBT_IMPACT_CONTEXT), SpellHelper.ImpactContext.class);
                this.perks = (Spell.ProjectileData.Perks)this.gson.fromJson(nbt.getString(NBT_PERKS), Spell.ProjectileData.Perks.class);
                if (nbt.contains(NBT_ITEM_MODEL_ID, 8)) {
                    this.updateItemModel(nbt.getString(NBT_ITEM_MODEL_ID));
                }
            }
            catch (Exception e) {
                System.err.println("SpellProjectile - Failed to read spell data from NBT " + e.getMessage());
            }
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(TRACKER_SPELL_ID, (Object)"");
        builder.define(TRACKER_BEHAVIOUR, (Object)Behaviour.FLY.toString());
        builder.define(TRACKER_TARGET_ID, (Object)0);
        builder.define(TRACKER_ITEM_MODEL_ID, (Object)"");
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> data) {
        super.onSyncedDataUpdated(data);
        if (this.level().isClientSide) {
            if (data.equals(TRACKER_SPELL_ID)) {
                String spellId = (String)this.getEntityData().get(TRACKER_SPELL_ID);
                Holder.Reference spellEntry = SpellRegistry.from(this.level()).getHolder(ResourceLocation.parse((String)spellId)).orElse(null);
                this.setSpell((Holder<Spell>)spellEntry);
            }
            if (data.equals(TRACKER_ITEM_MODEL_ID)) {
                this.updateItemModel((String)this.getEntityData().get(TRACKER_ITEM_MODEL_ID));
            }
            if (data.equals(TRACKER_TARGET_ID)) {
                Integer id = (Integer)this.getEntityData().get(TRACKER_TARGET_ID);
                Entity target = id > 0 ? this.level().getEntity(id.intValue()) : null;
                this.setFollowedTarget(target);
            }
        }
    }

    static {
        random = new Random();
        NBT_BEHAVIOUR = "Behaviour";
        NBT_SPELL_ID = "Spell.ID";
        NBT_PERKS = "Perks";
        NBT_IMPACT_CONTEXT = "Impact.Context";
        NBT_ITEM_MODEL_ID = "Item.Model.ID";
        TRACKER_SPELL_ID = SynchedEntityData.defineId(SpellProjectile.class, (EntityDataSerializer)EntityDataSerializers.STRING);
        TRACKER_BEHAVIOUR = SynchedEntityData.defineId(SpellProjectile.class, (EntityDataSerializer)EntityDataSerializers.STRING);
        TRACKER_TARGET_ID = SynchedEntityData.defineId(SpellProjectile.class, (EntityDataSerializer)EntityDataSerializers.INT);
        TRACKER_ITEM_MODEL_ID = SynchedEntityData.defineId(SpellProjectile.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    }

    public static enum Behaviour {
        FLY,
        FALL;

    }
}

