/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.internals.delivery;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.internals.SpellTriggers;
import net.spell_engine.internals.arrow.ArrowExtension;
import net.spell_engine.internals.arrow.ArrowHelper;
import net.spell_engine.internals.delivery.SpellStash;
import net.spell_engine.internals.target.SpellTarget;
import net.spell_engine.utils.StatusEffectUtil;
import net.spell_power.api.SpellPower;
import net.spell_power.api.SpellSchool;

public class SpellStashHelper {
    public static void init() {
        ServerLifecycleEvents.SERVER_STARTING.register(SpellStashHelper::link);
    }

    private static void link(MinecraftServer minecraftServer) {
        RegistryAccess.Frozen manager = minecraftServer.registryAccess();
        Registry registry = manager.registryOrThrow(SpellRegistry.KEY);
        registry.holders().forEach(entry -> {
            Spell spell = (Spell)entry.value();
            ResourceLocation id = ((ResourceKey)entry.unwrapKey().get()).location();
            if (spell.deliver.type == Spell.Delivery.Type.STASH_EFFECT) {
                if (spell.deliver.stash_effect == null) {
                    System.err.println("Spell Engine: Stash spell linking error! Spell:" + String.valueOf(id) + " is missing `stash_effect`!");
                    return;
                }
                Spell.Delivery.StashEffect stashEffect = spell.deliver.stash_effect;
                if (stashEffect.id == null || stashEffect.id.isEmpty()) {
                    System.err.println("Spell Engine: Stash spell linking error! Spell:" + String.valueOf(id) + " is missing `stash_effect.id`!");
                    return;
                }
                List<Spell.Trigger> trigger = stashEffect.triggers;
                if (trigger == null || trigger.isEmpty()) {
                    System.err.println("Spell Engine: Stash spell linking error! Spell:" + String.valueOf(id) + " is missing `stash_effect.trigger`!");
                    return;
                }
                ResourceLocation effectId = ResourceLocation.parse((String)stashEffect.id);
                MobEffect statusEffect = (MobEffect)BuiltInRegistries.MOB_EFFECT.get(effectId);
                if (statusEffect == null) {
                    System.err.println("Spell Engine: Stash spell linking error! Spell:" + String.valueOf(id) + " found no status effect for `stash_effect.id`: " + stashEffect.id);
                    return;
                }
                List<SpellStash.Entry> stashes = SpellStash.getStashedSpells(statusEffect);
                for (SpellStash.Entry existingStash : stashes) {
                    if (!existingStash.spell().equals(entry)) continue;
                    System.err.println("Spell Engine: Stash spell linking error! Spell:" + String.valueOf(id) + " already has a stash effect linked to " + stashEffect.id);
                    return;
                }
                SpellStash.configure(statusEffect, (Holder<Spell>)entry, stashEffect.triggers, stashEffect.impact_mode, stashEffect.consume, stashEffect.consumed_next_tick, stashEffect.consume_any_stacks);
            }
        });
    }

    public static void useStashes(SpellTriggers.Event event) {
        Player caster = event.player;
        Level world = caster.level();
        HashMap<MobEffectInstance, StatusEffectUtil.Diff> effectChanges = new HashMap<MobEffectInstance, StatusEffectUtil.Diff>();
        Map activeEffects = Map.copyOf(caster.getActiveEffectsMap());
        for (Map.Entry entry : activeEffects.entrySet()) {
            MobEffect effect = (MobEffect)((Holder)entry.getKey()).value();
            MobEffectInstance stack = (MobEffectInstance)entry.getValue();
            block5: for (SpellStash.Entry stash : ((SpellStash)effect).getStashedSpells()) {
                Holder<Spell> spellEntry = stash.spell();
                for (Spell.Trigger trigger : stash.triggers()) {
                    if (spellEntry == null || trigger == null || !SpellTriggers.evaluateTrigger(spellEntry, trigger, event)) continue;
                    int consume = stash.consume();
                    int stacksAvailable = effectChanges.getOrDefault(stack, new StatusEffectUtil.Diff(stack, stack.getAmplifier(), stash.delayConsume() ? 1 : 0)).newAmplifier();
                    if (!stash.consume_any_stacks() && stacksAvailable + 1 < consume) continue;
                    switch (stash.impactMode()) {
                        case PERFORM: {
                            Entity target = event.target(trigger);
                            Entity aoeSource = event.aoeSource(trigger);
                            Spell spell = (Spell)stash.spell().value();
                            SpellPower.Result power = SpellPower.getSpellPower((SpellSchool)spell.school, (LivingEntity)event.player);
                            SpellHelper.ImpactContext impactContext = new SpellHelper.ImpactContext(1.0f, 1.0f, null, power, SpellTarget.FocusMode.DIRECT, 0);
                            impactContext = target != null ? impactContext.position(target.position()) : (aoeSource != null ? impactContext.position(aoeSource.position()) : impactContext.position(caster.position()));
                            SpellHelper.performImpacts(world, (LivingEntity)caster, target, aoeSource, spellEntry, ((Spell)spellEntry.value()).impacts, impactContext);
                            break;
                        }
                        case TRANSFER: {
                            ArrowExtension arrow = event.arrow;
                            if (arrow == null) break;
                            Player shooter = event.player;
                            Supplier trackers = Suppliers.memoize(() -> PlayerLookup.tracking((Entity)shooter));
                            ArrowHelper.onArrowShot(arrow, (LivingEntity)shooter, spellEntry, (java.util.function.Supplier<Collection<ServerPlayer>>)trackers);
                        }
                    }
                    if (consume == 0) continue block5;
                    effectChanges.put(stack, new StatusEffectUtil.Diff(stack, stacksAvailable - consume, stash.delayConsume() ? 1 : 0));
                    continue block5;
                }
            }
        }
        List<StatusEffectUtil.Diff> changes = effectChanges.values().stream().toList();
        StatusEffectUtil.applyChanges((LivingEntity)caster, changes);
    }
}

