/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.item;

import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponents;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.level.Level;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.SpellDataComponents;
import net.spell_engine.api.spell.SpellTagsNumbered;
import net.spell_engine.api.spell.container.SpellContainerHelper;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.api.tags.SpellTags;
import net.spell_engine.client.SpellEngineClient;
import org.jetbrains.annotations.Nullable;

public class ScrollItem
extends Item {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"spell_engine", (String)"scroll");

    public ScrollItem(Item.Properties settings) {
        super(settings);
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    @Nullable
    public static boolean applySpell(ItemStack itemStack, Holder<Spell> spellEntry, @Nullable TagKey<Spell> pool) {
        if (spellEntry.is(SpellTags.TREASURE)) {
            itemStack.set(SpellDataComponents.SPELL_CONTAINER, (Object)SpellContainerHelper.create(spellEntry, itemStack.getItem()));
            ScrollItem.onSpellAdded(itemStack, spellEntry, pool);
            return true;
        }
        return false;
    }

    public static void onSpellAdded(ItemStack itemStack, Holder<Spell> spellEntry, @Nullable TagKey<Spell> pool) {
        Spell spell = (Spell)spellEntry.value();
        int ordinal = Math.max(spell.tier - 1, 0);
        Rarity rarity = Rarity.values().length > ordinal ? Rarity.values()[ordinal] : Rarity.EPIC;
        itemStack.set(DataComponents.RARITY, (Object)rarity);
        if (pool != null) {
            int number = SpellTagsNumbered.get(pool.location());
            if (number != 0) {
                itemStack.set(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(number));
            }
            String key = "item." + pool.location().getNamespace() + "." + pool.location().getPath() + ".spell_scroll";
            if (Language.getInstance().has(key)) {
                itemStack.set(DataComponents.ITEM_NAME, (Object)Component.translatable((String)key));
            }
        }
    }

    @Nullable
    public static TagKey<Spell> resolveSpellPool(Level world, Holder<Spell> spellEntry) {
        Optional wrapper = world.registryAccess().lookup(SpellRegistry.KEY);
        if (wrapper.isPresent()) {
            return ScrollItem.resolveSpellPool((HolderLookup<Spell>)((HolderLookup)wrapper.get()), spellEntry);
        }
        return null;
    }

    @Nullable
    public static TagKey<Spell> resolveSpellPool(HolderLookup<Spell> wrapper, Holder<Spell> spellEntry) {
        Optional<HolderSet.Named> tag = wrapper.listTags().filter(t -> SpellTagsNumbered.isRegistered(((TagKey)t.unwrapKey().get()).location()) && t.contains(spellEntry)).findFirst();
        if (tag.isPresent()) {
            return (TagKey)tag.get().unwrapKey().get();
        }
        return null;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        if (SpellEngineClient.config.showSpellBindingTooltip) {
            tooltip.add((Component)Component.translatable((String)"item.spell_engine.scroll.table_hint").withStyle(ChatFormatting.GRAY));
        }
    }
}

