/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.mixin.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ArrowRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.client.render.SpellProjectileRenderer;
import net.spell_engine.internals.arrow.ArrowExtension;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ArrowRenderer.class})
public abstract class ProjectileEntityRendererMixin
extends EntityRenderer {
    private ItemRenderer itemRenderer;

    protected ProjectileEntityRendererMixin(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    @Inject(method={"<init>(Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;)V"}, at={@At(value="TAIL")})
    private void init_TAIL_SpellEngine(EntityRendererProvider.Context context, CallbackInfo ci) {
        this.itemRenderer = context.getItemRenderer();
    }

    @Inject(method={"render(Lnet/minecraft/world/entity/Entity;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void render_HEAD_SpellEngine(Entity entity, float yaw, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, CallbackInfo ci) {
        if (entity instanceof ArrowExtension) {
            ArrowExtension arrowExtension = (ArrowExtension)entity;
            for (Holder<Spell> spellEntry : arrowExtension.getCarriedSpells()) {
                Spell.ProjectileModel renderData;
                Spell.ArrowPerks arrowPerks = ((Spell)spellEntry.value()).arrow_perks;
                if (arrowPerks == null || (renderData = arrowPerks.override_render) == null) continue;
                ci.cancel();
                boolean allowSpin = !arrowExtension.isInGround_SpellEngine();
                boolean rendered = SpellProjectileRenderer.render(1.0f, this.entityRenderDispatcher, this.itemRenderer, renderData, Vec3.ZERO, entity, yaw, tickDelta, allowSpin, matrices, vertexConsumers, light);
                ci.cancel();
                if (rendered) {
                    super.render(entity, yaw, tickDelta, matrices, vertexConsumers, light);
                }
                return;
            }
        }
    }
}

