/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.mixin.effect;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.core.Holder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.spell_engine.api.entity.SpellEngineAttributes;
import net.spell_engine.api.event.CombatEvents;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityHealthImpacting {
    @Shadow
    public abstract double getAttributeValue(Holder<Attribute> var1);

    @ModifyVariable(method={"heal(F)V"}, at=@At(value="HEAD"), argsOnly=true)
    private float modifyHealingTaken_SpellEngine(float amount) {
        return amount * (float)SpellEngineAttributes.HEALING_TAKEN.asMultiplier(this.getAttributeValue(SpellEngineAttributes.HEALING_TAKEN.entry));
    }

    @ModifyVariable(method={"hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at=@At(value="HEAD"), argsOnly=true)
    public float modifyDamageTaken_SpellEngine(float amount) {
        return amount * (float)SpellEngineAttributes.DAMAGE_TAKEN.asMultiplier(this.getAttributeValue(SpellEngineAttributes.DAMAGE_TAKEN.entry));
    }

    @WrapOperation(method={"hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;actuallyHurt(Lnet/minecraft/world/damagesource/DamageSource;F)V")})
    private void damage_ApplyDamage_entity(LivingEntity instance, DamageSource source, float amount, Operation<Void> original) {
        if (CombatEvents.ENTITY_DAMAGE_INCOMING.isListened()) {
            CombatEvents.EntityDamageTaken.Args args = new CombatEvents.EntityDamageTaken.Args(instance, source, amount);
            CombatEvents.ENTITY_DAMAGE_INCOMING.invoke(listener -> listener.onDamageTaken(args));
        }
        if (instance instanceof Player) {
            Player player = (Player)instance;
            if (CombatEvents.PLAYER_DAMAGE_INCOMING.isListened()) {
                CombatEvents.PlayerDamageTaken.Args args = new CombatEvents.PlayerDamageTaken.Args(player, source, amount);
                CombatEvents.PLAYER_DAMAGE_INCOMING.invoke(listener -> listener.onPlayerDamageTaken(args));
            }
        }
        original.call(new Object[]{instance, source, Float.valueOf(amount *= (float)SpellEngineAttributes.DAMAGE_TAKEN.asMultiplier(this.getAttributeValue(SpellEngineAttributes.DAMAGE_TAKEN.entry)))});
    }
}

