/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.Nullable;

public class PatternMatching {
    public static final String ANY = "*";
    public static final String TAG_PREFIX = "#";
    public static final String REGEX_PREFIX = "~";
    public static final String NEGATE_PREFIX = "!";

    public static <T> boolean matches(Holder<T> entry, ResourceKey<Registry<T>> registryKey, @Nullable String pattern) {
        if (pattern == null || pattern.isEmpty() || pattern.equals(ANY)) {
            return true;
        }
        if (pattern.startsWith(NEGATE_PREFIX)) {
            return !PatternMatching.entryMatches(entry, registryKey, pattern.substring(1));
        }
        return PatternMatching.entryMatches(entry, registryKey, pattern);
    }

    public static <T> boolean entryMatches(Holder<T> entry, ResourceKey<Registry<T>> registryKey, String pattern) {
        if (pattern.startsWith(TAG_PREFIX)) {
            TagKey tag = TagKey.create(registryKey, (ResourceLocation)ResourceLocation.parse((String)pattern.substring(1)));
            return entry.is(tag);
        }
        String id = ((ResourceKey)entry.unwrapKey().get()).location().toString();
        if (pattern.startsWith(REGEX_PREFIX)) {
            return PatternMatching.regexMatches(id, pattern.substring(1));
        }
        return id.equals(pattern);
    }

    public static boolean regexMatches(String subject, String regex) {
        if (subject == null) {
            return false;
        }
        if (regex == null || regex.isEmpty()) {
            return true;
        }
        Pattern pattern = Pattern.compile(regex, 2);
        Matcher matcher = pattern.matcher(subject);
        return matcher.find();
    }
}

