/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.utils;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.spell_engine.api.spell.fx.Sound;

public class SoundHelper {
    public static void playSound(Level world, Entity entity, Sound sound) {
        if (sound == null) {
            return;
        }
        try {
            SoundEvent soundEvent = (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)sound.id()));
            SoundHelper.playSoundEvent(world, entity, soundEvent, sound.volume(), sound.randomizedPitch());
        }
        catch (Exception e) {
            System.err.println("Failed to play sound: " + sound.id());
            e.printStackTrace();
        }
    }

    public static void playSoundEvent(Level world, Entity entity, SoundEvent soundEvent) {
        SoundHelper.playSoundEvent(world, entity, soundEvent, 1.0f, 1.0f);
    }

    public static void playSoundEvent(Level world, Entity entity, SoundEvent soundEvent, float volume, float pitch) {
        world.playSound((Player)null, entity.getX(), entity.getY(), entity.getZ(), soundEvent, SoundSource.PLAYERS, volume, pitch);
    }
}

