/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.utils;

import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class VectorHelper {
    public static double angleBetween(Vec3 a, Vec3 b) {
        double cosineTheta = a.dot(b) / (a.length() * b.length());
        double angle = Math.acos(cosineTheta) * 57.29577951308232;
        if (Double.isNaN(angle)) {
            return 0.0;
        }
        return angle;
    }

    public static double angleWithSignBetween(Vec3 a, Vec3 b, Vec3 planeNormal) {
        double cosineTheta = a.dot(b) / (a.length() * b.length());
        double angle = Math.toDegrees(Math.acos(cosineTheta));
        Vec3 cross = a.cross(b);
        if (Double.isNaN(angle *= Math.signum(cross.dot(planeNormal)))) {
            return 0.0;
        }
        return angle;
    }

    public static Vec3 distanceVector(Vec3 point, AABB box) {
        double dx = 0.0;
        if (box.minX > point.x) {
            dx = box.minX - point.x;
        } else if (box.maxX < point.x) {
            dx = box.maxX - point.x;
        }
        double dy = 0.0;
        if (box.minY > point.y) {
            dy = box.minY - point.y;
        } else if (box.maxY < point.y) {
            dy = box.maxY - point.y;
        }
        double dz = 0.0;
        if (box.minZ > point.z) {
            dz = box.minZ - point.z;
        } else if (box.maxZ < point.z) {
            dz = box.maxZ - point.z;
        }
        return new Vec3(dx, dy, dz);
    }

    public static Vec3 rotateTowards(Vec3 vector, Vec3 towards, double angleToRotate) {
        Vec3 rotated;
        if (angleToRotate == 0.0) {
            return vector;
        }
        Vec3 originalVector = new Vec3(vector.x, vector.y, vector.z);
        double angleBetween = VectorHelper.angleWithSignBetween(vector = vector.normalize(), towards = towards.normalize(), vector.cross(towards));
        if (angleBetween == 0.0) {
            return originalVector;
        }
        if (angleBetween <= angleToRotate) {
            rotated = towards;
        } else {
            Vec3 v1 = vector;
            double towardsLength = Math.sin(Math.toRadians(angleToRotate)) / Math.cos(Math.toRadians(90.0 - angleBetween + angleToRotate));
            Vec3 v2 = towards.scale(towardsLength);
            rotated = v1.add(v2).normalize();
        }
        rotated = rotated.scale(originalVector.length());
        return rotated;
    }

    public static Vec3 axisFromRotation(float yaw, float pitch) {
        double yawRadians = Math.toRadians(-yaw);
        double pitchRadians = Math.toRadians(-pitch);
        double x = -Math.sin(yawRadians) * Math.cos(pitchRadians);
        double y = -Math.sin(pitchRadians);
        double z = Math.cos(yawRadians) * Math.cos(pitchRadians);
        return new Vec3(x, y, z).normalize();
    }

    public static Vec3 rotateAround(Vec3 vector, float angleDegrees, float yaw, float pitch) {
        Vec3 axisOfRotation = VectorHelper.axisFromRotation(yaw, pitch);
        return VectorHelper.rotateAround(vector, axisOfRotation, angleDegrees);
    }

    public static Vec3 rotateAround(Vec3 vector, Vec3 axisOfRotation, double angleDegrees) {
        double angleRadians = Math.toRadians(angleDegrees);
        double sinHalfAngle = Math.sin(angleRadians / 2.0);
        double cosHalfAngle = Math.cos(angleRadians / 2.0);
        double rx = axisOfRotation.x * sinHalfAngle;
        double ry = axisOfRotation.y * sinHalfAngle;
        double rz = axisOfRotation.z * sinHalfAngle;
        double rw = cosHalfAngle;
        double invRx = -rx;
        double invRy = -ry;
        double invRz = -rz;
        double invRw = rw;
        double[] q = VectorHelper.multiplyQuaternions(new double[]{rx, ry, rz, rw}, new double[]{vector.x, vector.y, vector.z, 0.0});
        double[] p = VectorHelper.multiplyQuaternions(q, new double[]{invRx, invRy, invRz, invRw});
        return new Vec3(p[0], p[1], p[2]);
    }

    private static double[] multiplyQuaternions(double[] q1, double[] q2) {
        double x = q1[3] * q2[0] + q1[0] * q2[3] + q1[1] * q2[2] - q1[2] * q2[1];
        double y = q1[3] * q2[1] + q1[1] * q2[3] + q1[2] * q2[0] - q1[0] * q2[2];
        double z = q1[3] * q2[2] + q1[2] * q2[3] + q1[0] * q2[1] - q1[1] * q2[0];
        double w = q1[3] * q2[3] - q1[0] * q2[0] - q1[1] * q2[1] - q1[2] * q2[2];
        return new double[]{x, y, z, w};
    }

    public static double yawFromNormalized(Vec3 vector) {
        return Math.toDegrees(Math.atan2(-vector.x, vector.z));
    }

    public static double pitchFromNormalized(Vec3 vector) {
        return Math.toDegrees(-Math.asin(vector.y));
    }
}

