/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.client.particle;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2400;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_4003;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.spell_engine.client.util.Color;
import net.spell_engine.fx.SpellEngineParticles;

public class UniversalSpellParticle
extends class_4003 {
    private static final class_5819 RANDOM = class_5819.method_43047();
    private final class_4002 spriteProvider;
    private final SpellEngineParticles.MagicParticleFamily.Motion motion;
    public boolean glows = true;
    public boolean translucent = true;

    UniversalSpellParticle(class_638 world, class_4002 spriteProvider, SpellEngineParticles.MagicParticleFamily.Motion motion, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
        super(world, x, y, z, 0.5 - RANDOM.method_43058(), velocityY, 0.5 - RANDOM.method_43058());
        this.spriteProvider = spriteProvider;
        this.motion = motion;
        switch (motion) {
            case FLOAT: 
            case DECELERATE: {
                this.field_28786 = 0.96f;
                this.field_3852 = this.field_3852 * (double)0.01f + velocityX;
                this.field_3869 = this.field_3869 * (double)0.01f + velocityY;
                this.field_3850 = this.field_3850 * (double)0.01f + velocityZ;
                this.field_3874 += (double)((this.field_3840.method_43057() - this.field_3840.method_43057()) * 0.05f);
                this.field_3854 += (double)((this.field_3840.method_43057() - this.field_3840.method_43057()) * 0.05f);
                this.field_3871 += (double)((this.field_3840.method_43057() - this.field_3840.method_43057()) * 0.05f);
                if (motion == SpellEngineParticles.MagicParticleFamily.Motion.DECELERATE) {
                    this.field_28786 *= 0.8f;
                }
                this.field_3847 = (int)(8.0 / (Math.random() * 0.8 + 0.2));
                break;
            }
            case ASCEND: {
                this.field_28786 = 0.96f;
                this.field_3844 = -0.1f;
                this.field_28787 = true;
                this.field_3869 *= 0.2;
                if (velocityX == 0.0 && velocityZ == 0.0) {
                    this.field_3852 *= (double)0.1f;
                    this.field_3850 *= (double)0.1f;
                }
                this.field_3847 = (int)(8.0 / (Math.random() * 0.8 + 0.2));
                break;
            }
            case BURST: {
                this.field_28786 = 0.7f;
                this.field_3844 = 0.5f;
                this.field_3852 *= (double)0.1f;
                this.field_3869 *= (double)0.1f;
                this.field_3850 *= (double)0.1f;
                this.field_3852 += velocityX * 0.4;
                this.field_3869 += velocityY * 0.4;
                this.field_3850 += velocityZ * 0.4;
                this.field_3847 = Math.max((int)(6.0 / (Math.random() * 0.8 + 0.6)), 1);
            }
        }
        this.method_18142(spriteProvider);
        this.field_3862 = false;
    }

    public class_3999 method_18122() {
        if (this.glows) {
            if (this.translucent) {
                return class_3999.field_17829;
            }
            return class_3999.field_17830;
        }
        if (this.translucent) {
            return class_3999.field_17829;
        }
        return class_3999.field_17828;
    }

    public int method_3068(float tint) {
        if (this.glows) {
            return 255;
        }
        return super.method_3068(tint);
    }

    @Environment(value=EnvType.CLIENT)
    public static class Opaque
    implements class_707<class_2400> {
        private final class_4002 spriteProvider;
        private final SpellEngineParticles.MagicParticleFamily.Motion motion;

        public Opaque(class_4002 spriteProvider, SpellEngineParticles.MagicParticleFamily.Motion motion) {
            this.spriteProvider = spriteProvider;
            this.motion = motion;
        }

        public class_703 createParticle(class_2400 SimpleParticleType, class_638 clientWorld, double d, double e, double f, double g, double h, double i) {
            UniversalSpellParticle particle = new UniversalSpellParticle(clientWorld, this.spriteProvider, this.motion, d, e, f, g, h, i);
            float j = clientWorld.field_9229.method_43057() * 0.25f + 0.7f;
            particle.method_3084(j, j, j);
            return particle;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class MagicVariant
    implements class_707<class_2400> {
        private final class_4002 spriteProvider;
        private final SpellEngineParticles.MagicParticleFamily.Variant particleVariant;

        public MagicVariant(class_4002 spriteProvider, SpellEngineParticles.MagicParticleFamily.Variant particleVariant) {
            this.spriteProvider = spriteProvider;
            this.particleVariant = particleVariant;
        }

        public class_703 createParticle(class_2400 SimpleParticleType, class_638 clientWorld, double d, double e, double f, double g, double h, double i) {
            UniversalSpellParticle particle = new UniversalSpellParticle(clientWorld, this.spriteProvider, this.particleVariant.motion(), d, e, f, g, h, i);
            particle.glows = true;
            float j = clientWorld.field_9229.method_43057() * 0.5f + 0.35f;
            Color color = this.particleVariant.color();
            particle.method_3084(color.red() * j, color.green() * j, color.blue() * j);
            particle.field_17867 *= 0.75f;
            switch (this.particleVariant.shape()) {
                case SPELL: 
                case STRIPE: {
                    particle.field_3841 = 1.0f;
                    break;
                }
                default: {
                    particle.field_3841 = 0.75f;
                }
            }
            return particle;
        }
    }
}

