/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.compat;

import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.TeamManager;
import dev.ftb.mods.ftbteams.api.client.ClientTeamManager;
import dev.ftb.mods.ftbteams.api.client.KnownClientPlayer;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.spell_engine.internals.target.EntityRelations;

public class FTBTeamsCompat {
    public static void init() {
        if (FabricLoader.getInstance().isModLoaded("ftbteams")) {
            EntityRelations.registerTeamMatcher("ftb", (attack, target) -> {
                if (attack instanceof class_1657) {
                    class_1657 attackerPlayer = (class_1657)attack;
                    if (target instanceof class_1657) {
                        class_1657 targetPlayer = (class_1657)target;
                        if (attackerPlayer.method_37908().method_8608()) {
                            return FTBTeamsCompat.checkClientTeamRelation(attackerPlayer, targetPlayer);
                        }
                        return FTBTeamsCompat.checkServerTeamRelation(attackerPlayer, targetPlayer);
                    }
                }
                return null;
            });
        }
    }

    private static EntityRelations.TeamRelation checkClientTeamRelation(class_1657 attackerPlayer, class_1657 targetPlayer) {
        if (!FTBTeamsAPI.api().isClientManagerLoaded()) {
            return null;
        }
        ClientTeamManager manager = FTBTeamsAPI.api().getClientManager();
        Optional attackerKnownPlayerOpt = manager.getKnownPlayer(attackerPlayer.method_5667());
        if (attackerKnownPlayerOpt.isEmpty()) {
            return null;
        }
        Optional targetKnownPlayerOpt = manager.getKnownPlayer(targetPlayer.method_5667());
        if (targetKnownPlayerOpt.isEmpty()) {
            return null;
        }
        KnownClientPlayer attackerKnownPlayer = (KnownClientPlayer)attackerKnownPlayerOpt.get();
        KnownClientPlayer targetKnownPlayer = (KnownClientPlayer)targetKnownPlayerOpt.get();
        if (attackerKnownPlayer.teamId().equals(targetKnownPlayer.teamId())) {
            return new EntityRelations.TeamRelation(true, false);
        }
        return null;
    }

    private static EntityRelations.TeamRelation checkServerTeamRelation(class_1657 attackerPlayer, class_1657 targetPlayer) {
        if (!FTBTeamsAPI.api().isManagerLoaded()) {
            return null;
        }
        TeamManager manager = FTBTeamsAPI.api().getManager();
        if (manager.arePlayersInSameTeam(attackerPlayer.method_5667(), targetPlayer.method_5667())) {
            return new EntityRelations.TeamRelation(true, false);
        }
        return null;
    }
}

