/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine;

import java.util.ArrayList;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.ConfigSerializer;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import me.shedaniel.autoconfig.serializer.PartitioningSerializer;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.event.registry.DynamicRegistries;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricEntityTypeBuilder;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.spell_engine.api.effect.RemoveOnHit;
import net.spell_engine.api.effect.StatusEffectClassification;
import net.spell_engine.api.item.set.EquipmentSetFeature;
import net.spell_engine.api.spell.ExternalSpellSchools;
import net.spell_engine.api.spell.event.SpellEvents;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.api.spell.weakness.SpellSchoolWeakness;
import net.spell_engine.compat.CompatFeatures;
import net.spell_engine.config.ServerConfig;
import net.spell_engine.config.ServerConfigWrapper;
import net.spell_engine.config.WeaknessConfig;
import net.spell_engine.entity.SpellCloud;
import net.spell_engine.entity.SpellProjectile;
import net.spell_engine.internals.SpellEngineCommands;
import net.spell_engine.internals.SpellTriggers;
import net.spell_engine.internals.container.SpellAssignments;
import net.spell_engine.internals.container.SpellContainerSource;
import net.spell_engine.internals.criteria.EnchantmentSpecificCriteria;
import net.spell_engine.internals.criteria.SpellCastCriteria;
import net.spell_engine.internals.delivery.SpellStashHelper;
import net.spell_engine.network.ServerNetwork;
import net.spell_engine.rpg_series.RPGSeriesCore;
import net.spell_engine.spellbinding.SpellBindRandomlyLootFunction;
import net.spell_engine.spellbinding.SpellBinding;
import net.spell_engine.spellbinding.SpellBindingBlock;
import net.spell_engine.spellbinding.SpellBindingBlockEntity;
import net.spell_engine.spellbinding.SpellBindingCriteria;
import net.spell_engine.spellbinding.SpellBindingScreenHandler;
import net.spell_engine.spellbinding.SpellBookCreationCriteria;
import net.spell_engine.utils.StatusEffectUtil;
import net.tiny_config.ConfigManager;

public class SpellEngineMod {
    public static final String ID = "spell_engine";
    public static ServerConfig config;
    public static ConfigManager<WeaknessConfig> weaknessConfig;

    public static String modName() {
        return I18n.get((String)"spell_engine.mod_name", (Object[])new Object[0]);
    }

    public static void init() {
        AutoConfig.register(ServerConfigWrapper.class, (ConfigSerializer.Factory)PartitioningSerializer.wrap(JanksonConfigSerializer::new));
        config = ((ServerConfigWrapper)AutoConfig.getConfigHolder(ServerConfigWrapper.class).getConfig()).server;
        weaknessConfig.refresh();
        DynamicRegistries.registerSynced(SpellRegistry.KEY, SpellRegistry.LOCAL_CODEC, SpellRegistry.NETWORK_CODEC_V2, (DynamicRegistries.SyncOption[])new DynamicRegistries.SyncOption[0]);
        SpellAssignments.init();
        ServerNetwork.init();
        SpellEvents.SPELL_CAST.register(args -> SpellCastCriteria.INSTANCE.trigger((ServerPlayer)args.caster(), args.spell()));
        ExternalSpellSchools.init();
        RPGSeriesCore.init();
        SpellStashHelper.init();
        SpellTriggers.init();
        SpellContainerSource.init();
        StatusEffectClassification.init();
        EquipmentSetFeature.init();
        CompatFeatures.initialize();
        SpellEngineCommands.register();
        ServerLivingEntityEvents.ALLOW_DAMAGE.register((entity, source, amount) -> {
            Entity attacker = source.getEntity();
            if (amount > 0.0f && attacker != null) {
                ArrayList<StatusEffectUtil.Diff> effectChanges = new ArrayList<StatusEffectUtil.Diff>();
                for (MobEffectInstance instance : entity.getActiveEffects()) {
                    Holder effect = instance.getEffect();
                    int remove = RemoveOnHit.removeCount(entity.level(), (MobEffect)effect.value(), source);
                    if (remove > 0) {
                        effectChanges.add(new StatusEffectUtil.Diff(instance, instance.getAmplifier() - remove));
                        continue;
                    }
                    if (remove >= 0) continue;
                    effectChanges.add(new StatusEffectUtil.Diff(instance, -1));
                }
                StatusEffectUtil.applyChanges(entity, effectChanges);
            }
            return true;
        });
    }

    public static void registerSpellBinding() {
        Registry.register((Registry)BuiltInRegistries.BLOCK, (ResourceLocation)SpellBinding.ID, (Object)((Object)SpellBindingBlock.INSTANCE));
        Registry.register((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (ResourceLocation)SpellBinding.ID, SpellBindingBlockEntity.ENTITY_TYPE);
        Registry.register((Registry)BuiltInRegistries.MENU, (ResourceLocation)SpellBinding.ID, SpellBindingScreenHandler.HANDLER_TYPE);
        Registry.register((Registry)BuiltInRegistries.LOOT_FUNCTION_TYPE, (ResourceLocation)SpellBindRandomlyLootFunction.ID, SpellBindRandomlyLootFunction.TYPE);
    }

    public static void registerEntityTypes() {
        SpellProjectile.ENTITY_TYPE = (EntityType)Registry.register((Registry)BuiltInRegistries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)ID, (String)"spell_projectile"), (Object)FabricEntityTypeBuilder.create((MobCategory)MobCategory.MISC, SpellProjectile::new).dimensions(EntityDimensions.fixed((float)0.25f, (float)0.25f)).fireImmune().trackRangeBlocks(128).trackedUpdateRate(2).build());
        SpellCloud.ENTITY_TYPE = (EntityType)Registry.register((Registry)BuiltInRegistries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)ID, (String)"spell_area_effect"), (Object)FabricEntityTypeBuilder.create((MobCategory)MobCategory.MISC, SpellCloud::new).dimensions(EntityDimensions.scalable((float)6.0f, (float)0.5f)).fireImmune().trackRangeBlocks(128).trackedUpdateRate(20).build());
    }

    public static void registerCriteria() {
        CriteriaTriggers.register((String)EnchantmentSpecificCriteria.ID.toString(), (CriterionTrigger)EnchantmentSpecificCriteria.INSTANCE);
        CriteriaTriggers.register((String)SpellCastCriteria.ID.toString(), (CriterionTrigger)SpellCastCriteria.INSTANCE);
        CriteriaTriggers.register((String)SpellBindingCriteria.ID.toString(), (CriterionTrigger)SpellBindingCriteria.INSTANCE);
        CriteriaTriggers.register((String)SpellBookCreationCriteria.ID.toString(), (CriterionTrigger)SpellBookCreationCriteria.INSTANCE);
    }

    static {
        weaknessConfig = new ConfigManager("elemental_weaknesses", (Object)SpellSchoolWeakness.createDefault()).builder().setDirectory(ID).sanitize(true).validate(WeaknessConfig::isValid).build();
    }
}

