/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.effect;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.spell_engine.api.spell.fx.ParticleBatch;
import net.spell_engine.fx.ParticleHelper;
import net.spell_engine.utils.SoundHelper;
import net.spell_engine.utils.StatusEffectUtil;
import org.jetbrains.annotations.Nullable;

public class Protection {
    public static final Map<ResourceKey<MobEffect>, Entry> PROTECTIONS = new HashMap<ResourceKey<MobEffect>, Entry>();

    public static void register(Holder<MobEffect> effectEntry, Pop pop) {
        Protection.register((ResourceKey<MobEffect>)((ResourceKey)effectEntry.unwrapKey().get()), new Entry(effectEntry, null, 1, pop, pop));
    }

    public static void register(Holder<MobEffect> effectEntry, TagKey<DamageType> protects, Pop pop) {
        Protection.register((ResourceKey<MobEffect>)((ResourceKey)effectEntry.unwrapKey().get()), new Entry(effectEntry, protects, 1, pop, pop));
    }

    public static void register(ResourceKey<MobEffect> key, Entry entry) {
        PROTECTIONS.put(key, entry);
    }

    public static boolean tryProtect(LivingEntity entity, DamageSource damageSource) {
        for (Map.Entry entry : entity.getActiveEffectsMap().entrySet()) {
            Pop pop;
            ResourceKey key;
            Entry protection;
            Optional optionalKey = ((Holder)entry.getKey()).unwrapKey();
            if (optionalKey.isEmpty() || (protection = PROTECTIONS.get(key = (ResourceKey)optionalKey.get())) == null || protection.protects != null && !damageSource.is(protection.protects)) continue;
            MobEffectInstance effect = (MobEffectInstance)entry.getValue();
            int newAmplifier = effect.getAmplifier() - protection.decrement;
            Pop pop2 = pop = newAmplifier < 0 ? protection.onRemove : protection.onDecrement;
            if (pop != null) {
                ParticleHelper.sendBatches((Entity)entity, pop.particles);
                if (pop.sound != null) {
                    SoundHelper.playSoundEvent(entity.level(), (Entity)entity, pop.sound);
                }
            }
            StatusEffectUtil.applyChanges(entity, List.of(new StatusEffectUtil.Diff(effect, newAmplifier)));
            return true;
        }
        return false;
    }

    public record Entry(Holder<MobEffect> effectEntry, TagKey<DamageType> protects, int decrement, Pop onDecrement, Pop onRemove) {
    }

    public record Pop(ParticleBatch[] particles, @Nullable SoundEvent sound) {
    }
}

