/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.effect;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.spell_engine.api.config.AttributeModifier;
import net.spell_engine.api.config.EffectConfig;
import net.spell_engine.api.effect.ActionImpairing;
import net.spell_engine.api.effect.CustomStatusEffect;
import net.spell_engine.api.effect.Effects;
import net.spell_engine.api.effect.EntityActionsAllowed;
import net.spell_engine.api.effect.Synchronized;

public class SpellEngineEffects {
    public static final List<Effects.Entry> entries = new ArrayList<Effects.Entry>();
    public static Effects.Entry STUN = SpellEngineEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"spell_engine", (String)"stun"), "Stunned", "Cannot move or act.", new CustomStatusEffect(MobEffectCategory.HARMFUL, 0x888800), new EffectConfig(List.of(new AttributeModifier(Attributes.JUMP_STRENGTH.getRegisteredName(), 0.0f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL)))));

    private static Effects.Entry add(Effects.Entry entry) {
        entries.add(entry);
        return entry;
    }

    public static void register() {
        ActionImpairing.configure(SpellEngineEffects.STUN.effect, EntityActionsAllowed.STUN);
        for (Effects.Entry entry : entries) {
            Synchronized.configure(entry.effect, true);
        }
        Effects.register(entries, new HashMap<String, EffectConfig>());
    }
}

