/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.entity;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.spell_engine.utils.PatternMatching;
import org.jetbrains.annotations.Nullable;

public class SpellEntityPredicates {
    private static final Map<String, Entry> entries = new HashMap<String, Entry>();
    public static final Entry TYPE_MATCHES = SpellEntityPredicates.register(ResourceLocation.fromNamespaceAndPath((String)"spell_engine", (String)"type_matches"), args -> {
        if (args.param == null) {
            return true;
        }
        return PatternMatching.matches(args.entity.getType().builtInRegistryHolder(), Registries.ENTITY_TYPE, args.param);
    });
    public static final Entry HAS_EFFECT = SpellEntityPredicates.register(ResourceLocation.fromNamespaceAndPath((String)"spell_engine", (String)"has_effect"), args -> {
        if (args.param == null) {
            return true;
        }
        Entity patt0$temp = args.entity;
        if (patt0$temp instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)patt0$temp;
            ResourceLocation id = ResourceLocation.parse((String)args.param);
            Optional effect = BuiltInRegistries.MOB_EFFECT.getHolder(id);
            if (effect.isEmpty()) {
                return false;
            }
            return livingEntity.hasEffect((Holder)effect.get());
        }
        return false;
    });
    public static final Entry HAS_BAD_EFFECT = SpellEntityPredicates.register(ResourceLocation.fromNamespaceAndPath((String)"spell_engine", (String)"has_bad_effect"), args -> {
        Entity patt0$temp = args.entity;
        if (patt0$temp instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)patt0$temp;
            for (MobEffectInstance instance : livingEntity.getActiveEffects()) {
                MobEffect effect = (MobEffect)instance.getEffect().value();
                if (effect.isBeneficial()) continue;
                return true;
            }
        }
        return false;
    });
    public static final Entry HAS_GOOD_EFFECT = SpellEntityPredicates.register(ResourceLocation.fromNamespaceAndPath((String)"spell_engine", (String)"has_good_effect"), args -> {
        Entity patt0$temp = args.entity;
        if (patt0$temp instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)patt0$temp;
            for (MobEffectInstance instance : livingEntity.getActiveEffects()) {
                MobEffect effect = (MobEffect)instance.getEffect().value();
                if (!effect.isBeneficial()) continue;
                return true;
            }
        }
        return false;
    });
    public static final Entry IS_ON_FIRE = SpellEntityPredicates.register(ResourceLocation.fromNamespaceAndPath((String)"spell_engine", (String)"is_on_fire"), args -> args.entity.isOnFire());
    public static final Entry IS_POISONED = SpellEntityPredicates.hasEffectOptimized(((ResourceKey)MobEffects.POISON.unwrapKey().get()).location());

    public static Entry register(ResourceLocation id, Predicate<Input> predicate) {
        Entry entry = new Entry(id, predicate);
        entries.put(id.toString(), entry);
        return entry;
    }

    public static Entry get(ResourceLocation id) {
        return entries.get(id.toString());
    }

    public static Entry get(String idString) {
        return entries.get(idString);
    }

    public static Entry registerOrGet(ResourceLocation id, Predicate<Input> predicate) {
        Entry entry = SpellEntityPredicates.get(id);
        if (entry == null) {
            entry = SpellEntityPredicates.register(id, predicate);
        }
        return entry;
    }

    public static Entry hasEffectOptimized(ResourceLocation effectId) {
        ResourceLocation predicateId = ResourceLocation.fromNamespaceAndPath((String)"has_effect_optimized", (String)(effectId.getNamespace() + "." + effectId.getPath()));
        return SpellEntityPredicates.registerOrGet(predicateId, args -> {
            Entity patt0$temp = args.entity;
            if (patt0$temp instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)patt0$temp;
                return livingEntity.hasEffect((Holder)BuiltInRegistries.MOB_EFFECT.getHolder(effectId).orElse(null));
            }
            return false;
        });
    }

    public record Entry(ResourceLocation id, Predicate<Input> predicate) {
    }

    public record Input(Entity entity, Entity other, @Nullable String param) {
    }
}

