/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.item;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.spell_engine.Platform;
import net.spell_engine.api.item.trinket.ISpellBookItem;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.container.SpellContainer;
import net.spell_engine.api.spell.container.SpellContainerTemplates;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.internals.container.SpellAssignments;
import net.spell_engine.item.SpellEngineItems;

public class SpellBooks {
    public static final ArrayList<ISpellBookItem> all = new ArrayList();

    public static List<ISpellBookItem> sorted(Level world) {
        return all.stream().sorted(Comparator.comparing(spellBookItem -> spellBookItem.getPoolId().toString())).filter(spellBookItem -> {
            List<Holder<Spell>> pool = SpellRegistry.entries(world, spellBookItem.getPoolId());
            return pool != null && !pool.isEmpty();
        }).collect(Collectors.toList());
    }

    public static ISpellBookItem create(ResourceLocation poolId) {
        return SpellBooks.create(poolId, SpellContainer.ContentType.MAGIC);
    }

    public static ISpellBookItem create(ResourceLocation poolId, SpellContainer.ContentType contentType) {
        return SpellBooks.create(poolId, contentType, 0);
    }

    public static ISpellBookItem create(ResourceLocation poolId, SpellContainer.ContentType contentType, int maxSpellCount) {
        SpellContainerTemplates.Config config = (SpellContainerTemplates.Config)SpellContainerTemplates.config.safeValue();
        SpellContainer baseContainer = config.spell_book != null ? config.spell_book : SpellContainerTemplates.defaults().spell_book;
        SpellContainer container = baseContainer.withContentType(contentType).withBindingPool(poolId).withMaxSpellCount(maxSpellCount);
        SpellAssignments.book_containers.put(SpellBooks.itemIdFor(poolId), container);
        Platform.util().awakeSlotModCompat();
        ISpellBookItem book = SpellEngineItems.createBook(poolId);
        all.add(book);
        return book;
    }

    public static ResourceLocation itemIdFor(ResourceLocation poolId) {
        return ResourceLocation.fromNamespaceAndPath((String)poolId.getNamespace(), (String)(poolId.getPath() + "_spell_book"));
    }

    public static void register(ISpellBookItem spellBook) {
        if (!(spellBook instanceof Item)) {
            throw new IllegalArgumentException("SpellBookItem must be an Item");
        }
        Registry.register((Registry)BuiltInRegistries.ITEM, (ResourceLocation)SpellBooks.itemIdFor(spellBook.getPoolId()), (Object)((Item)spellBook));
    }

    public static void createAndRegister(ResourceLocation poolId, ResourceKey<CreativeModeTab> itemGroupKey) {
        SpellBooks.createAndRegister(poolId, SpellContainer.ContentType.MAGIC, itemGroupKey);
    }

    public static void createAndRegister(ResourceLocation poolId, SpellContainer.ContentType contentType, ResourceKey<CreativeModeTab> itemGroupKey) {
        ISpellBookItem item = SpellBooks.create(poolId, contentType);
        ItemGroupEvents.modifyEntriesEvent(itemGroupKey).register(content -> content.accept((ItemLike)item));
        SpellBooks.register(item);
    }
}

