/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.spell.container;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.Level;
import net.spell_engine.api.item.trinket.ISpellBookItem;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.SpellDataComponents;
import net.spell_engine.api.spell.container.SpellContainer;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.api.tags.SpellEngineItemTags;
import net.spell_engine.internals.container.SpellAssignments;
import net.spell_power.api.SpellSchool;

public class SpellContainerHelper {
    public static final Comparator<Map.Entry<ResourceLocation, Spell>> spellSorter = (spell1, spell2) -> {
        if (((Spell)spell1.getValue()).tier > ((Spell)spell2.getValue()).tier) {
            return 1;
        }
        if (((Spell)spell1.getValue()).tier < ((Spell)spell2.getValue()).tier) {
            return -1;
        }
        return ((ResourceLocation)spell1.getKey()).toString().compareTo(((ResourceLocation)spell2.getKey()).toString());
    };

    public static SpellContainer createForRangedWeapon() {
        return SpellContainerHelper.createForWeapon(SpellContainer.ContentType.ARCHERY, List.of());
    }

    public static SpellContainer createForRangedWeapon(ResourceLocation spellId) {
        return SpellContainerHelper.createForWeapon(SpellContainer.ContentType.ARCHERY, List.of(spellId));
    }

    public static SpellContainer createForRangedWeapon(List<ResourceLocation> spellIds) {
        return SpellContainerHelper.createForWeapon(SpellContainer.ContentType.ARCHERY, spellIds);
    }

    public static SpellContainer createForMagicWeapon() {
        return SpellContainerHelper.createForWeapon(SpellContainer.ContentType.MAGIC, List.of());
    }

    public static SpellContainer createForMagicWeapon(ResourceLocation spellId) {
        return SpellContainerHelper.createForWeapon(SpellContainer.ContentType.MAGIC, List.of(spellId));
    }

    public static SpellContainer createForMeleeWeapon() {
        return SpellContainerHelper.createForWeapon(SpellContainer.ContentType.MAGIC, List.of());
    }

    public static SpellContainer createForMeleeWeapon(ResourceLocation spellId) {
        return SpellContainerHelper.createForWeapon(SpellContainer.ContentType.MAGIC, List.of(spellId));
    }

    public static SpellContainer createForWeapon(SpellContainer.ContentType contentType, List<ResourceLocation> spellIds) {
        List<String> spellIdStrings = spellIds.stream().map(ResourceLocation::toString).toList();
        return new SpellContainer(contentType, true, "", 0, spellIdStrings);
    }

    public static SpellContainer createForShield(ResourceLocation spellId) {
        return SpellContainerHelper.createForShield(List.of(spellId));
    }

    public static SpellContainer createForShield(List<ResourceLocation> spellIds) {
        return new SpellContainer(SpellContainer.ContentType.MAGIC, false, "", "offhand", 0, spellIds.stream().map(ResourceLocation::toString).toList());
    }

    public static SpellContainer createForRelic(ResourceLocation spellId) {
        return new SpellContainer(SpellContainer.ContentType.ANY, false, "", 0, List.of(spellId.toString()));
    }

    public static SpellContainer createForSpellHost(ResourceLocation spellId) {
        return new SpellContainer(SpellContainer.ContentType.MAGIC, false, "", 0, List.of(spellId.toString()));
    }

    public static SpellContainer createForModifier(ResourceLocation spellId) {
        return new SpellContainer(SpellContainer.ContentType.ANY, false, "", 0, List.of(spellId.toString()));
    }

    public static SpellContainer containerFromItemStack(ItemStack itemStack) {
        if (itemStack.isEmpty()) {
            return null;
        }
        SpellContainer component = (SpellContainer)itemStack.get(SpellDataComponents.SPELL_CONTAINER);
        if (component != null) {
            return component;
        }
        ResourceLocation id = ((ResourceKey)itemStack.getItem().builtInRegistryHolder().unwrapKey().get()).location();
        return SpellAssignments.containerForItem(id);
    }

    public static ResourceLocation getPoolId(SpellContainer container) {
        if (container != null && container.pool() != null) {
            return ResourceLocation.parse((String)container.pool());
        }
        return null;
    }

    public static boolean contains(SpellContainer container, ResourceLocation spellId) {
        return container != null && container.spell_ids().contains(spellId.toString());
    }

    public static List<String> sortedSpells(Level world, List<String> spellIds) {
        HashMap<ResourceLocation, Spell> spells = new HashMap<ResourceLocation, Spell>();
        for (String idString : spellIds) {
            ResourceLocation id = ResourceLocation.parse((String)idString);
            Holder.Reference spellEntry = SpellRegistry.from(world).getHolder(id).orElse(null);
            if (spellEntry == null) continue;
            spells.put(id, (Spell)spellEntry.value());
        }
        return spells.entrySet().stream().sorted(spellSorter).map(entry -> ((ResourceLocation)entry.getKey()).toString()).collect(Collectors.toList());
    }

    public static SpellContainer addSpell(Level world, ResourceLocation spellId, SpellContainer container) {
        ArrayList<String> spellIds = new ArrayList<String>(container.spell_ids());
        spellIds.add(spellId.toString());
        return container.copyWith(SpellContainerHelper.sortedSpells(world, spellIds));
    }

    public static void addSpell(Level world, ResourceLocation spellId, ItemStack itemStack) {
        SpellContainer container = SpellContainerHelper.containerFromItemStack(itemStack);
        if (container == null || !container.isValid()) {
            System.err.println("Trying to add spell: " + String.valueOf(spellId) + " to an ItemStack without valid spell container");
            return;
        }
        SpellContainer modifiedContainer = SpellContainerHelper.addSpell(world, spellId, container);
        itemStack.set(SpellDataComponents.SPELL_CONTAINER, (Object)modifiedContainer);
    }

    public static boolean hasValidContainer(ItemStack itemStack) {
        return SpellContainerHelper.containerFromItemStack(itemStack) != null;
    }

    public static boolean hasBindableContainer(ItemStack itemStack) {
        SpellContainer container = SpellContainerHelper.containerFromItemStack(itemStack);
        return container != null && container.pool() != null && !container.pool().isEmpty();
    }

    public static boolean hasUsableContainer(ItemStack itemStack) {
        SpellContainer container = SpellContainerHelper.containerFromItemStack(itemStack);
        return container != null && (container.isUsable() || container.is_proxy());
    }

    public static boolean isSpellValidForItem(Item item, Holder<Spell> spell) {
        SpellContainer.ContentType spellType = ((Spell)spell.value()).school.archetype == SpellSchool.Archetype.ARCHERY ? SpellContainer.ContentType.ARCHERY : SpellContainer.ContentType.MAGIC;
        SpellContainer.ContentType expectedContentType = item instanceof ProjectileWeaponItem ? SpellContainer.ContentType.ARCHERY : SpellContainer.ContentType.MAGIC;
        return spellType == expectedContentType;
    }

    public static SpellContainer.ContentType contentTypeForItem(ItemStack itemStack) {
        SpellContainer container = SpellContainerHelper.containerFromItemStack(itemStack);
        if (container != null) {
            return container.content();
        }
        Item item = itemStack.getItem();
        return item instanceof ProjectileWeaponItem ? SpellContainer.ContentType.ARCHERY : SpellContainer.ContentType.MAGIC;
    }

    public static SpellContainer.ContentType contentTypeForSpell(Spell spell) {
        return spell.school.archetype == SpellSchool.Archetype.ARCHERY ? SpellContainer.ContentType.ARCHERY : SpellContainer.ContentType.MAGIC;
    }

    public static SpellContainer create(Holder<Spell> spell, Item item) {
        return SpellContainerHelper.create(List.of(spell), item);
    }

    public static SpellContainer create(List<Holder<Spell>> spells, Item item) {
        SpellContainer.ContentType contentType = SpellContainerHelper.contentTypeForSpell((Spell)spells.get(0).value());
        boolean isProxy = !ISpellBookItem.isSpellBook(item) && !item.builtInRegistryHolder().is(SpellEngineItemTags.SPELL_BOOK_MERGEABLE);
        List<String> spellIds = spells.stream().filter(entry -> SpellContainerHelper.contentTypeForSpell((Spell)entry.value()) == contentType).map(entry -> ((ResourceKey)entry.unwrapKey().get()).location().toString()).toList();
        return new SpellContainer(contentType, isProxy, "", spellIds.size(), spellIds);
    }
}

