/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.spell_engine.api.render.CustomLayers;
import net.spell_engine.api.render.LightEmission;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.client.SpellEngineClient;
import net.spell_engine.client.beam.BeamEmitterEntity;
import net.spell_engine.client.compatibility.ShaderCompatibility;
import net.spell_engine.client.util.Color;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.internals.casting.SpellCasterEntity;
import net.spell_engine.internals.delivery.Beam;
import net.spell_engine.utils.TargetHelper;

public class BeamRenderer
extends RenderType {
    private static final Map<String, LayerSet> layerCache = new HashMap<String, LayerSet>();

    public static LayerSet layerSetFor(ResourceLocation texture, Spell.Target.Beam.Luminance luminance) {
        String key = texture.toString() + luminance.toString();
        if (layerCache.containsKey(key)) {
            return layerCache.get(key);
        }
        LayerSet layerSet = switch (luminance) {
            case Spell.Target.Beam.Luminance.LOW -> BeamRenderer.low(texture);
            case Spell.Target.Beam.Luminance.MEDIUM -> BeamRenderer.medium(texture);
            case Spell.Target.Beam.Luminance.HIGH -> BeamRenderer.high(texture);
            default -> BeamRenderer.low(texture);
        };
        layerCache.put(key, layerSet);
        return layerSet;
    }

    public static LayerSet vanilla(ResourceLocation texture) {
        return new LayerSet(CustomLayers.beam(texture, false, true), CustomLayers.spellObject(texture, LightEmission.GLOW, true));
    }

    public static LayerSet low(ResourceLocation texture) {
        return new LayerSet(CustomLayers.beam(texture, false, false), CustomLayers.beam(texture, false, true));
    }

    public static LayerSet medium(ResourceLocation texture) {
        return new LayerSet(CustomLayers.spellObject(texture, LightEmission.RADIATE, false), CustomLayers.beam(texture, false, true));
    }

    public static LayerSet high(ResourceLocation texture) {
        return new LayerSet(CustomLayers.spellObject(texture, LightEmission.RADIATE, false), CustomLayers.spellObject(texture, LightEmission.RADIATE, true));
    }

    public static void setup() {
        WorldRenderEvents.AFTER_TRANSLUCENT.register(context -> {
            MultiBufferSource.BufferSource vcProvider = Minecraft.getInstance().renderBuffers().bufferSource();
            BeamRenderer.renderAllInWorld(context, context.matrixStack(), vcProvider, context.camera(), 0xF000F0, context.tickCounter().getGameTimeDeltaPartialTick(true));
        });
    }

    public static void renderAllInWorld(WorldRenderContext context, PoseStack matrices, MultiBufferSource.BufferSource vertexConsumers, Camera camera, int light, float delta) {
        Entity focusedEntity = context.camera().getEntity();
        if (focusedEntity == null) {
            return;
        }
        int renderDistance = (Integer)Minecraft.getInstance().options.renderDistance().get() * 24;
        int squaredRenderDistance = renderDistance * renderDistance;
        List<AbstractClientPlayer> players = context.world().players().stream().filter(player -> player.distanceToSqr(focusedEntity) < (double)squaredRenderDistance && ((SpellCasterEntity)player).getBeam() != null).toList();
        if (players.isEmpty()) {
            return;
        }
        matrices.pushPose();
        Vec3 camPos = camera.getPosition();
        matrices.translate(-camPos.x, -camPos.y, -camPos.z);
        for (AbstractClientPlayer livingEntity : players) {
            float launchHeight = SpellHelper.launchHeight((LivingEntity)livingEntity);
            Vec3 offset = new Vec3(0.0, (double)launchHeight, (double)SpellHelper.launchPointOffsetDefault);
            SpellCasterEntity caster = (SpellCasterEntity)livingEntity;
            matrices.pushPose();
            Vec3 pos = new Vec3(livingEntity.xo, livingEntity.yo, livingEntity.zo).lerp(livingEntity.position(), (double)delta);
            matrices.translate(pos.x, pos.y, pos.z);
            Vec3 from = livingEntity.position().add(0.0, (double)launchHeight, 0.0);
            Vec3 lookVector = Vec3.ZERO;
            if (livingEntity == Minecraft.getInstance().player) {
                lookVector = Vec3.directionFromRotation((float)livingEntity.getXRot(), (float)livingEntity.getYRot());
            } else {
                lookVector = Vec3.directionFromRotation((float)livingEntity.xRotO, (float)livingEntity.yRotO);
                lookVector = lookVector.lerp(Vec3.directionFromRotation((float)livingEntity.getXRot(), (float)livingEntity.getYRot()), (double)delta);
            }
            lookVector = lookVector.normalize();
            Beam.Position beamPosition = TargetHelper.castBeam((LivingEntity)livingEntity, lookVector, 32.0f);
            lookVector = lookVector.scale((double)beamPosition.length());
            Vec3 to = from.add(lookVector);
            Spell.Target.Beam beamAppearance = caster.getBeam();
            BeamRenderer.renderBeamFromPlayer(matrices, (MultiBufferSource)vertexConsumers, beamAppearance, from, to, offset, livingEntity.level().getGameTime(), delta);
            ((BeamEmitterEntity)livingEntity).setLastRenderedBeam(new Beam.Rendered(beamPosition, beamAppearance));
            matrices.popPose();
        }
        vertexConsumers.endBatch();
        matrices.popPose();
    }

    private static void renderBeamFromPlayer(PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, Spell.Target.Beam beam, Vec3 from, Vec3 to, Vec3 offset, long time, float tickDelta) {
        LayerSet renderLayers;
        float absoluteTime = (float)Math.floorMod(time, 40) + tickDelta;
        matrixStack.pushPose();
        matrixStack.translate(0.0, offset.y, 0.0);
        Vec3 beamVector = to.subtract(from);
        float length = (float)beamVector.length();
        beamVector = beamVector.normalize();
        float n = (float)Math.acos(beamVector.y);
        float o = (float)Math.atan2(beamVector.z, beamVector.x);
        matrixStack.mulPose(Axis.YP.rotationDegrees((1.5707964f - o) * 57.295776f));
        matrixStack.mulPose(Axis.XP.rotationDegrees(n * 57.295776f));
        matrixStack.translate(0.0, offset.z, 0.0);
        matrixStack.mulPose(Axis.YP.rotationDegrees(absoluteTime * 2.25f - 45.0f));
        ResourceLocation texture = ResourceLocation.parse((String)beam.texture_id);
        Color.IntFormat outerColor = Color.IntFormat.fromLongRGBA(beam.color_rgba);
        Color.IntFormat innerColor = Color.IntFormat.fromLongRGBA(beam.inner_color_rgba);
        if (ShaderCompatibility.isVanillaRenderSystem()) {
            renderLayers = BeamRenderer.vanilla(texture);
        } else {
            Spell.Target.Beam.Luminance luminance = ShaderCompatibility.isShaderPackInUse() ? (SpellEngineClient.config.renderBeamsHighLuminance ? beam.luminance : Spell.Target.Beam.Luminance.MEDIUM) : Spell.Target.Beam.Luminance.LOW;
            renderLayers = BeamRenderer.layerSetFor(texture, luminance);
        }
        BeamRenderer.renderBeam(matrixStack, vertexConsumerProvider, time, tickDelta, beam.flow, true, innerColor, outerColor, renderLayers, 0.0f, length, beam.width);
        matrixStack.popPose();
    }

    public BeamRenderer(String name, VertexFormat vertexFormat, VertexFormat.Mode drawMode, int expectedBufferSize, boolean hasCrumbling, boolean translucent, Runnable startAction, Runnable endAction) {
        super(name, vertexFormat, drawMode, expectedBufferSize, hasCrumbling, translucent, startAction, endAction);
    }

    public static void renderBeam(PoseStack matrices, MultiBufferSource vertexConsumers, long time, float tickDelta, float direction, boolean center, Color.IntFormat innerColor, Color.IntFormat outerColor, LayerSet renderLayers, float yOffset, float height, float width) {
        matrices.pushPose();
        float shift = (float)Math.floorMod(time, 40) + tickDelta;
        float offset = Mth.frac((float)(shift * 0.2f - (float)Mth.floor((float)(shift * 0.1f)))) * -direction;
        float originalWidth = width;
        if (center) {
            BeamRenderer.renderBeamLayer(matrices, vertexConsumers.getBuffer(renderLayers.inner()), innerColor.red(), innerColor.green(), innerColor.blue(), innerColor.alpha(), yOffset, height, 0.0f, width, width, 0.0f, -width, 0.0f, 0.0f, -width, 0.0f, 1.0f, height, offset);
        }
        width = originalWidth * 1.5f;
        BeamRenderer.renderBeamLayer(matrices, vertexConsumers.getBuffer(renderLayers.outer()), outerColor.red(), outerColor.green(), outerColor.blue(), (int)((float)outerColor.alpha() * 0.75f), yOffset, height, 0.0f, width, width, 0.0f, -width, 0.0f, 0.0f, -width, 0.0f, 1.0f, height, offset * 0.9f);
        width = originalWidth * 2.0f;
        BeamRenderer.renderBeamLayer(matrices, vertexConsumers.getBuffer(renderLayers.outer()), outerColor.red(), outerColor.green(), outerColor.blue(), outerColor.alpha() / 3, yOffset, height, 0.0f, width, width, 0.0f, -width, 0.0f, 0.0f, -width, 0.0f, 1.0f, height, offset * 0.8f);
        matrices.popPose();
    }

    private static void renderBeamLayer(PoseStack matrices, VertexConsumer vertices, int red, int green, int blue, int alpha, float yOffset, float height, float x1, float z1, float x2, float z2, float x3, float z3, float x4, float z4, float u1, float u2, float v1, float v2) {
        PoseStack.Pose matrix = matrices.last();
        BeamRenderer.renderBeamFace(matrix, vertices, red, green, blue, alpha, yOffset, height, x1, z1, x2, z2, u1, u2, v1, v2);
        BeamRenderer.renderBeamFace(matrix, vertices, red, green, blue, alpha, yOffset, height, x4, z4, x3, z3, u1, u2, v1, v2);
        BeamRenderer.renderBeamFace(matrix, vertices, red, green, blue, alpha, yOffset, height, x2, z2, x4, z4, u1, u2, v1, v2);
        BeamRenderer.renderBeamFace(matrix, vertices, red, green, blue, alpha, yOffset, height, x3, z3, x1, z1, u1, u2, v1, v2);
    }

    private static void renderBeamFace(PoseStack.Pose matrix, VertexConsumer vertices, int red, int green, int blue, int alpha, float yOffset, float height, float x1, float z1, float x2, float z2, float u1, float u2, float v1, float v2) {
        BeamRenderer.renderBeamVertex(matrix, vertices, red, green, blue, alpha, height, x1, z1, u2, v1);
        BeamRenderer.renderBeamVertex(matrix, vertices, red, green, blue, alpha, yOffset, x1, z1, u2, v2);
        BeamRenderer.renderBeamVertex(matrix, vertices, red, green, blue, alpha, yOffset, x2, z2, u1, v2);
        BeamRenderer.renderBeamVertex(matrix, vertices, red, green, blue, alpha, height, x2, z2, u1, v1);
    }

    private static void renderBeamVertex(PoseStack.Pose matrix, VertexConsumer vertices, int red, int green, int blue, int alpha, float y, float x, float z, float u, float v) {
        vertices.addVertex(matrix, x, y, z).setColor(red, green, blue, alpha).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(matrix, 0.0f, 1.0f, 0.0f);
    }

    public record LayerSet(RenderType inner, RenderType outer) {
    }
}

