/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.compat;

import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.critical_strike.api.CriticalDamageSource;
import net.critical_strike.internal.CriticalStriker;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.spell_engine.api.spell.ExternalSpellSchools;
import net.spell_power.api.SpellSchool;

public class CriticalStrikeCompat {
    private static Predicate<DamageSource> isCriticalStrike = ds -> false;
    private static BiConsumer<DamageSource, Float> setCriticalStrike = (ds, crit) -> {};

    public static void init() {
        if (FabricLoader.getInstance().isModLoaded("critical_strike")) {
            isCriticalStrike = ds -> ((CriticalDamageSource)ds).rng_isCritical();
            setCriticalStrike = (ds, multiplier) -> ((CriticalDamageSource)ds).rng_setCriticalDamageMultiplier(multiplier.floatValue());
            ExternalSpellSchools.PHYSICAL_RANGED.addSource(SpellSchool.Trait.CRIT_CHANCE, SpellSchool.Apply.ADD, query -> {
                LivingEntity patt0$temp = query.entity();
                if (patt0$temp instanceof CriticalStriker) {
                    CriticalStriker criticalStriker = (CriticalStriker)patt0$temp;
                    return criticalStriker.rng_criticalChance();
                }
                return 0.0;
            });
            ExternalSpellSchools.PHYSICAL_RANGED.addSource(SpellSchool.Trait.CRIT_DAMAGE, SpellSchool.Apply.ADD, query -> {
                LivingEntity patt0$temp = query.entity();
                if (patt0$temp instanceof CriticalStriker) {
                    CriticalStriker criticalStriker = (CriticalStriker)patt0$temp;
                    return criticalStriker.rng_criticalDamageMultiplier() - 1.0;
                }
                return 0.0;
            });
            ExternalSpellSchools.PHYSICAL_MELEE.addSource(SpellSchool.Trait.CRIT_CHANCE, SpellSchool.Apply.ADD, query -> {
                LivingEntity patt0$temp = query.entity();
                if (patt0$temp instanceof CriticalStriker) {
                    CriticalStriker criticalStriker = (CriticalStriker)patt0$temp;
                    return criticalStriker.rng_criticalChance();
                }
                return 0.0;
            });
            ExternalSpellSchools.PHYSICAL_MELEE.addSource(SpellSchool.Trait.CRIT_DAMAGE, SpellSchool.Apply.ADD, query -> {
                LivingEntity patt0$temp = query.entity();
                if (patt0$temp instanceof CriticalStriker) {
                    CriticalStriker criticalStriker = (CriticalStriker)patt0$temp;
                    return criticalStriker.rng_criticalDamageMultiplier() - 1.0;
                }
                return 0.0;
            });
        }
    }

    public static boolean isCriticalStrike(DamageSource damageSource) {
        if (damageSource == null) {
            return false;
        }
        return isCriticalStrike.test(damageSource);
    }

    public static void setCriticalStrike(DamageSource damageSource, float critMultiplier) {
        if (damageSource == null) {
            return;
        }
        setCriticalStrike.accept(damageSource, Float.valueOf(critMultiplier));
    }
}

