/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.compat.accessories;

import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.events.AccessoryChangeCallback;
import io.wispforest.accessories.impl.ExpandedSimpleContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.util.TriState;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.spell_engine.api.item.trinket.ISpellBookItem;
import net.spell_engine.api.spell.container.SpellContainer;
import net.spell_engine.api.spell.container.SpellContainerHelper;
import net.spell_engine.compat.accessories.AccessoriesItemHelper;
import net.spell_engine.compat.container.ContainerCompat;
import net.spell_engine.internals.container.SpellContainerSource;

public class AccessoriesCompat {
    private static final String MOD_ID = "accessories";
    private static final String SLOT_SPELL_BOOK = "spell_book";
    private static boolean intialized = false;
    private static boolean enabled = false;

    public static boolean init() {
        if (intialized) {
            return enabled;
        }
        intialized = true;
        enabled = FabricLoader.getInstance().isModLoaded(MOD_ID);
        if (!enabled) {
            return enabled;
        }
        AccessoriesAPI.registerPredicate((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"spell_engine", (String)SLOT_SPELL_BOOK), (world, slotType, i, itemStack) -> {
            if (ISpellBookItem.isSpellBook(itemStack.getItem())) {
                return TriState.TRUE;
            }
            return TriState.DEFAULT;
        });
        ContainerCompat.addProvider(AccessoriesCompat::getAll);
        String spellSourceName = MOD_ID;
        SpellContainerSource.addItemSource(SpellContainerSource.ItemEntry.of(MOD_ID, (player, name) -> AccessoriesCompat.getEquippedStacks(player)), SpellContainerSource.MAIN_HAND.name());
        AccessoryChangeCallback.EVENT.register((prevStack, currentStack, slotReference, stateChange) -> {
            LivingEntity patt0$temp = slotReference.entity();
            if (patt0$temp instanceof Player) {
                Player player = (Player)patt0$temp;
                SpellContainerSource.setDirty(player, MOD_ID);
            }
        });
        AccessoriesItemHelper.register();
        return enabled;
    }

    private static List<ItemStack> getAll(Player player) {
        Optional capability = AccessoriesCapability.getOptionally((LivingEntity)player);
        if (capability.isEmpty()) {
            return List.of();
        }
        ArrayList<ItemStack> accessories = new ArrayList<ItemStack>();
        AccessoriesCapability accessoriesContainer = (AccessoriesCapability)capability.get();
        accessoriesContainer.getContainers().forEach((slotType, container) -> {
            ExpandedSimpleContainer accessoriesInv = container.getAccessories();
            for (int i = 0; i < accessoriesInv.getContainerSize(); ++i) {
                ItemStack stack = accessoriesInv.getItem(i);
                if (stack.isEmpty()) continue;
                accessories.add(stack);
            }
        });
        return accessories;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static List<SpellContainerSource.SourcedContainer> getSpellContainers(Player player, String sourceName) {
        Optional capability = AccessoriesCapability.getOptionally((LivingEntity)player);
        if (capability.isEmpty()) {
            return List.of();
        }
        ArrayList<SpellContainerSource.SourcedContainer> spellBooks = new ArrayList<SpellContainerSource.SourcedContainer>();
        ArrayList others = new ArrayList();
        AccessoriesCapability accessoriesContainer = (AccessoriesCapability)capability.get();
        accessoriesContainer.getContainers().forEach((slotType, container) -> {
            ExpandedSimpleContainer accessoriesInv = container.getAccessories();
            for (int i = 0; i < accessoriesInv.getContainerSize(); ++i) {
                SpellContainer spellContainer;
                ItemStack stack = accessoriesInv.getItem(i);
                if (stack.isEmpty() || (spellContainer = SpellContainerHelper.containerFromItemStack(stack)) == null || !spellContainer.isValid()) continue;
                if (slotType.contains(SLOT_SPELL_BOOK)) {
                    spellBooks.add(new SpellContainerSource.SourcedContainer(sourceName, stack, spellContainer));
                    continue;
                }
                others.add(new SpellContainerSource.SourcedContainer(sourceName, stack, spellContainer));
            }
        });
        spellBooks.addAll(others);
        return spellBooks;
    }

    public static List<ItemStack> getEquippedStacks(Player player) {
        Optional capability = AccessoriesCapability.getOptionally((LivingEntity)player);
        if (capability.isEmpty()) {
            return List.of();
        }
        ArrayList<ItemStack> equipped = new ArrayList<ItemStack>();
        AccessoriesCapability accessoriesContainer = (AccessoriesCapability)capability.get();
        accessoriesContainer.getContainers().forEach((slotType, container) -> {
            ExpandedSimpleContainer accessoriesInv = container.getAccessories();
            for (int i = 0; i < accessoriesInv.getContainerSize(); ++i) {
                ItemStack stack = accessoriesInv.getItem(i);
                if (stack.isEmpty()) continue;
                if (slotType.contains(SLOT_SPELL_BOOK)) {
                    equipped.addFirst(stack);
                    continue;
                }
                equipped.add(stack);
            }
        });
        return equipped;
    }

    public static ItemStack getSpellBookStack(Player player) {
        ExpandedSimpleContainer accessoriesInv;
        if (!enabled) {
            return ItemStack.EMPTY;
        }
        Optional capability = AccessoriesCapability.getOptionally((LivingEntity)player);
        if (capability.isEmpty()) {
            return ItemStack.EMPTY;
        }
        AccessoriesContainer container = (AccessoriesContainer)((AccessoriesCapability)capability.get()).getContainers().get(SLOT_SPELL_BOOK);
        if (container != null && !(accessoriesInv = container.getAccessories()).isEmpty()) {
            return accessoriesInv.getItem(0);
        }
        return ItemStack.EMPTY;
    }
}

